/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToolBarData;
import generic.theme.GIcon;
import ghidra.app.decompiler.CTokenHighlightMatcher;
import ghidra.app.decompiler.ClangBreak;
import ghidra.app.decompiler.ClangCommentToken;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangSyntaxToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangTypeToken;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.app.decompiler.DecompilerHighlightService;
import ghidra.app.decompiler.DecompilerHighlighter;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.DecompilerProvider;
import ghidra.app.plugin.core.decompiler.taint.TaintCTokenHighlighterPalette;
import ghidra.app.plugin.core.decompiler.taint.TaintHighlight;
import ghidra.app.plugin.core.decompiler.taint.TaintLabelsDataFrame;
import ghidra.app.plugin.core.decompiler.taint.TaintLabelsTableProvider;
import ghidra.app.plugin.core.decompiler.taint.TaintOptions;
import ghidra.app.plugin.core.decompiler.taint.TaintPlugin;
import ghidra.app.plugin.core.decompiler.taint.TaintQueryResult;
import ghidra.app.plugin.core.decompiler.taint.TaintState;
import ghidra.app.plugin.core.decompiler.taint.actions.TaintClearAction;
import ghidra.app.plugin.core.decompiler.taint.actions.TaintGateAction;
import ghidra.app.plugin.core.decompiler.taint.actions.TaintLoadAction;
import ghidra.app.plugin.core.decompiler.taint.actions.TaintQueryAction;
import ghidra.app.plugin.core.decompiler.taint.actions.TaintQueryCustomAction;
import ghidra.app.plugin.core.decompiler.taint.actions.TaintQueryDefaultAction;
import ghidra.app.plugin.core.decompiler.taint.actions.TaintSetSizeAction;
import ghidra.app.plugin.core.decompiler.taint.actions.TaintSinkAction;
import ghidra.app.plugin.core.decompiler.taint.actions.TaintSinkBySymbolAction;
import ghidra.app.plugin.core.decompiler.taint.actions.TaintSliceTreeAction;
import ghidra.app.plugin.core.decompiler.taint.actions.TaintSourceAction;
import ghidra.app.plugin.core.decompiler.taint.actions.TaintSourceBySymbolAction;
import ghidra.app.services.CodeViewerService;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.util.ProgramSelection;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaintProvider
extends ComponentProviderAdapter
implements OptionsChangeListener {
    private static final Logger log = LogManager.getLogger(TaintProvider.class);
    private static final String OPTIONS_TITLE = "Decompiler";
    private TaintPlugin plugin;
    private TaintOptions taintOptions;
    private Program program;
    private DecompilerProvider decompilerProvider;
    private Navigatable navigatable;
    private DecompilerHighlighter highlighter;
    private TaintCTokenHighlighterPalette highlightPalette;
    private int paletteIndex;
    private int matchCount = 0;
    private Map<String, Color> cachedHighlightsByToken;
    private Map<Address, TaintHighlight> cachedHighlightByAddress;
    private static String showTaintLabelEditTableIcoString = "icon.dialog.error.expandable.stack";
    private static Icon showTaintLabelEditTableIcon = new GIcon(showTaintLabelEditTableIcoString);

    public TaintProvider(TaintPlugin plugin) {
        super(plugin.getTool(), "TaintProvider", plugin.getName(), DecompilerActionContext.class);
        this.plugin = plugin;
        this.taintOptions = new TaintOptions(this);
        this.cachedHighlightsByToken = new HashMap<String, Color>();
        this.cachedHighlightByAddress = new HashMap<Address, TaintHighlight>();
        this.highlightPalette = new TaintCTokenHighlighterPalette(256);
        this.paletteIndex = 0;
        this.initializeDecompilerOptions();
    }

    public TaintOptions getOptions() {
        return this.taintOptions;
    }

    public JComponent getComponent() {
        this.decompilerProvider = this.plugin.getDecompilerProvider();
        return this.decompilerProvider.getComponent();
    }

    private void createActions(ComponentProvider provider, boolean isConnected) {
        String variableGroup = "2 - Variable Group";
        int subGroupPosition = 0;
        TaintSourceAction taintSourceAction = new TaintSourceAction(this.plugin);
        this.setGroupInfo(taintSourceAction, variableGroup, subGroupPosition++);
        TaintSourceBySymbolAction taintSourceBySymbolAction = new TaintSourceBySymbolAction(this.plugin);
        this.setGroupInfo(taintSourceBySymbolAction, variableGroup, subGroupPosition++);
        TaintSinkAction taintSinkAction = new TaintSinkAction(this.plugin);
        this.setGroupInfo(taintSinkAction, variableGroup, subGroupPosition++);
        TaintSinkBySymbolAction taintSinkBySymbolAction = new TaintSinkBySymbolAction(this.plugin);
        this.setGroupInfo(taintSinkBySymbolAction, variableGroup, subGroupPosition++);
        TaintGateAction taintGateAction = new TaintGateAction(this.plugin);
        this.setGroupInfo(taintGateAction, variableGroup, subGroupPosition++);
        TaintClearAction taintClearAction = new TaintClearAction(this.plugin);
        this.setGroupInfo(taintClearAction, variableGroup, subGroupPosition++);
        TaintSetSizeAction taintSizeAction = new TaintSetSizeAction(this.plugin);
        this.setGroupInfo(taintSizeAction, variableGroup, subGroupPosition++);
        TaintQueryAction taintQueryAction = new TaintQueryAction(this.plugin);
        TaintQueryDefaultAction taintQueryDefaultAction = new TaintQueryDefaultAction(this.plugin);
        TaintQueryCustomAction taintQueryCustomAction = new TaintQueryCustomAction(this.plugin);
        TaintLoadAction taintLoadAction = new TaintLoadAction(this.plugin);
        TaintSliceTreeAction taintSliceTreeAction = new TaintSliceTreeAction(this.plugin);
        DockingAction taintLabelTableAction = new DockingAction("TaintShowLabels", "DecompilerTaint"){

            public void actionPerformed(ActionContext context) {
                TaintLabelsDataFrame df = new TaintLabelsDataFrame(TaintProvider.this.plugin);
                df.loadData();
                TaintLabelsTableProvider table_provider = new TaintLabelsTableProvider(this.getName(), TaintProvider.this.plugin, df);
                table_provider.addToTool();
                table_provider.setVisible(true);
            }

            public boolean isEnabledForContext(ActionContext context) {
                TaintState state = TaintProvider.this.plugin.getTaintState();
                return state == null ? false : state.hasMarks();
            }
        };
        taintLabelTableAction.setMenuBarData(new MenuData(new String[]{"Source-Sink", taintLabelTableAction.getName()}));
        taintLabelTableAction.setToolBarData(new ToolBarData(showTaintLabelEditTableIcon));
        provider.addLocalAction((DockingActionIf)taintSliceTreeAction);
        provider.addLocalAction((DockingActionIf)taintLabelTableAction);
        provider.addLocalAction((DockingActionIf)taintSourceAction);
        provider.addLocalAction((DockingActionIf)taintSourceBySymbolAction);
        provider.addLocalAction((DockingActionIf)taintSinkAction);
        provider.addLocalAction((DockingActionIf)taintSinkBySymbolAction);
        provider.addLocalAction((DockingActionIf)taintGateAction);
        provider.addLocalAction((DockingActionIf)taintQueryAction);
        provider.addLocalAction((DockingActionIf)taintQueryDefaultAction);
        provider.addLocalAction((DockingActionIf)taintQueryCustomAction);
        provider.addLocalAction((DockingActionIf)taintLoadAction);
        provider.addLocalAction((DockingActionIf)taintClearAction);
        provider.addLocalAction((DockingActionIf)taintSizeAction);
    }

    private void setGroupInfo(DockingAction action, String group, int subGroupPosition) {
        MenuData popupMenuData = action.getPopupMenuData();
        popupMenuData.setMenuGroup(group);
        popupMenuData.setMenuSubGroup(Integer.toString(subGroupPosition));
    }

    public void componentShown() {
        if (this.program != null) {
            ToolOptions opt = this.tool.getOptions(OPTIONS_TITLE);
            this.taintOptions.grabFromToolAndProgram((Plugin)this.plugin, opt, this.program);
        }
    }

    public void doSetProgram(Program newProgram) {
        this.program = newProgram;
        if (this.program != null) {
            ToolOptions opt = this.tool.getOptions(OPTIONS_TITLE);
            this.taintOptions.grabFromToolAndProgram((Plugin)this.plugin, opt, this.program);
        }
    }

    private void initializeDecompilerOptions() {
        ToolOptions opt = this.tool.getOptions(OPTIONS_TITLE);
        this.taintOptions.registerOptions((Plugin)this.plugin, opt, this.program);
        opt.addOptionsChangeListener((OptionsChangeListener)this);
        ToolOptions codeBrowserOptions = this.tool.getOptions("Listing Fields");
        codeBrowserOptions.addOptionsChangeListener((OptionsChangeListener)this);
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        if (options.getName().equals(OPTIONS_TITLE) || options.getName().equals("Listing Fields")) {
            this.doRefresh();
        }
    }

    private void doRefresh() {
        ToolOptions opt = this.tool.getOptions(OPTIONS_TITLE);
        this.taintOptions.grabFromToolAndProgram((Plugin)this.plugin, opt, this.program);
    }

    public void programClosed(Program closedProgram) {
        this.program = null;
    }

    public void contextChanged() {
        if (this.decompilerProvider == null) {
            this.decompilerProvider = this.plugin.getDecompilerProvider();
            this.createActions((ComponentProvider)this.decompilerProvider, true);
        }
        this.tool.contextChanged((ComponentProvider)this.decompilerProvider);
    }

    public void setTaint(TaintState.TaskType taskType) {
        TaintState state = this.plugin.getTaintState();
        if (state == null) {
            return;
        }
        if (this.navigatable == null) {
            this.navigatable = ((CodeViewerService)this.tool.getService(CodeViewerService.class)).getNavigatable();
        }
        state.setTaskType(taskType);
        AddressSet taintAddressSet = state.getTaintAddressSet();
        Msg.info((Object)((Object)this), (Object)("setTaint(): " + taintAddressSet.toString()));
        Swing.runIfSwingOrRunLater(() -> this.navigatable.setSelection(new ProgramSelection((AddressSetView)taintAddressSet)));
        this.highlighter.clearHighlights();
        if (!this.taintOptions.getTaintHighlightStyle().equals((Object)TaintPlugin.Highlighter.LABELS)) {
            this.paletteIndex = 0;
        }
        this.highlighter.applyHighlights();
        state.setTaskType(TaintState.TaskType.SET_TAINT);
    }

    public void setTaint() {
        this.setTaint(TaintState.TaskType.SET_TAINT);
    }

    public boolean matchOn(ClangToken token) {
        ClangFuncNameToken fntoken;
        TaintState state = this.plugin.getTaintState();
        if (state == null) {
            return false;
        }
        if (token instanceof ClangBreak || token instanceof ClangTypeToken || token instanceof ClangSyntaxToken || token instanceof ClangCommentToken) {
            return false;
        }
        HighFunction hf = token.getClangFunction().getHighFunction();
        if (hf == null) {
            log.info("\tHighlighter> HighFunction null -- not associated with a function.");
            return false;
        }
        Address tokenFuncEntryAddr = hf.getFunction().getEntryPoint();
        Set<TaintQueryResult> funcTaintSet = state.getQuerySet(tokenFuncEntryAddr);
        if (funcTaintSet == null || funcTaintSet.isEmpty()) {
            return false;
        }
        if (token instanceof ClangVariableToken) {
            ClangVariableToken vtoken = (ClangVariableToken)token;
            if (this.matchNodeHighVariable((ClangToken)vtoken, hf, funcTaintSet)) {
                ++this.matchCount;
                return true;
            }
        } else if (token instanceof ClangFieldToken) {
            ClangFieldToken ftoken = (ClangFieldToken)token;
            if (this.matchNodeHighVariable((ClangToken)ftoken, hf, funcTaintSet)) {
                ++this.matchCount;
                return true;
            }
        } else if (token instanceof ClangFuncNameToken && this.matchNodeFuncName((fntoken = (ClangFuncNameToken)token).getText(), tokenFuncEntryAddr, funcTaintSet)) {
            ++this.matchCount;
            return true;
        }
        return false;
    }

    private boolean matchNodeHighVariable(ClangToken token, HighFunction hf, Set<TaintQueryResult> taintSet) {
        for (TaintQueryResult taintedVarnode : taintSet) {
            this.addHighlightColor(taintedVarnode);
            String match = taintedVarnode.matches(token);
            if (match == null) continue;
            log.info("\t\tHighlighter> LOC Match on {}", (Object)match);
            return true;
        }
        return false;
    }

    private boolean matchNodeFuncName(String funcName, Address faddr, Set<TaintQueryResult> taintSet) {
        for (TaintQueryResult taintedVarnode : taintSet) {
            if (!taintedVarnode.matchesFunction(funcName, faddr)) continue;
            log.info("\t\tHighlighter> FUN LOC Match on {} at addr: {}", (Object)funcName, (Object)faddr);
            return true;
        }
        return false;
    }

    public void setHighlighter(DecompilerHighlightService highlightService, CTokenHighlightMatcher matcher) {
        DecompilerHighlighter dhl;
        if (this.highlighter != null) {
            this.highlighter.dispose();
        }
        this.highlighter = dhl = highlightService.createHighlighter(matcher);
    }

    public void clearTaint() {
        Msg.info((Object)((Object)this), (Object)"TaintProvider: clearTaint() - state clearTaint() and highligher apply highlights.");
        this.matchCount = 0;
        this.plugin.getTaintState().clearTaint();
        this.highlighter.clearHighlights();
        this.cachedHighlightByAddress.clear();
        this.cachedHighlightsByToken.clear();
        this.highlighter.applyHighlights();
    }

    public void repaint() {
        this.highlighter.applyHighlights();
    }

    public void setOption(String option, String path) {
        ToolOptions opt = this.tool.getOptions(OPTIONS_TITLE);
        opt.setString(option, path);
    }

    public void setOption(String name, Boolean option) {
        ToolOptions opt = this.tool.getOptions(OPTIONS_TITLE);
        opt.setBoolean(name, option.booleanValue());
    }

    public void setColor(String option, Color color) {
        ToolOptions opt = this.tool.getOptions(OPTIONS_TITLE);
        opt.setColor(option, color);
    }

    public Color getDefaultHighlightColor() {
        return this.highlightPalette.getDefaultColor();
    }

    public Color getHighlightColor(ClangToken token) {
        Color hl = null;
        TaintOptions options = this.getOptions();
        TaintPlugin.Highlighter style = options.getTaintHighlightStyle();
        if (style.equals((Object)TaintPlugin.Highlighter.LABELS)) {
            Address addr = token.getMinAddress();
            if (addr != null) {
                TaintHighlight tl = this.cachedHighlightByAddress.get(addr);
                return tl == null ? null : tl.getColor();
            }
            return null;
        }
        hl = this.cachedHighlightsByToken.get(token.toString());
        if (hl == null) {
            hl = this.highlightPalette.getColor(this.paletteIndex);
            this.cachedHighlightsByToken.put(token.toString(), hl);
            this.paletteIndex = (this.paletteIndex + 10) % this.highlightPalette.getSize();
        }
        return hl;
    }

    public void addHighlightColor(TaintQueryResult result) {
        Address addr = result.getInsnAddr();
        String label = result.getLabel();
        TaintHighlight labelHighlight = TaintHighlight.byLabel(label);
        TaintHighlight addrHighlight = this.cachedHighlightByAddress.get(addr);
        if (addrHighlight == null) {
            addrHighlight = labelHighlight;
            this.cachedHighlightByAddress.put(addr, addrHighlight);
        } else if (!labelHighlight.equals((Object)addrHighlight) && labelHighlight.getPriority() > addrHighlight.getPriority()) {
            this.cachedHighlightByAddress.put(addr, labelHighlight);
        }
    }

    public void changeHighlighter(TaintPlugin.Highlighter hl) {
        this.plugin.changeHighlighter(hl);
    }

    public int getTokenCount() {
        return this.matchCount;
    }
}

