/*
 * Decompiled with CFR 0.152.
 */
package docking.actions;

import docking.ActionToGuiHelper;
import docking.ComponentProvider;
import docking.Tool;
import docking.action.ComponentThemeInspectorAction;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.GlobalFocusTraversalAction;
import docking.action.HelpAction;
import docking.action.HelpInfoAction;
import docking.action.KeyBindingData;
import docking.action.KeyBindingType;
import docking.action.KeyBindingsManager;
import docking.action.NextPreviousWindowAction;
import docking.action.ShowActionChooserDialogAction;
import docking.action.ShowContextMenuAction;
import docking.action.ShowFocusCycleAction;
import docking.action.ShowFocusInfoAction;
import docking.actions.AutoGeneratedDockingAction;
import docking.actions.DockingToolActions;
import docking.actions.SetKeyBindingAction;
import docking.actions.SharedActionRegistry;
import docking.actions.SharedDockingActionPlaceholder;
import docking.actions.SharedStubKeyBindingAction;
import generic.util.action.SystemKeyBindings;
import ghidra.framework.options.ActionTrigger;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import gui.event.MouseBinding;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.map.LazyMap;
import util.CollectionUtils;
import utilities.util.reflection.ReflectionUtilities;

public class ToolActions
implements DockingToolActions,
PropertyChangeListener {
    private Pattern ACTION_NAME_PATTERN = Pattern.compile("(.+) \\((.+)\\)");
    private ActionToGuiHelper actionGuiHelper;
    private Map<String, Map<String, Set<DockingActionIf>>> actionsByNameByOwner = LazyMap.lazyMap(new HashMap(), () -> LazyMap.lazyMap(new HashMap(), () -> new HashSet()));
    private Map<String, SharedStubKeyBindingAction> sharedActionMap = new HashMap<String, SharedStubKeyBindingAction>();
    private ToolOptions options;
    private Tool tool;
    private KeyBindingsManager keyBindingsManager;
    private OptionsChangeListener optionChangeListener = (toolOptions, optionName, oldValue, newValue) -> this.updateKeyBindingsFromOptions(optionName, (ActionTrigger)newValue);

    public ToolActions(Tool tool, ActionToGuiHelper actionToGuiHelper) {
        this.tool = tool;
        this.actionGuiHelper = actionToGuiHelper;
        this.keyBindingsManager = new KeyBindingsManager(tool);
        this.options = tool.getOptions("Key Bindings");
        this.options.addOptionsChangeListener(this.optionChangeListener);
        this.createSystemActions();
        SharedActionRegistry.installSharedActions(tool, this);
    }

    private void createSystemActions() {
        this.addSystemAction(new SetKeyBindingAction(this.tool, SystemKeyBindings.UPDATE_KEY_BINDINGS_KEY));
        this.addSystemAction(new HelpAction(SystemKeyBindings.HELP_KEY1, false));
        this.addSystemAction(new HelpAction(SystemKeyBindings.HELP_KEY2, true));
        this.addSystemAction(new HelpInfoAction(SystemKeyBindings.HELP_INFO_KEY));
        this.addSystemAction(new ShowContextMenuAction(SystemKeyBindings.CONTEXT_MENU_KEY1, true));
        this.addSystemAction(new ShowContextMenuAction(SystemKeyBindings.CONTEXT_MENU_KEY2, false));
        this.addSystemAction(new NextPreviousWindowAction(SystemKeyBindings.FOCUS_NEXT_WINDOW_KEY, true));
        this.addSystemAction(new NextPreviousWindowAction(SystemKeyBindings.FOCUS_PREVIOUS_WINDOW_KEY, false));
        this.addSystemAction(new GlobalFocusTraversalAction(SystemKeyBindings.FOCUS_NEXT_COMPONENT_KEY, true));
        this.addSystemAction(new GlobalFocusTraversalAction(SystemKeyBindings.FOCUS_PREVIOUS_COMPONENT_KEY, false));
        this.addSystemAction(new ShowActionChooserDialogAction());
        this.addSystemAction(new ShowFocusInfoAction());
        this.addSystemAction(new ShowFocusCycleAction());
        this.addSystemAction(new ComponentThemeInspectorAction());
    }

    private void addSystemAction(DockingAction action) {
        if (action.getKeyBindingType().isManaged()) {
            ActionTrigger actionTrigger = this.getActionTrigger(action);
            this.loadKeyBindingFromOptions(action, actionTrigger);
        }
        this.keyBindingsManager.addSystemAction(action);
        this.addActionToMap(action);
    }

    public void dispose() {
        this.actionsByNameByOwner.clear();
        this.sharedActionMap.clear();
        this.keyBindingsManager.dispose();
    }

    private void addActionToMap(DockingActionIf action) {
        Set<DockingActionIf> actions = this.getActionStorage(action);
        ToolActions.assertSameDefaultActionTrigger(action, actions);
        actions.add(action);
    }

    private static void assertSameDefaultActionTrigger(DockingActionIf newAction, Collection<DockingActionIf> existingActions) {
        if (!newAction.getKeyBindingType().supportsKeyBindings()) {
            return;
        }
        KeyBindingData newDefaultBinding = newAction.getDefaultKeyBindingData();
        ActionTrigger defaultTrigger = ToolActions.getActionTrigger(newDefaultBinding);
        for (DockingActionIf action : existingActions) {
            KeyBindingData existingDefaultBinding;
            ActionTrigger existingTrigger;
            if (!action.getKeyBindingType().supportsKeyBindings() || Objects.equals(defaultTrigger, existingTrigger = ToolActions.getActionTrigger(existingDefaultBinding = action.getDefaultKeyBindingData()))) continue;
            ToolActions.logDifferentKeyBindingsWarnigMessage(newAction, action, existingTrigger);
            break;
        }
    }

    private static void logDifferentKeyBindingsWarnigMessage(DockingActionIf newAction, DockingActionIf existingAction, ActionTrigger existingDefaultTrigger) {
        String s = "Shared Key Binding Actions have different default values.  These must be the same.\n\tAction name: '" + existingAction.getName() + "'\n\tAction 1: " + existingAction.getInceptionInformation() + "\n\t\tAction Trigger: " + String.valueOf(existingDefaultTrigger) + "\n\tAction 2: " + newAction.getInceptionInformation() + "\n\t\tAction Trigger: " + String.valueOf(newAction.getKeyBinding()) + "\nUsing the first value set - " + String.valueOf(existingDefaultTrigger);
        Msg.warn(ToolActions.class, (Object)s, (Throwable)ReflectionUtilities.createJavaFilteredThrowable());
    }

    private static ActionTrigger getActionTrigger(KeyBindingData data) {
        if (data == null) {
            return null;
        }
        return data.getActionTrigger();
    }

    @Override
    public synchronized void addLocalAction(ComponentProvider provider, DockingActionIf action) {
        this.checkForAlreadyAddedAction(provider, action);
        action.addPropertyChangeListener(this);
        this.addActionToMap(action);
        this.initializeKeyBinding(provider, action);
        this.actionGuiHelper.addLocalAction(provider, action);
    }

    @Override
    public synchronized void addGlobalAction(DockingActionIf action) {
        this.checkForAlreadyAddedAction(null, action);
        action.addPropertyChangeListener(this);
        this.addActionToMap(action);
        this.initializeKeyBinding(null, action);
        this.actionGuiHelper.addToolAction(action);
    }

    private void initializeKeyBinding(ComponentProvider provider, DockingActionIf action) {
        KeyBindingType type = action.getKeyBindingType();
        if (!type.supportsKeyBindings()) {
            return;
        }
        if (type.isShared()) {
            this.installSharedKeyBinding(provider, action);
            return;
        }
        ActionTrigger actionTrigger = this.getActionTrigger(action);
        this.loadKeyBindingFromOptions(action, actionTrigger);
        this.keyBindingsManager.addAction(provider, action);
    }

    private ActionTrigger getActionTrigger(DockingActionIf action) {
        KeyBindingData kbData = action.getKeyBindingData();
        if (kbData != null) {
            return kbData.getActionTrigger();
        }
        return null;
    }

    private void loadKeyBindingFromOptions(DockingActionIf action, ActionTrigger actionTrigger) {
        String fullName = action.getFullName();
        String description = "Keybinding for " + fullName;
        this.options.registerOption(fullName, OptionType.ACTION_TRIGGER, (Object)actionTrigger, null, description);
        KeyBindingData existingKbData = action.getKeyBindingData();
        ActionTrigger newTrigger = this.options.getActionTrigger(fullName, actionTrigger);
        KeyBindingData newKbData = KeyBindingData.update(existingKbData, newTrigger);
        action.setUnvalidatedKeyBindingData(newKbData);
    }

    private void installSharedKeyBinding(ComponentProvider provider, DockingActionIf action) {
        String name = action.getName();
        SharedStubKeyBindingAction stub = this.sharedActionMap.computeIfAbsent(name, key -> {
            ActionTrigger actionTrigger = this.getActionTrigger(action);
            SharedStubKeyBindingAction newStub = new SharedStubKeyBindingAction(name, actionTrigger, this.options);
            this.registerStub(newStub, actionTrigger);
            return newStub;
        });
        String owner = action.getOwner();
        stub.addActionOwner(owner);
        stub.addClientAction(action);
        if (!(action instanceof AutoGeneratedDockingAction)) {
            this.keyBindingsManager.addAction(provider, action);
        }
    }

    private void registerStub(SharedStubKeyBindingAction stub, ActionTrigger defaultActionTrigger) {
        stub.addPropertyChangeListener(this);
        this.loadKeyBindingFromOptions(stub, defaultActionTrigger);
        this.keyBindingsManager.addAction(null, stub);
    }

    @Override
    public synchronized void removeGlobalAction(DockingActionIf action) {
        action.removePropertyChangeListener(this);
        this.removeAction(action);
        this.actionGuiHelper.removeToolAction(action);
        this.dispose(action);
    }

    private void dispose(DockingActionIf action) {
        try {
            action.dispose();
        }
        catch (Throwable t) {
            Msg.error((Object)this, (Object)("Exception disposing action '" + action.getFullName() + "'"), (Throwable)t);
        }
    }

    @Override
    public synchronized void removeActions(String owner) {
        Map<String, Set<DockingActionIf>> toCleanup = this.actionsByNameByOwner.remove(owner);
        if (toCleanup == null) {
            return;
        }
        toCleanup.values().stream().flatMap(set -> set.stream()).filter(action -> !this.keyBindingsManager.isSystemAction((DockingActionIf)action)).forEach(action -> this.removeGlobalAction((DockingActionIf)action));
    }

    private void checkForAlreadyAddedAction(ComponentProvider provider, DockingActionIf action) {
        if (this.getActionStorage(action).contains(action)) {
            String providerString = provider == null ? "Action: " : "Provider " + provider.getName() + " - action: ";
            throw new AssertException("Cannot add the same action more than once. " + providerString + action.getFullName());
        }
    }

    @Override
    public Set<DockingActionIf> getLocalActions(ComponentProvider provider) {
        return this.actionGuiHelper.getLocalActions(provider);
    }

    @Override
    public synchronized Set<DockingActionIf> getActions(String owner) {
        HashSet<DockingActionIf> result = new HashSet<DockingActionIf>();
        Map<String, Set<DockingActionIf>> actionsByName = this.actionsByNameByOwner.get(owner);
        for (Set<DockingActionIf> actions : actionsByName.values()) {
            result.addAll(actions);
        }
        Collection<SharedStubKeyBindingAction> values = this.sharedActionMap.values();
        for (SharedStubKeyBindingAction stub : values) {
            String stubOwner = stub.getOwner();
            if (!stubOwner.equals(owner)) continue;
            result.add(stub);
        }
        return result;
    }

    @Override
    public synchronized Set<DockingActionIf> getGlobalActions() {
        return this.actionGuiHelper.getGlobalActions();
    }

    @Override
    public synchronized Set<DockingActionIf> getAllActions() {
        HashSet<DockingActionIf> result = new HashSet<DockingActionIf>();
        Collection<Map<String, Set<DockingActionIf>>> maps = this.actionsByNameByOwner.values();
        for (Map<String, Set<DockingActionIf>> actionsByName : maps) {
            for (Set<DockingActionIf> actions : actionsByName.values()) {
                result.addAll(actions);
            }
        }
        result.addAll(this.sharedActionMap.values());
        result.addAll(this.keyBindingsManager.getSystemActions());
        return result;
    }

    private Iterator<DockingActionIf> getAllActionsIterator() {
        return Stream.concat(this.actionsByNameByOwner.values().stream().flatMap(actionsByName -> actionsByName.values().stream()).flatMap(actions -> actions.stream()), this.sharedActionMap.values().stream()).iterator();
    }

    public synchronized void optionsRebuilt() {
        this.options = this.tool.getOptions("Key Bindings");
        Iterator<DockingActionIf> it = this.getKeyBindingActionsIterator();
        for (DockingActionIf action : CollectionUtils.asIterable(it)) {
            KeyBindingData currentKbData = action.getKeyBindingData();
            ActionTrigger optionsTrigger = this.options.getActionTrigger(action.getFullName(), null);
            KeyBindingData newKbData = KeyBindingData.update(currentKbData, optionsTrigger);
            action.setUnvalidatedKeyBindingData(newKbData);
        }
    }

    private Iterator<DockingActionIf> getKeyBindingActionsIterator() {
        Predicate filter = a -> a.getKeyBindingType() == KeyBindingType.INDIVIDUAL;
        return IteratorUtils.filteredIterator(this.getAllActionsIterator(), (Predicate)filter);
    }

    @Override
    public synchronized void removeLocalAction(ComponentProvider provider, DockingActionIf action) {
        action.removePropertyChangeListener(this);
        this.removeAction(action);
        this.keyBindingsManager.removeAction(action);
        this.actionGuiHelper.removeProviderAction(provider, action);
        this.dispose(action);
    }

    @Override
    public synchronized void removeActions(ComponentProvider provider) {
        Iterator<DockingActionIf> it = this.actionGuiHelper.getComponentActions(provider);
        Set set = CollectionUtils.asSet(it);
        for (DockingActionIf action : set) {
            this.removeLocalAction(provider, action);
        }
    }

    private void removeAction(DockingActionIf action) {
        this.keyBindingsManager.removeAction(action);
        this.getActionStorage(action).remove(action);
        if (!action.getKeyBindingType().isShared()) {
            return;
        }
        SharedStubKeyBindingAction stub = this.sharedActionMap.get(action.getName());
        if (stub != null) {
            stub.removeClientAction(action);
        }
    }

    private Set<DockingActionIf> getActionStorage(DockingActionIf action) {
        String owner = action.getOwner();
        String name = action.getName();
        return this.actionsByNameByOwner.get(owner).get(name);
    }

    private void updateKeyBindingsFromOptions(String optionName, ActionTrigger newTrigger) {
        Matcher matcher = this.ACTION_NAME_PATTERN.matcher(optionName);
        matcher.find();
        String name = matcher.group(1);
        String owner = matcher.group(2);
        Set<DockingActionIf> actions = this.actionsByNameByOwner.get(owner).get(name);
        if (actions.isEmpty()) {
            DockingActionIf systemAction = this.keyBindingsManager.getSystemAction(optionName);
            if (systemAction != null) {
                KeyBindingData oldKbData = systemAction.getKeyBindingData();
                KeyBindingData newKbData = KeyBindingData.update(oldKbData, newTrigger);
                systemAction.setUnvalidatedKeyBindingData(newKbData);
            }
            return;
        }
        for (DockingActionIf action : actions) {
            KeyBindingData oldKbData = action.getKeyBindingData();
            KeyBindingData newKbData = KeyBindingData.update(oldKbData, newTrigger);
            action.setUnvalidatedKeyBindingData(newKbData);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ActionTrigger currentTrigger;
        if (!evt.getPropertyName().equals("KeyBindings")) {
            return;
        }
        DockingActionIf action = (DockingActionIf)evt.getSource();
        if (!action.getKeyBindingType().isManaged()) {
            this.keyBindingsChanged();
            return;
        }
        KeyBindingData newKeyBindingData = (KeyBindingData)evt.getNewValue();
        ActionTrigger newTrigger = null;
        if (newKeyBindingData != null) {
            newTrigger = newKeyBindingData.getActionTrigger();
        }
        if (!Objects.equals(currentTrigger = this.options.getActionTrigger(action.getFullName(), null), newTrigger)) {
            this.options.setActionTrigger(action.getFullName(), newTrigger);
            this.keyBindingsChanged();
        }
    }

    private void keyBindingsChanged() {
        this.tool.setConfigChanged(true);
        this.actionGuiHelper.keyBindingsChanged();
    }

    @Override
    public DockingActionIf getLocalAction(ComponentProvider provider, String actionName) {
        Iterator<DockingActionIf> it = this.actionGuiHelper.getComponentActions(provider);
        while (it.hasNext()) {
            DockingActionIf action = it.next();
            if (!action.getName().equals(actionName)) continue;
            return action;
        }
        return null;
    }

    public String validateActionKeyBinding(DockingActionIf action, KeyStroke ks) {
        return this.keyBindingsManager.validateActionKeyBinding(action, ks);
    }

    public Action getAction(KeyStroke ks) {
        return this.keyBindingsManager.getDockingAction(ks);
    }

    public Action getAction(MouseBinding mb) {
        return this.keyBindingsManager.getDockingAction(mb);
    }

    DockingActionIf getSharedStubKeyBindingAction(String name) {
        return this.sharedActionMap.get(name);
    }

    @Override
    public void registerSharedActionPlaceholder(SharedDockingActionPlaceholder placeholder) {
        String name = placeholder.getName();
        SharedStubKeyBindingAction stub = this.sharedActionMap.computeIfAbsent(name, key -> {
            ActionTrigger actionTrigger = this.getActionTrigger(placeholder);
            SharedStubKeyBindingAction newStub = new SharedStubKeyBindingAction(name, actionTrigger, this.options);
            this.registerStub(newStub, actionTrigger);
            return newStub;
        });
        String owner = placeholder.getOwner();
        stub.addActionOwner(owner);
    }

    private ActionTrigger getActionTrigger(SharedDockingActionPlaceholder placeholder) {
        KeyStroke defaultKs = placeholder.getKeyBinding();
        if (defaultKs != null) {
            return new ActionTrigger(defaultKs);
        }
        return null;
    }
}

