/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pty.windows;

import com.sun.jna.LastErrorException;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.lang.ref.Cleaner;

public class Handle
implements AutoCloseable {
    private static final Cleaner CLEANER = Cleaner.create();
    private final State state;
    private final Cleaner.Cleanable cleanable;

    public Handle(WinNT.HANDLE handle) {
        this.state = this.newState(handle);
        this.cleanable = CLEANER.register(this, this.state);
    }

    protected State newState(WinNT.HANDLE handle) {
        return new State(handle);
    }

    @Override
    public void close() {
        this.cleanable.clean();
    }

    public WinNT.HANDLE getNative() {
        WinNT.HANDLE handle = this.state.handle;
        if (handle == null) {
            throw new IllegalStateException("This handle is no longer valid");
        }
        return handle;
    }

    protected static class State
    implements Runnable {
        protected final WinNT.HANDLE handle;

        protected State(WinNT.HANDLE handle) {
            this.handle = handle;
        }

        @Override
        public void run() {
            if (!Kernel32.INSTANCE.CloseHandle(this.handle)) {
                throw new LastErrorException(Kernel32.INSTANCE.GetLastError());
            }
        }
    }
}

