/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.attributes;

import ghidra.app.util.bin.BinaryReader;
import ghidra.javaclass.format.attributes.AbstractAttributeInfo;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class LocalVariableTypeTableAttribute
extends AbstractAttributeInfo {
    private byte[] infoBytes;

    public LocalVariableTypeTableAttribute(BinaryReader reader) throws IOException {
        super(reader);
        this.infoBytes = reader.readNextByteArray(this.getAttributeLength());
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = this.getBaseStructure("LocalVariableTypeTable_attribute");
        if (this.infoBytes.length > 0) {
            ArrayDataType array = new ArrayDataType(BYTE, this.infoBytes.length, BYTE.getLength());
            structure.add((DataType)array, "info", null);
        }
        return structure;
    }
}

