/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.db;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import ghidra.feature.vt.api.db.AssociationDatabaseManager;
import ghidra.feature.vt.api.db.DeletedMatch;
import ghidra.feature.vt.api.db.VTAssociationDB;
import ghidra.feature.vt.api.db.VTMatchDB;
import ghidra.feature.vt.api.db.VTMatchSetTableDBAdapter;
import ghidra.feature.vt.api.db.VTMatchTableDBAdapter;
import ghidra.feature.vt.api.db.VTMatchTagDB;
import ghidra.feature.vt.api.db.VTSessionDB;
import ghidra.feature.vt.api.impl.ProgramCorrelatorInfoImpl;
import ghidra.feature.vt.api.impl.VTEvent;
import ghidra.feature.vt.api.impl.VTProgramCorrelatorInfo;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationStatus;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchInfo;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTMatchTag;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.framework.data.OpenMode;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.DatabaseObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.listing.Program;
import ghidra.util.Lock;
import ghidra.util.Msg;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlUtilities;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class VTMatchSetDB
extends DatabaseObject
implements VTMatchSet {
    private final DBRecord matchSetRecord;
    private DBObjectCache<VTMatchDB> matchCache;
    private final VTSessionDB session;
    private VTMatchTableDBAdapter matchTableAdapter;
    private final Lock lock;
    private final DBHandle dbHandle;
    private ProgramCorrelatorInfoImpl correlatorInfo;
    private Options options;

    public static VTMatchSetDB createMatchSetDB(DBRecord record, VTSessionDB session, DBHandle dbHandle, Lock lock) throws IOException {
        VTMatchSetDB matchSetDB = new VTMatchSetDB(record, session, dbHandle, lock);
        matchSetDB.createTableAdapters(record.getKey());
        return matchSetDB;
    }

    public static VTMatchSetDB getMatchSetDB(DBRecord record, VTSessionDB session, DBHandle dbHandle, OpenMode openMode, TaskMonitor monitor, Lock lock) throws VersionException {
        VTMatchSetDB matchSetDB = new VTMatchSetDB(record, session, dbHandle, lock);
        matchSetDB.getTableAdapters(record.getKey(), openMode, monitor);
        return matchSetDB;
    }

    private VTMatchSetDB(DBRecord record, VTSessionDB session, DBHandle dbHandle, Lock lock) {
        super(null, record.getKey());
        this.matchSetRecord = record;
        this.session = session;
        this.dbHandle = dbHandle;
        this.lock = lock;
        this.matchCache = new DBObjectCache(10);
    }

    private void createTableAdapters(long tableID) throws IOException {
        this.matchTableAdapter = VTMatchTableDBAdapter.createAdapter(this.dbHandle, tableID);
    }

    private void getTableAdapters(long tableID, OpenMode openMode, TaskMonitor monitor) throws VersionException {
        this.matchTableAdapter = VTMatchTableDBAdapter.getAdapter(this.dbHandle, tableID, openMode, monitor);
    }

    void dbError(IOException exception) {
        this.session.dbError(exception);
    }

    @Override
    public VTSession getSession() {
        return this.session;
    }

    @Override
    public int getMatchCount() {
        return this.matchTableAdapter.getRecordCount();
    }

    @Override
    public VTProgramCorrelatorInfo getProgramCorrelatorInfo() {
        if (this.correlatorInfo == null) {
            this.correlatorInfo = new ProgramCorrelatorInfoImpl(this);
        }
        return this.correlatorInfo;
    }

    public AddressSet getSourceAddressSet() throws IOException {
        return this.session.getSourceAddressSet(this.matchSetRecord);
    }

    public AddressSet getDestinationAddressSet() throws IOException {
        return this.session.getDestinationAddressSet(this.matchSetRecord);
    }

    public String getProgramCorrelatorName() {
        return this.matchSetRecord.getString(VTMatchSetTableDBAdapter.ColumnDescription.CORRELATOR_NAME_COL.column());
    }

    public String getProgramCorrelatorClassName() {
        return this.matchSetRecord.getString(VTMatchSetTableDBAdapter.ColumnDescription.CORRELATOR_CLASS_COL.column());
    }

    public Options getOptions() {
        if (this.options != null) {
            return this.options;
        }
        String optionsString = this.matchSetRecord.getString(VTMatchSetTableDBAdapter.ColumnDescription.OPTIONS_COL.column());
        if (optionsString == null) {
            return new ToolOptions("EMPTY_OPTIONS_NAME");
        }
        StringReader reader = new StringReader(optionsString);
        SAXBuilder builder = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
        try {
            Element rootElement = builder.build((Reader)reader).getRootElement();
            this.options = new ToolOptions(rootElement);
        }
        catch (JDOMException e) {
            Msg.showError((Object)this, null, (String)"Error Loading Key Bindings", (Object)"Unable to build XML data.", (Throwable)e);
        }
        catch (IOException e) {
            Msg.showError((Object)this, null, (String)"Error Loading Key Bindings", (Object)"Unable to build XML data.", (Throwable)e);
        }
        return this.options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VTMatch addMatch(VTMatchInfo info) {
        AssociationDatabaseManager associationManager = this.session.getAssociationManagerDBM();
        VTAssociationDB associationDB = associationManager.getOrCreateAssociationDB(info.getSourceAddress(), info.getDestinationAddress(), info.getAssociationType());
        VTMatchTag tag = info.getTag();
        VTMatch newMatch = null;
        try {
            this.lock.acquire();
            VTMatchTagDB tagDB = this.session.getOrCreateMatchTagDB(tag);
            DBRecord matchRecord = this.matchTableAdapter.insertMatchRecord(info, this, associationDB, tagDB);
            newMatch = this.getMatchForRecord(matchRecord);
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        if (newMatch != null) {
            this.session.setObjectChanged(VTEvent.MATCH_ADDED, newMatch, null, newMatch);
        }
        return newMatch;
    }

    @Override
    public boolean removeMatch(VTMatch match) {
        if (!(match instanceof VTMatchDB)) {
            throw new IllegalArgumentException("Can only remove matches saved to the database");
        }
        VTMatchDB matchDb = (VTMatchDB)match;
        VTAssociation association = match.getAssociation();
        List<VTMatch> matches = this.session.getMatches(association);
        if (matches.size() == 1 && association.getStatus() == VTAssociationStatus.ACCEPTED) {
            return false;
        }
        this.deleteMatch(matchDb);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteMatch(VTMatch match) {
        if (!(match instanceof VTMatchDB)) {
            throw new IllegalArgumentException("Can only remove matches saved to the database");
        }
        VTMatchDB matchDb = (VTMatchDB)match;
        VTAssociation association = match.getAssociation();
        Address sourceAddress = association.getSourceAddress();
        Address destinationAddress = association.getDestinationAddress();
        try {
            this.lock.acquire();
            long matchKey = matchDb.getKey();
            boolean deleted = this.matchTableAdapter.deleteRecord(matchKey);
            if (deleted) {
                this.matchCache.delete(matchKey);
                List<VTMatch> matches = this.session.getMatches(association);
                if (matches.isEmpty()) {
                    AssociationDatabaseManager manager = this.session.getAssociationManagerDBM();
                    manager.removeAssociation(association);
                }
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        DeletedMatch deletedMatch = new DeletedMatch(sourceAddress, destinationAddress);
        this.session.setObjectChanged(VTEvent.MATCH_DELETED, match, deletedMatch, null);
    }

    @Override
    public int getID() {
        return (int)this.matchSetRecord.getKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<VTMatch> getMatches() {
        LinkedList<VTMatch> list = new LinkedList<VTMatch>();
        try {
            this.lock.acquire();
            RecordIterator iterator = this.matchTableAdapter.getRecords();
            while (iterator.hasNext()) {
                DBRecord nextRecord = iterator.next();
                list.add(this.getMatchForRecord(nextRecord));
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return list;
    }

    @Override
    public Collection<VTMatch> getMatches(VTAssociation association) {
        VTAssociationDB associationDB = (VTAssociationDB)association;
        LinkedList<VTMatch> list = new LinkedList<VTMatch>();
        if (associationDB == null) {
            return list;
        }
        try {
            RecordIterator iterator = this.matchTableAdapter.getRecords(associationDB.getKey());
            while (iterator.hasNext()) {
                DBRecord nextRecord = iterator.next();
                VTMatch match = this.getMatchForRecord(nextRecord);
                list.add(match);
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        return list;
    }

    @Override
    public Collection<VTMatch> getMatches(Address sourceAddress, Address destinationAddress) {
        AssociationDatabaseManager associationManager = this.session.getAssociationManagerDBM();
        VTAssociationDB existingAssociationDB = associationManager.getExistingAssociationDB(sourceAddress, destinationAddress);
        if (existingAssociationDB == null) {
            return Collections.emptyList();
        }
        return this.getMatches(existingAssociationDB);
    }

    protected boolean refresh() {
        return true;
    }

    public boolean isInvalid() {
        return this.session.getMatchSetRecord(this.key) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VTMatch getMatchForRecord(DBRecord matchRecord) {
        try {
            this.lock.acquire();
            VTMatchDB match = (VTMatchDB)this.matchCache.get(matchRecord);
            if (match == null) {
                match = new VTMatchDB(this.matchCache, matchRecord, this);
            }
            VTMatchDB vTMatchDB = match;
            return vTMatchDB;
        }
        finally {
            this.lock.release();
        }
    }

    DBRecord getMatchRecord(long matchRecordKey) {
        try {
            return this.matchTableAdapter.getMatchRecord(matchRecordKey);
        }
        catch (IOException e) {
            this.dbError(e);
            return null;
        }
    }

    Program getDestinationProgram() {
        return this.session.getDestinationProgram();
    }

    Program getSourceProgram() {
        return this.session.getSourceProgram();
    }

    AssociationDatabaseManager getAssociationManager() {
        return this.session.getAssociationManagerDBM();
    }

    VTMatchTableDBAdapter getMatchTableAdapter() {
        return this.matchTableAdapter;
    }

    public void invalidateCache() {
        this.lock.acquire();
        try {
            this.matchCache.invalidate();
        }
        finally {
            this.lock.release();
        }
    }

    public String toString() {
        return "Match Set " + this.getID() + " - " + this.getMatchCount() + " matches [Correlator=" + this.getProgramCorrelatorInfo().getName() + "]";
    }
}

