/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class StretchLayout
implements LayoutManager,
Serializable {
    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Component[] comps = container.getComponents();
        int maxWidth = 0;
        int maxHeight = 0;
        for (int i = 0; i < comps.length; ++i) {
            Dimension size = new Dimension(comps[i].getPreferredSize());
            maxWidth = Math.max(maxWidth, size.width);
            maxHeight = Math.max(maxHeight, size.height);
        }
        Insets insets = container.getInsets();
        return new Dimension(maxWidth + insets.left + insets.right, maxHeight + insets.top + insets.bottom);
    }

    @Override
    public Dimension minimumLayoutSize(Container cont) {
        return this.preferredLayoutSize(cont);
    }

    @Override
    public void layoutContainer(Container container) {
        Dimension containerSize = container.getSize();
        Insets insets = container.getInsets();
        int width = containerSize.width - insets.left - insets.right;
        int height = containerSize.height - insets.top - insets.bottom;
        if (width < 0) {
            width = 0;
        }
        if (height < 0) {
            height = 0;
        }
        try {
            Component[] comps = container.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                comps[i].setBounds(insets.left, insets.top, width, height);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

