/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import ghidra.framework.options.SaveState;
import gui.event.MouseBinding;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.StringUtils;
import util.CollectionUtils;

public class ActionTrigger {
    private static final Pattern TO_STRING_PATTERN = Pattern.compile(".*Key Stroke\\[(.*)\\].*Mouse Binding\\[(.*)\\]");
    private static final String KEY_STROKE = "KeyStroke";
    private static final String MOUSE_BINDING = "MouseBinding";
    private KeyStroke keyStroke;
    private MouseBinding mouseBinding;

    public ActionTrigger(KeyStroke keyStroke) {
        this(keyStroke, null);
    }

    public ActionTrigger(MouseBinding mouseBinding) {
        this(null, mouseBinding);
    }

    public ActionTrigger(KeyStroke keyStroke, MouseBinding mouseBinding) {
        if (CollectionUtils.isAllNull((Object[])new Object[]{keyStroke, mouseBinding})) {
            throw new NullPointerException("Both the key stroke and mouse bindng cannot be null");
        }
        this.keyStroke = keyStroke;
        this.mouseBinding = mouseBinding;
    }

    public KeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    public MouseBinding getMouseBinding() {
        return this.mouseBinding;
    }

    public String toString() {
        StringBuilder buffy = new StringBuilder("ActionTrigger: ");
        buffy.append("Key Stroke[");
        if (this.keyStroke != null) {
            buffy.append(this.keyStroke.toString());
        }
        buffy.append("], Mouse Binding[");
        if (this.mouseBinding != null) {
            buffy.append(this.mouseBinding.toString());
        }
        buffy.append(']');
        return buffy.toString();
    }

    public static ActionTrigger getActionTrigger(String string) {
        Matcher matcher = TO_STRING_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String ksString = matcher.group(1);
        String mbString = matcher.group(2);
        KeyStroke ks = null;
        if (!StringUtils.isBlank((CharSequence)ksString)) {
            ks = KeyStroke.getKeyStroke(ksString);
        }
        MouseBinding mb = null;
        if (!StringUtils.isBlank((CharSequence)mbString)) {
            mb = MouseBinding.getMouseBinding(mbString);
        }
        return ActionTrigger.create(ks, mb);
    }

    public void writeState(SaveState saveState) {
        String ksString = "";
        if (this.keyStroke != null) {
            ksString = this.keyStroke.toString();
        }
        saveState.putString(KEY_STROKE, ksString);
        String mbString = "";
        if (this.mouseBinding != null) {
            mbString = this.mouseBinding.toString();
        }
        saveState.putString(MOUSE_BINDING, mbString);
    }

    public static ActionTrigger create(SaveState saveState) {
        KeyStroke ks = null;
        String value = saveState.getString(KEY_STROKE, null);
        if (!StringUtils.isBlank((CharSequence)value)) {
            ks = KeyStroke.getKeyStroke(value);
        }
        MouseBinding mb = null;
        value = saveState.getString(MOUSE_BINDING, null);
        if (value != null) {
            mb = MouseBinding.getMouseBinding(value);
        }
        return ActionTrigger.create(ks, mb);
    }

    private static ActionTrigger create(KeyStroke ks, MouseBinding mb) {
        if (ks == null && mb == null) {
            return null;
        }
        return new ActionTrigger(ks, mb);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.keyStroke == null ? 0 : this.keyStroke.hashCode());
        result = 31 * result + (this.mouseBinding == null ? 0 : this.mouseBinding.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActionTrigger other = (ActionTrigger)obj;
        if (!Objects.equals(this.keyStroke, other.keyStroke)) {
            return false;
        }
        return Objects.equals(this.mouseBinding, other.mouseBinding);
    }
}

