/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objectiveC;

import ghidra.app.cmd.data.CreateDataCmd;
import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.cmd.register.SetRegisterCmd;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_InstanceVariable;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_State;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_State;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC_Method;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC_MethodType;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.database.symbol.ClassSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public final class ObjectiveC1_Utilities {
    public static void clear(ObjectiveC2_State state, MemoryBlock block) throws Exception {
        state.program.getListing().clearCodeUnits(block.getStart(), block.getEnd(), false, state.monitor);
    }

    public static long readNextIndex(BinaryReader reader, boolean is32bit) throws IOException {
        if (is32bit) {
            return (long)reader.readNextInt() & 0xFFFFFFFFL;
        }
        return reader.readNextLong();
    }

    public static String dereferenceAsciiString(BinaryReader reader, boolean is32bit) throws IOException {
        if (is32bit) {
            int stringIndex = reader.readNextInt();
            if (stringIndex != 0) {
                return reader.readAsciiString(stringIndex);
            }
            return null;
        }
        long stringIndex = reader.readNextLong();
        if (stringIndex != 0L) {
            return reader.readAsciiString(stringIndex);
        }
        return null;
    }

    public static boolean isNull(Address address) {
        return address.getOffset() == 0L;
    }

    public static boolean isThumb(Program program, Address address) {
        Memory memory;
        MemoryBlock block;
        Processor ARM = Processor.findOrPossiblyCreateProcessor((String)"ARM");
        if (program.getLanguage().getProcessor().equals((Object)ARM) && (block = (memory = program.getMemory()).getBlock(address)) != null && block.isExecute()) {
            return address.getOffset() % 2L != 0L;
        }
        return false;
    }

    public static boolean isThumb(Program program, long address) {
        return ObjectiveC1_Utilities.isThumb(program, program.getAddressFactory().getDefaultAddressSpace().getAddress(address));
    }

    public static void setThumbBit(ObjectiveC1_State state, Address address) {
        Register tmodeRegister;
        if (state.thumbCodeLocations.contains(address) && (tmodeRegister = state.program.getLanguage().getRegister("TMode")) != null) {
            SetRegisterCmd c = new SetRegisterCmd(tmodeRegister, address, address, BigInteger.valueOf(1L));
            c.applyTo((DomainObject)state.program);
        }
    }

    public static Address toAddress(Program program, long offset) {
        return program.getAddressFactory().getDefaultAddressSpace().getAddress(offset);
    }

    public static void applyData(Program program, DataType dt, Address address) throws CodeUnitInsertionException {
        Data data = program.getListing().getDefinedDataAt(address);
        if (data != null && data.getDataType().isEquivalent(dt)) {
            return;
        }
        DataUtilities.createData((Program)program, (Address)address, (DataType)dt, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_DEFAULT_CONFLICT_DATA);
    }

    public static String createString(Program program, Address address) {
        Data data = program.getListing().getDataAt(address);
        if (data == null) {
            CreateDataCmd cmd = new CreateDataCmd(address, (DataType)new StringDataType());
            cmd.applyTo(program);
            data = program.getListing().getDefinedDataAt(address);
        }
        if (data == null) {
            return null;
        }
        Object object = data.getValue();
        if (object instanceof String) {
            return (String)object;
        }
        Msg.error(null, (Object)("Unable to locate string at " + String.valueOf(address)));
        return null;
    }

    public static Address createPointerAndReturnAddressBeingReferenced(Program program, Address address) throws CodeUnitInsertionException {
        program.getListing().createData(address, (DataType)new PointerDataType());
        Data data = program.getListing().getDefinedDataAt(address);
        return (Address)data.getValue();
    }

    private static Namespace getNamespace(Program program, Namespace parentNamespace, String namespaceName) throws DuplicateNameException, InvalidInputException {
        SymbolTable symbolTable = program.getSymbolTable();
        Namespace namespace = symbolTable.getNamespace(namespaceName, parentNamespace);
        if (namespace != null) {
            return namespace;
        }
        return symbolTable.createNameSpace(parentNamespace, namespaceName, SourceType.IMPORTED);
    }

    public static Namespace getClassNamespace(Program program, Namespace parentNamespace, String namespaceName) throws DuplicateNameException, InvalidInputException {
        SymbolTable symbolTable = program.getSymbolTable();
        Symbol symbol = symbolTable.getClassSymbol(namespaceName, parentNamespace);
        if (symbol instanceof ClassSymbol && symbol.getName().equals(namespaceName)) {
            return (GhidraClass)symbol.getObject();
        }
        return symbolTable.createClass(parentNamespace, namespaceName, SourceType.IMPORTED);
    }

    public static Symbol createSymbol(Program program, Namespace parentNamespace, String symbolName, Address symbolAddress) throws InvalidInputException {
        Symbol symbol = program.getSymbolTable().createLabel(symbolAddress, symbolName, parentNamespace, SourceType.IMPORTED);
        symbol.setPrimary();
        return symbol;
    }

    public static Namespace createNamespace(Program program, String ... namespacePath) throws DuplicateNameException, InvalidInputException {
        Namespace parentNamespace = program.getGlobalNamespace();
        Namespace namespace = null;
        for (String namespaceName : namespacePath) {
            parentNamespace = namespace = ObjectiveC1_Utilities.getNamespace(program, parentNamespace, namespaceName);
        }
        return namespace;
    }

    public static final String formatAsObjectiveC(Function function, ObjectiveC_MethodType methodType) {
        return ObjectiveC1_Utilities.formatAsObjectiveC(function.getSignature(), methodType, false);
    }

    public static final String formatAsObjectiveC(FunctionSignature signature, ObjectiveC_MethodType methodType, boolean appendSemicolon) throws IllegalStateException {
        int colonCount = StringUtilities.countOccurrences((String)signature.getName(), (char)':');
        StringTokenizer tokenizer = new StringTokenizer(signature.getName(), ":");
        StringBuffer buffer = new StringBuffer();
        buffer.append(methodType.getIndicator());
        buffer.append(' ');
        buffer.append("(" + signature.getReturnType().getDisplayName() + ")");
        buffer.append(' ');
        ParameterDefinition[] arguments = signature.getArguments();
        int argumentIndex = 2;
        if (arguments.length - 2 != colonCount - 1 && arguments.length - 2 != colonCount) {
            throw new IllegalStateException("Invalid amount of arguments.");
        }
        ArrayList<String> tokenList = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            tokenList.add(tokenizer.nextToken());
        }
        while (tokenList.size() < colonCount) {
            tokenList.add("");
        }
        for (String token : tokenList) {
            buffer.append(token);
            if (argumentIndex >= arguments.length) continue;
            buffer.append(':');
            buffer.append("(" + arguments[argumentIndex].getDataType().getDisplayName() + ")");
            buffer.append("arg" + argumentIndex);
            if (++argumentIndex >= arguments.length) continue;
            buffer.append(' ');
        }
        if (appendSemicolon) {
            buffer.append(';');
        }
        return buffer.toString();
    }

    public static final void createMethods(ObjectiveC1_State state) {
        state.monitor.setMessage("Creating Objective-C Methods...");
        state.monitor.initialize((long)state.methodMap.size());
        int progress = 0;
        Set<Address> addresses = state.methodMap.keySet();
        for (Address address : addresses) {
            if (state.monitor.isCancelled()) break;
            state.monitor.setProgress((long)(++progress));
            ObjectiveC1_Utilities.setThumbBit(state, address);
            BackgroundCommand command = null;
            command = new DisassembleCommand(address, null, true);
            command.applyTo((DomainObject)state.program, state.monitor);
            command = new CreateFunctionCmd(address);
            command.applyTo((DomainObject)state.program, state.monitor);
            ObjectiveC_Method method = state.methodMap.get(address);
            try {
                state.encodings.processMethodSignature(state.program, address, method.getTypes(), method.getMethodType());
            }
            catch (Exception e) {
                Msg.error(ObjectiveC1_Utilities.class, (Object)("Unhandled method signature: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static final void createInstanceVariablesC2_OBJC2(ObjectiveC2_State state) {
        state.monitor.setMessage("Creating Objective-C 2.0 Instance Variables...");
        state.monitor.initialize((long)state.variableMap.size());
        int progress = 0;
        Set<Address> addresses = state.variableMap.keySet();
        for (Address address : addresses) {
            if (state.monitor.isCancelled()) break;
            state.monitor.setProgress((long)(++progress));
            ObjectiveC2_InstanceVariable variable = state.variableMap.get(address);
            try {
                state.encodings.processInstanceVariableSignature(state.program, address, variable.getType(), variable.getSize());
            }
            catch (Exception exception) {}
        }
    }

    public static final void fixupReferences(ObjectiveC1_State state) {
        state.monitor.setMessage("Fixing References...");
        AddressSet addressSet = new AddressSet();
        List<String> sectionNames = state.getObjectiveCSectionNames();
        for (String sectionName : sectionNames) {
            if (state.monitor.isCancelled()) break;
            MemoryBlock block = state.program.getMemory().getBlock(sectionName);
            if (block == null) continue;
            addressSet.addRange(block.getStart(), block.getEnd());
        }
        state.monitor.initialize(addressSet.getNumAddresses());
        int progress = 0;
        ReferenceManager referenceManager = state.program.getReferenceManager();
        AddressIterator referenceIterator = referenceManager.getReferenceSourceIterator((AddressSetView)addressSet, true);
        block1: while (referenceIterator.hasNext() && !state.monitor.isCancelled()) {
            Reference[] references;
            if (++progress % 100 == 0) {
                state.monitor.setProgress((long)progress);
            }
            Address sourceAddress = referenceIterator.next();
            for (Reference reference : references = referenceManager.getReferencesFrom(sourceAddress)) {
                if (state.monitor.isCancelled()) continue block1;
                if (ObjectiveC1_Utilities.isNull(reference.getToAddress())) {
                    referenceManager.delete(reference);
                }
                if (!ObjectiveC1_Utilities.isThumb(state.program, reference.getToAddress())) continue;
                referenceManager.delete(reference);
                referenceManager.addMemoryReference(reference.getFromAddress(), reference.getToAddress().subtract(1L), reference.getReferenceType(), reference.getSource(), reference.getOperandIndex());
            }
        }
    }
}

