/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.label.GLabel;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.BuiltInArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeTreeNode;
import ghidra.app.util.datatype.DataTypeSelectionDialog;
import ghidra.app.util.datatype.DataTypeSelectionEditor;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDependencyException;
import ghidra.program.model.data.DataTypeManager;
import ghidra.util.Msg;
import ghidra.util.data.DataTypeParser;
import ghidra.util.layout.VerticalLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;

public class ReplaceDataTypeAction
extends DockingAction {
    private DataTypeManagerPlugin plugin;

    public ReplaceDataTypeAction(DataTypeManagerPlugin plugin) {
        super("Replace", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Replace..."}, "Edit"));
    }

    public boolean isAddToPopup(ActionContext context) {
        DataTypeTreeNode node = this.getSelectedDataTypeTreeNode(context);
        if (node instanceof BuiltInArchiveNode) {
            return false;
        }
        return node != null;
    }

    public boolean isEnabledForContext(ActionContext context) {
        DataTypeTreeNode node = this.getSelectedDataTypeTreeNode(context);
        if (node == null) {
            return false;
        }
        if (!(node instanceof DataTypeNode)) {
            return false;
        }
        return node.isModifiable();
    }

    private DataTypeTreeNode getSelectedDataTypeTreeNode(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return null;
        }
        GTree gTree = (GTree)context.getContextObject();
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length == 0) {
            return null;
        }
        if (selectionPaths.length > 1) {
            return null;
        }
        DataTypeTreeNode node = (DataTypeTreeNode)((Object)selectionPaths[0].getLastPathComponent());
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionContext context) {
        DataTypeTreeNode node = this.getSelectedDataTypeTreeNode(context);
        final String name = node.getName();
        PluginTool tool = this.plugin.getTool();
        int noSizeRestriction = -1;
        DataTypeSelectionDialog selectionDialog = new DataTypeSelectionDialog(this, tool, (DataTypeManager)this.plugin.getProgram().getDataTypeManager(), noSizeRestriction, DataTypeParser.AllowedDataTypes.ALL){

            @Override
            protected JComponent createEditorPanel(DataTypeSelectionEditor dtEditor) {
                this.setTitle("Replace '" + name + "'");
                JPanel updatedPanel = new JPanel();
                updatedPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 0));
                updatedPanel.setLayout((LayoutManager)new VerticalLayout(5));
                GLabel label = new GLabel("Choose the replacement data type: ");
                label.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
                updatedPanel.add((Component)label);
                updatedPanel.add(dtEditor.getEditorComponent());
                return updatedPanel;
            }
        };
        selectionDialog.setHelpLocation(this.getHelpLocation());
        tool.showDialog((DialogComponentProvider)selectionDialog);
        DataType newDt = selectionDialog.getUserChosenDataType();
        if (newDt == null) {
            return;
        }
        DataTypeManagerHandler dtmHandler = this.plugin.getDataTypeManagerHandler();
        DataTypeManager newDtm = newDt.getDataTypeManager();
        Archive sourceArchive = dtmHandler.getArchive(newDtm);
        Archive destinationArchive = this.findArchive((GTreeNode)node);
        DataType oldDt = ((DataTypeNode)node).getDataType();
        DataTypeManager dtm = oldDt.getDataTypeManager();
        if (sourceArchive != destinationArchive) {
            oldDt = oldDt.clone(oldDt.getDataTypeManager());
        }
        int txId = dtm.startTransaction("Replace Data Type");
        try {
            dtm.replaceDataType(oldDt, newDt, true);
        }
        catch (DataTypeDependencyException e) {
            Msg.showError((Object)((Object)this), null, (String)"Replace Failed", (Object)("Replace failed.  Existing type " + String.valueOf(newDt) + "; replacement type " + String.valueOf(oldDt) + ". " + e.getMessage()));
        }
        finally {
            dtm.endTransaction(txId, true);
        }
    }

    private Archive findArchive(GTreeNode node) {
        while (node != null) {
            if (node instanceof ArchiveNode) {
                return ((ArchiveNode)node).getArchive();
            }
            node = node.getParent();
        }
        return null;
    }
}

