/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;

public abstract class AbstractModifierMsType
extends AbstractMsType {
    protected RecordNumber modifiedRecordNumber;
    protected int attributes;
    protected boolean isConst;
    protected boolean isVolatile;
    protected boolean isUnaligned;

    public AbstractModifierMsType(AbstractPdb pdb, PdbByteReader reader) {
        super(pdb, reader);
    }

    public AbstractModifierMsType(AbstractPdb pdb, RecordNumber modifiedRecordNumber, boolean isConst, boolean isVolatile, boolean isUnaligned) {
        super(pdb, null);
        this.modifiedRecordNumber = modifiedRecordNumber;
        this.isConst = isConst;
        this.isVolatile = isVolatile;
        this.isUnaligned = isUnaligned;
    }

    public RecordNumber getModifiedRecordNumber() {
        return this.modifiedRecordNumber;
    }

    public AbstractMsType getModifiedType() {
        return this.pdb.getTypeRecord(this.modifiedRecordNumber);
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        StringBuilder modBuilder = new StringBuilder();
        modBuilder.append(this.isConst ? "const " : "");
        modBuilder.append(this.isVolatile ? "volatile " : "");
        modBuilder.append(this.isUnaligned ? "__unaligned " : "");
        modBuilder.append(this.getModifiedType());
        modBuilder.append(" ");
        builder.insert(0, modBuilder);
    }

    protected void processAttributes(int atts) {
        this.isConst = (atts & 1) == 1;
        this.isVolatile = ((atts >>= 1) & 1) == 1;
        this.isUnaligned = ((atts >>= 1) & 1) == 1;
    }
}

