/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.CodeUnitLocation;

public class AddressFieldLocation
extends CodeUnitLocation {
    private String addrRepresentation;

    public AddressFieldLocation(Program program, Address addr, int[] componentPath, String addrRepresentation, int charOffset) {
        super(program, addr, componentPath, 0, 0, charOffset);
        this.addrRepresentation = addrRepresentation;
    }

    public AddressFieldLocation(Program program, Address addr) {
        super(program, addr, 0, 0, 0);
        this.addrRepresentation = addr.toString();
    }

    public AddressFieldLocation() {
    }

    public String getAddressRepresentation() {
        return this.addrRepresentation;
    }

    @Override
    public String toString() {
        return super.toString() + ", AddressRep = " + this.addrRepresentation;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.addrRepresentation == null ? 0 : this.addrRepresentation.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddressFieldLocation other = (AddressFieldLocation)obj;
        return !(this.addrRepresentation == null ? other.addrRepresentation != null : !this.addrRepresentation.equals(other.addrRepresentation));
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putString("_ADDR_REP", this.addrRepresentation);
    }

    @Override
    public void restoreState(Program restoreProgram, SaveState obj) {
        super.restoreState(restoreProgram, obj);
        this.addrRepresentation = obj.getString("_ADDR_REP", null);
    }
}

