/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh;

import ghidra.app.plugin.assembler.AssemblySelector;
import ghidra.app.plugin.assembler.GenericAssembler;
import ghidra.app.plugin.assembler.GenericAssemblerBuilder;
import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyGrammar;
import ghidra.app.plugin.assembler.sleigh.grammars.AssemblySentential;
import ghidra.app.plugin.assembler.sleigh.parse.AssemblyParser;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyResolutionFactory;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyContextGraph;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyDefaultContext;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNonTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNumericMapTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNumericTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyStringMapTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyStringTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblySymbol;
import ghidra.app.plugin.assembler.sleigh.util.DbgTimer;
import ghidra.app.plugin.languages.sleigh.SleighLanguages;
import ghidra.app.plugin.languages.sleigh.SubtableEntryVisitor;
import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.pattern.DisjointPattern;
import ghidra.app.plugin.processors.sleigh.symbol.EndSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.NameSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.Next2Symbol;
import ghidra.app.plugin.processors.sleigh.symbol.OperandSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.StartSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.SubtableSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.Symbol;
import ghidra.app.plugin.processors.sleigh.symbol.TripleSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.UseropSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.ValueMapSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.ValueSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.VarnodeListSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.VarnodeSymbol;
import ghidra.app.plugin.processors.sleigh.template.ConstructTpl;
import ghidra.app.plugin.processors.sleigh.template.HandleTpl;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.listing.Program;
import ghidra.util.SystemUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MultiMapUtils;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;

public abstract class AbstractSleighAssemblerBuilder<RP extends AssemblyResolvedPatterns, A extends GenericAssembler<RP>>
implements GenericAssemblerBuilder<RP, A> {
    protected static final DbgTimer dbg = SystemUtilities.isInTestingBatchMode() ? DbgTimer.INACTIVE : DbgTimer.ACTIVE;
    protected final SleighLanguage lang;
    protected final AbstractAssemblyResolutionFactory<RP, ?> factory;
    protected AssemblyGrammar grammar;
    protected AssemblyDefaultContext defaultContext;
    protected AssemblyContextGraph ctxGraph;
    protected AssemblyParser parser;
    protected boolean generated = false;
    protected Map<String, AssemblySymbol> builtSymbols = new HashMap<String, AssemblySymbol>();

    public AbstractSleighAssemblerBuilder(SleighLanguage lang) {
        this.lang = lang;
        this.factory = this.newResolutionFactory();
    }

    protected abstract AbstractAssemblyResolutionFactory<RP, ?> newResolutionFactory();

    protected abstract A newAssembler(AssemblySelector var1);

    protected abstract A newAssembler(AssemblySelector var1, Program var2);

    @Override
    public LanguageID getLanguageID() {
        return this.lang.getLanguageID();
    }

    @Override
    public SleighLanguage getLanguage() {
        return this.lang;
    }

    protected void generateAssembler() throws SleighException {
        try {
            this.buildGrammar();
            this.grammar.verify();
            this.buildContext();
            this.buildContextGraph();
            this.buildParser();
        }
        catch (SleighException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void checkGenerateAssembler() throws SleighException {
        if (this.generated) {
            return;
        }
        this.generated = true;
        this.generateAssembler();
    }

    @Override
    public A getAssembler(AssemblySelector selector) {
        this.checkGenerateAssembler();
        return this.newAssembler(selector);
    }

    @Override
    public A getAssembler(AssemblySelector selector, Program program) {
        this.checkGenerateAssembler();
        return this.newAssembler(selector, program);
    }

    protected MultiValuedMap<String, Integer> invVarnodeList(VarnodeListSymbol vnlist) {
        HashSetValuedHashMap result = new HashSetValuedHashMap();
        int index = -1;
        for (VarnodeSymbol vnsym : vnlist.getVarnodeTable()) {
            ++index;
            if (vnsym == null) continue;
            result.put((Object)vnsym.getName(), (Object)index);
        }
        return MultiMapUtils.unmodifiableMultiValuedMap((MultiValuedMap)result);
    }

    protected Map<Long, Integer> invValueMap(ValueMapSymbol vm) {
        HashMap<Long, Integer> result = new HashMap<Long, Integer>();
        List<Long> map = vm.getMap();
        for (int i = 0; i < map.size(); ++i) {
            long v = map.get(i);
            result.put(v, i);
        }
        return Collections.unmodifiableMap(result);
    }

    protected MultiValuedMap<String, Integer> invNameSymbol(NameSymbol ns) {
        HashSetValuedHashMap result = new HashSetValuedHashMap();
        int index = -1;
        for (String name : ns.getNameTable()) {
            ++index;
            if (name == null) continue;
            result.put((Object)name, (Object)index);
        }
        return MultiMapUtils.unmodifiableMultiValuedMap((MultiValuedMap)result);
    }

    protected AssemblySymbol getSymbolFor(Constructor cons, OperandSymbol opsym) {
        TripleSymbol defsym = opsym.getDefiningSymbol();
        Object name = defsym == null ? cons.getParent().getName() + ":" + opsym.getName() : opsym.getName();
        AssemblySymbol built = this.builtSymbols.get(name);
        if (built != null) {
            return built;
        }
        if (defsym == null) {
            HandleTpl htpl = this.getHandleTpl(cons, opsym);
            built = htpl == null ? new AssemblyNumericTerminal((String)name, 0, null) : new AssemblyNumericTerminal((String)name, htpl.getSize(), htpl.getAddressSpace());
        } else if (defsym instanceof SubtableSymbol) {
            built = new AssemblyNonTerminal((String)name);
        } else if (defsym instanceof VarnodeListSymbol) {
            VarnodeListSymbol vnListSym = (VarnodeListSymbol)defsym;
            built = new AssemblyStringMapTerminal((String)name, this.invVarnodeList(vnListSym));
        } else if (defsym instanceof VarnodeSymbol) {
            VarnodeSymbol vnSym = (VarnodeSymbol)defsym;
            built = new AssemblyStringTerminal((String)name, vnSym);
        } else if (defsym instanceof ValueMapSymbol) {
            ValueMapSymbol vnMapSym = (ValueMapSymbol)defsym;
            built = new AssemblyNumericMapTerminal((String)name, this.invValueMap(vnMapSym));
        } else if (defsym instanceof NameSymbol) {
            NameSymbol nameSym = (NameSymbol)defsym;
            built = new AssemblyStringMapTerminal((String)name, this.invNameSymbol(nameSym));
        } else {
            throw new RuntimeException("Unknown symbol for " + (String)name + ": " + String.valueOf(defsym));
        }
        this.builtSymbols.put((String)name, built);
        return built;
    }

    protected HandleTpl getHandleTpl(Constructor cons, OperandSymbol opsym) {
        ConstructTpl ctpl = cons.getTempl();
        if (null == ctpl) {
            return null;
        }
        HandleTpl htpl = ctpl.getResult();
        if (null == htpl) {
            return null;
        }
        if (opsym.getIndex() != htpl.getOffsetOperandIndex()) {
            return null;
        }
        return htpl;
    }

    protected AssemblyGrammar buildSubGrammar(SubtableSymbol subtable) {
        final AssemblyGrammar subgrammar = new AssemblyGrammar(this.factory);
        final AssemblyNonTerminal lhs = new AssemblyNonTerminal(subtable.getName());
        SleighLanguages.traverseConstructors(subtable, new SubtableEntryVisitor(){

            @Override
            public int visit(DisjointPattern pattern, Constructor cons) {
                AssemblySentential<AssemblyNonTerminal> rhs = new AssemblySentential<AssemblyNonTerminal>();
                ArrayList<Integer> indices = new ArrayList<Integer>();
                for (String str : cons.getPrintPieces()) {
                    if (str.length() == 0) continue;
                    if (str.charAt(0) == '\n') {
                        int index = str.charAt(1) - 65;
                        OperandSymbol opsym = cons.getOperand(index);
                        AssemblySymbol sym = AbstractSleighAssemblerBuilder.this.getSymbolFor(cons, opsym);
                        if (sym.takesOperandIndex()) {
                            indices.add(index);
                        }
                        rhs.addSymbol(sym);
                        continue;
                    }
                    rhs.addSeparators(str);
                }
                AbstractSleighAssemblerBuilder.this.addProduction(subgrammar, lhs, rhs, pattern, cons, indices);
                return 0;
            }
        });
        return subgrammar;
    }

    protected void addProduction(AssemblyGrammar subgrammar, AssemblyNonTerminal lhs, AssemblySentential<AssemblyNonTerminal> rhs, DisjointPattern pattern, Constructor cons, List<Integer> indices) {
        subgrammar.addProduction(lhs, rhs, pattern, cons, indices);
    }

    protected void buildGrammar() {
        try (DbgTimer.DbgCtx dc = dbg.start("Building grammar");){
            this.grammar = new AssemblyGrammar(this.factory);
            for (Symbol sym : this.lang.getSymbolTable().getSymbolList()) {
                if (sym instanceof SubtableSymbol) {
                    SubtableSymbol subtable = (SubtableSymbol)sym;
                    this.grammar.combine(this.buildSubGrammar(subtable));
                    continue;
                }
                if (sym instanceof VarnodeSymbol || sym instanceof StartSymbol || sym instanceof EndSymbol || sym instanceof Next2Symbol || sym instanceof UseropSymbol || sym instanceof OperandSymbol || sym instanceof ValueSymbol) continue;
                throw new RuntimeException("Unexpected type: " + String.valueOf(sym.getClass()));
            }
            this.grammar.setStartName("instruction");
        }
    }

    protected void buildContext() {
        this.defaultContext = new AssemblyDefaultContext(this.lang);
    }

    protected void buildContextGraph() {
        try (DbgTimer.DbgCtx dc = dbg.start("Building context graph");){
            this.ctxGraph = new AssemblyContextGraph(this.factory, this.lang, this.grammar);
        }
    }

    protected void buildParser() {
        try (DbgTimer.DbgCtx dc = dbg.start("Building parser");){
            this.parser = new AssemblyParser(this.grammar);
        }
    }

    protected AssemblyGrammar getGrammar() {
        return this.grammar;
    }

    protected AssemblyParser getParser() {
        return this.parser;
    }
}

