/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.util.Iterator;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.api.Rect2D;
import org.gephi.graph.api.SpatialIndex;
import org.gephi.graph.impl.EdgeIterableWrapper;
import org.gephi.graph.impl.GraphStore;
import org.gephi.graph.impl.NodeImpl;
import org.gephi.graph.impl.NodesQuadTree;
import org.gephi.graph.impl.SpatialNodeDataImpl;

public class SpatialIndexImpl
implements SpatialIndex {
    private final GraphStore store;
    protected final NodesQuadTree nodesTree;

    public SpatialIndexImpl(GraphStore store) {
        this.store = store;
        float boundaries = 1000000.0f;
        this.nodesTree = new NodesQuadTree(new Rect2D(-boundaries, -boundaries, boundaries, boundaries));
    }

    @Override
    public NodeIterable getNodesInArea(Rect2D rect) {
        return this.nodesTree.getNodes(rect);
    }

    @Override
    public EdgeIterable getEdgesInArea(Rect2D rect) {
        return new EdgeIterableWrapper(new EdgeIterator(rect, this.nodesTree.getNodes(rect).iterator()), this.nodesTree.lock);
    }

    protected void clearNodes() {
        this.nodesTree.clear();
    }

    protected void addNode(NodeImpl node) {
        this.nodesTree.addNode(node);
    }

    protected void removeNode(NodeImpl node) {
        this.nodesTree.removeNode(node);
    }

    protected void moveNode(NodeImpl node) {
        float x = node.x();
        float y = node.y();
        float size = node.size();
        float minX = x - size;
        float minY = y - size;
        float maxX = x + size;
        float maxY = y + size;
        this.nodesTree.updateNode(node, minX, minY, maxX, maxY);
    }

    protected class EdgeIterator
    implements Iterator<Edge> {
        private final Iterator<Node> nodeItr;
        private final Rect2D rect2D;
        private Iterator<Edge> edgeItr;
        private Edge pointer;
        private Node node;

        public EdgeIterator(Rect2D rect2D, Iterator<Node> nodeIterator) {
            this.nodeItr = nodeIterator;
            this.rect2D = rect2D;
            SpatialIndexImpl.this.nodesTree.readLock();
        }

        @Override
        public boolean hasNext() {
            while (this.pointer == null) {
                while (this.pointer == null && this.edgeItr != null && this.edgeItr.hasNext()) {
                    this.pointer = this.edgeItr.next();
                    if (this.pointer.isSelfLoop()) continue;
                    Node oppositeNode = SpatialIndexImpl.this.store.getOpposite(this.node, this.pointer);
                    SpatialNodeDataImpl spatialData = ((NodeImpl)oppositeNode).getSpatialData();
                    if (oppositeNode.getStoreId() >= this.node.getStoreId() || !this.rect2D.intersects(spatialData.minX, spatialData.minY, spatialData.maxX, spatialData.maxY)) continue;
                    this.pointer = null;
                }
                if (this.pointer != null) continue;
                this.edgeItr = null;
                if (this.nodeItr != null && this.nodeItr.hasNext()) {
                    this.node = this.nodeItr.next();
                    this.edgeItr = ((SpatialIndexImpl)SpatialIndexImpl.this).store.edgeStore.edgeIterator(this.node);
                    continue;
                }
                SpatialIndexImpl.this.nodesTree.readUnlock();
                return false;
            }
            return true;
        }

        @Override
        public Edge next() {
            Edge res = this.pointer;
            this.pointer = null;
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }
}

