/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.tasks;

import java.util.IllegalFormatException;
import java.util.List;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.table.ImagesTable;
import org.fibs.geotag.table.ImagesTableModel;
import org.fibs.geotag.tasks.UndoableBackgroundTask;
import org.fibs.geotag.track.TrackMatcher;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MatchImagesTask
extends UndoableBackgroundTask<ImageInfo> {
    private static final I18n i18n = I18nFactory.getI18n(MatchImagesTask.class);
    private ImagesTable imagesTable;
    private int currentProgress = 0;
    private List<ImageInfo> images;

    public MatchImagesTask(String group, String name, ImagesTable imagesTable, List<ImageInfo> images) {
        super(group, name);
        this.imagesTable = imagesTable;
        this.images = images;
    }

    @Override
    protected String doInBackground() throws Exception {
        int imagesMatched = 0;
        TrackMatcher trackMatcher = new TrackMatcher();
        for (ImageInfo imageInfo : this.images) {
            if (this.interruptRequested()) break;
            ++this.currentProgress;
            this.setProgressMessage();
            try {
                TrackMatcher.Match match = trackMatcher.findMatch(imageInfo.getTimeGMT());
                if (match == null || match.getMatchingSegment() == null) continue;
                trackMatcher.performMatch(imageInfo, match);
                ++imagesMatched;
                this.publish(imageInfo);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        String result = null;
        if (imagesMatched == 0) {
            result = i18n.tr("No locations found.");
        } else if (imagesMatched == 1) {
            result = i18n.tr("Found location for one image.");
        } else {
            try {
                result = String.format(i18n.tr("Found location for %d images."), imagesMatched);
            }
            catch (IllegalFormatException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public int getMaxProgress() {
        return this.images.size();
    }

    @Override
    public int getMinProgress() {
        return 1;
    }

    @Override
    public int getCurrentProgress() {
        return this.currentProgress;
    }

    @Override
    protected void process(List<ImageInfo> imageInfos) {
        ImagesTableModel tableModel = (ImagesTableModel)this.imagesTable.getModel();
        for (ImageInfo imageInfo : imageInfos) {
            int imageRow = tableModel.getRow(imageInfo);
            tableModel.fireTableRowsUpdated(imageRow, imageRow);
        }
    }
}

