/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.color.Illuminant;
import io.sf.carte.doc.color.Illuminants;
import io.sf.carte.doc.style.css.CSSColor;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSPrimitiveValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.property.ChromaticAdaption;
import io.sf.carte.doc.style.css.property.ColorConverter;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.LABColorImpl;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PercentageEvaluator;
import io.sf.carte.doc.style.css.property.PercentageValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.util.SimpleWriter;
import io.sf.jclf.math.linear3.Matrices;
import java.io.IOException;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.w3c.dom.DOMException;

abstract class BaseColor
implements CSSColor,
Cloneable,
Serializable {
    private static final long serialVersionUID = 4L;
    PrimitiveValue alpha = ColorValue.opaqueAlpha;

    BaseColor() {
    }

    @Override
    public String getColorSpace() {
        return "srgb";
    }

    Space getSpace() {
        return Space.sRGB;
    }

    @Override
    public PrimitiveValue getAlpha() {
        return this.alpha;
    }

    public void setAlpha(PrimitiveValue alpha) {
        TypedValue typed;
        PercentageEvaluator eval;
        if (alpha == null) {
            throw new NullPointerException();
        }
        if (alpha.getPrimitiveType() == CSSValue.Type.EXPRESSION) {
            eval = new PercentageEvaluator();
            try {
                alpha = (PrimitiveValue)((Object)eval.evaluateExpression((CSSExpressionValue)((Object)alpha)));
                if (alpha.getPrimitiveType() == CSSValue.Type.NUMERIC) {
                    ((NumberValue)alpha).setMaximumFractionDigits(5);
                }
            }
            catch (DOMException dOMException) {}
        } else if (alpha.getPrimitiveType() == CSSValue.Type.MATH_FUNCTION) {
            eval = new PercentageEvaluator();
            try {
                alpha = (PrimitiveValue)((Object)eval.evaluateFunction((CSSMathFunctionValue)((Object)alpha)));
                if (alpha.getPrimitiveType() == CSSValue.Type.NUMERIC) {
                    ((NumberValue)alpha).setMaximumFractionDigits(5);
                }
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        if (alpha.getUnitType() == 0) {
            typed = (TypedValue)alpha;
            float fv = typed.getFloatValue();
            if (fv < 0.0f) {
                typed = new PercentageValue();
                typed.setFloatValue((short)0, 0.0f);
                typed.setSubproperty(true);
                alpha = typed;
            } else if (fv > 1.0f) {
                typed = new PercentageValue();
                typed.setFloatValue((short)0, 1.0f);
                typed.setSubproperty(true);
                alpha = typed;
            }
        } else if (alpha.getUnitType() == 2) {
            typed = (TypedValue)alpha;
            float fv = typed.getFloatValue();
            if (fv < 0.0f) {
                typed = NumberValue.createCSSNumberValue((short)2, 0.0f);
                typed.setSubproperty(true);
                alpha = typed;
            } else if (fv > 100.0f) {
                typed = NumberValue.createCSSNumberValue((short)2, 100.0f);
                typed.setSubproperty(true);
                alpha = typed;
            }
        } else if (!(alpha.getCssValueType() == CSSValue.CssType.PROXY || alpha.getPrimitiveType() == CSSValue.Type.EXPRESSION || alpha.getPrimitiveType() == CSSValue.Type.MATH_FUNCTION || alpha.getPrimitiveType() == CSSValue.Type.IDENT && "none".equalsIgnoreCase(((TypedValue)alpha).getStringValue()))) {
            throw new DOMException(17, "Type not compatible with alpha.");
        }
        this.alpha = alpha;
    }

    static PrimitiveValue enforcePcntComponent(PrimitiveValue primi) throws DOMException {
        float fv;
        TypedValue typed;
        PercentageEvaluator eval;
        if (primi == null) {
            throw new NullPointerException();
        }
        if (primi.getPrimitiveType() == CSSValue.Type.EXPRESSION) {
            eval = new PercentageEvaluator();
            primi = (PrimitiveValue)((Object)eval.evaluateExpression((CSSExpressionValue)((Object)primi)));
        } else if (primi.getPrimitiveType() == CSSValue.Type.MATH_FUNCTION) {
            eval = new PercentageEvaluator();
            primi = (PrimitiveValue)((Object)eval.evaluateFunction((CSSMathFunctionValue)((Object)primi)));
        }
        int unit = primi.getUnitType();
        if (unit == 0) {
            typed = (TypedValue)primi;
            fv = typed.getFloatValue();
            NumberValue num = NumberValue.createCSSNumberValue((short)2, fv);
            num.setSpecified(false);
            num.setMaximumFractionDigits(4);
            primi = num;
            unit = 2;
        }
        if (unit == 2) {
            typed = (TypedValue)primi;
            fv = typed.getFloatValue();
            if (fv < 0.0f) {
                typed = NumberValue.createCSSNumberValue((short)2, 0.0f);
                typed.setSubproperty(true);
                primi = typed;
            } else if (fv > 100.0f) {
                typed = NumberValue.createCSSNumberValue((short)2, 100.0f);
                typed.setSubproperty(true);
                primi = typed;
            }
        } else if (BaseColor.isInvalidComponentType(primi)) {
            throw new DOMException(17, "Invalid color component: " + primi.getCssText());
        }
        return primi;
    }

    static boolean isInvalidComponentType(CSSPrimitiveValue primi) {
        switch (primi.getCssValueType()) {
            case TYPED: {
                switch (primi.getPrimitiveType()) {
                    case EXPRESSION: 
                    case MATH_FUNCTION: 
                    case FUNCTION: {
                        return false;
                    }
                    case IDENT: {
                        return !"none".equalsIgnoreCase(((CSSTypedValue)primi).getStringValue());
                    }
                }
                break;
            }
            case PROXY: {
                return false;
            }
        }
        return true;
    }

    PrimitiveValue enforcePcntOrNumberComponent(PrimitiveValue primi) throws DOMException {
        PercentageEvaluator eval;
        if (primi == null) {
            throw new NullPointerException();
        }
        if (primi.getPrimitiveType() == CSSValue.Type.EXPRESSION) {
            eval = new PercentageEvaluator();
            primi = (PrimitiveValue)((Object)eval.evaluateExpression((CSSExpressionValue)((Object)primi)));
        } else if (primi.getPrimitiveType() == CSSValue.Type.MATH_FUNCTION) {
            eval = new PercentageEvaluator();
            primi = (PrimitiveValue)((Object)eval.evaluateFunction((CSSMathFunctionValue)((Object)primi)));
        }
        if (primi.getUnitType() == 2) {
            TypedValue typed = (TypedValue)primi;
            float fv = typed.getFloatValue();
            if (fv < 0.0f) {
                typed = NumberValue.createCSSNumberValue((short)2, 0.0f);
                typed.setSubproperty(true);
                primi = typed;
            } else if (fv > 100.0f) {
                typed = NumberValue.createCSSNumberValue((short)2, 100.0f);
                typed.setSubproperty(true);
                primi = typed;
            }
        } else if (primi.getUnitType() == 0) {
            NumberValue number = (NumberValue)primi;
            float fv = number.getFloatValue();
            number = number.clone();
            if (this.hasPercentageComponent()) {
                number.setUnitType((short)2);
            }
            if (fv < 0.0f) {
                number.realvalue = 0.0f;
            } else if (fv > 100.0f) {
                number.realvalue = 100.0f;
            }
            number.setMaximumFractionDigits(4);
            number.setSubproperty(true);
            primi = number;
        } else if (BaseColor.isInvalidComponentType(primi)) {
            throw new DOMException(17, "Invalid color component: " + primi.getCssText());
        }
        return primi;
    }

    boolean hasPercentageComponent() {
        int len = this.getLength();
        for (int i = 1; i < len; ++i) {
            PrimitiveValue comp = this.item(i);
            if (comp == null || comp.getUnitType() != 2) continue;
            return true;
        }
        return false;
    }

    static PrimitiveValue enforceHueComponent(PrimitiveValue hue) {
        if (hue == null) {
            throw new NullPointerException();
        }
        if (hue.getPrimitiveType() == CSSValue.Type.EXPRESSION) {
            Evaluator eval = new Evaluator(80);
            try {
                hue = (PrimitiveValue)((Object)eval.evaluateExpression((CSSExpressionValue)((Object)hue)));
            }
            catch (DOMException dOMException) {}
        } else if (hue.getPrimitiveType() == CSSValue.Type.MATH_FUNCTION) {
            Evaluator eval = new Evaluator(80);
            try {
                hue = (PrimitiveValue)((Object)eval.evaluateFunction((CSSMathFunctionValue)((Object)hue)));
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        if (BaseColor.isInvalidHueType(hue)) {
            throw new DOMException(17, "Type not compatible with hue.");
        }
        return hue;
    }

    static boolean isInvalidHueType(CSSPrimitiveValue hue) {
        if (hue.getUnitType() == 0 || CSSUnit.isAngleUnitType(hue.getUnitType())) {
            return false;
        }
        switch (hue.getCssValueType()) {
            case TYPED: {
                switch (hue.getPrimitiveType()) {
                    case EXPRESSION: 
                    case MATH_FUNCTION: 
                    case FUNCTION: {
                        return false;
                    }
                    case IDENT: {
                        return !"none".equalsIgnoreCase(((CSSTypedValue)hue).getStringValue());
                    }
                }
                break;
            }
            case PROXY: {
                return false;
            }
        }
        return true;
    }

    static PrimitiveValue normalizePcntToNumber(PrimitiveValue primi, float factor, int maxFractionDigits, boolean specified) throws DOMException {
        PercentageEvaluator eval;
        if (primi == null) {
            throw new NullPointerException();
        }
        if (primi.getPrimitiveType() == CSSValue.Type.EXPRESSION) {
            eval = new PercentageEvaluator();
            primi = (PrimitiveValue)((Object)eval.evaluateExpression((CSSExpressionValue)((Object)primi)));
        } else if (primi.getPrimitiveType() == CSSValue.Type.MATH_FUNCTION) {
            eval = new PercentageEvaluator();
            primi = (PrimitiveValue)((Object)eval.evaluateFunction((CSSMathFunctionValue)((Object)primi)));
        }
        if (primi.getUnitType() == 2) {
            NumberValue number = (NumberValue)primi;
            boolean spec = number.isSpecified() && specified;
            float num = number.getFloatValue() * factor;
            number = new PercentageValue();
            number.setFloatValue((short)0, num);
            number.setSubproperty(true);
            number.setSpecified(spec);
            number.setMaximumFractionDigits(maxFractionDigits);
            primi = number;
        } else if (primi.getUnitType() != 0 && BaseColor.isInvalidComponentType(primi)) {
            throw new DOMException(17, "Type not compatible: " + primi.getCssText());
        }
        return primi;
    }

    abstract boolean hasConvertibleComponents();

    static boolean isConvertibleComponent(CSSPrimitiveValue comp) {
        return comp != null && (comp.getPrimitiveType() == CSSValue.Type.NUMERIC || comp.getPrimitiveType() == CSSValue.Type.IDENT && "none".equalsIgnoreCase(((CSSTypedValue)comp).getStringValue()));
    }

    NumberValue numberComponent(CSSTypedValue typed, float pcntDiv) throws DOMException {
        boolean specified;
        float value;
        short unit = typed.getUnitType();
        if (unit == 0) {
            value = typed.getFloatValue();
            specified = ((NumberValue)typed).isSpecified();
        } else if (unit == 2) {
            value = typed.getFloatValue() / pcntDiv;
            specified = ((NumberValue)typed).isSpecified();
        } else if (typed.getPrimitiveType() == CSSValue.Type.IDENT) {
            value = 0.0f;
            specified = true;
        } else {
            throw new DOMException(17, "Wrong component: " + typed.getCssText());
        }
        NumberValue num = new NumberValue();
        num.realvalue = value;
        num.setSpecified(specified);
        num.setMaximumFractionDigits(this.getMaximumFractionDigits());
        return num;
    }

    static NumberValue hueComponent(CSSTypedValue typed) throws DOMException {
        double h = ColorUtil.hueDegrees(typed);
        boolean specified = typed.getPrimitiveType() != CSSValue.Type.NUMERIC || ((NumberValue)typed).isSpecified();
        NumberValue num = new NumberValue();
        num.setFloatValue((short)80, (float)h);
        num.setSpecified(specified);
        num.setMaximumFractionDigits(4);
        return num;
    }

    int getMaximumFractionDigits() {
        return 4;
    }

    public String toString() {
        int len = this.getLength();
        StringBuilder buf = new StringBuilder();
        buf.append("color(").append(this.getColorSpace());
        for (int i = 1; i < len; ++i) {
            buf.append(' ');
            this.appendComponentCssText(buf, this.item(i));
        }
        if (this.isNonOpaque()) {
            buf.append(" / ");
            this.appendAlphaChannel(buf);
        }
        buf.append(')');
        return buf.toString();
    }

    StringBuilder appendComponentCssText(StringBuilder buf, PrimitiveValue component) {
        return buf.append(component.getCssText());
    }

    @Override
    public String toMinifiedString() {
        int len = this.getLength();
        StringBuilder buf = new StringBuilder();
        buf.append("color(").append(this.getColorSpace());
        for (int i = 1; i < len; ++i) {
            buf.append(' ');
            this.appendComponentMinifiedCssText(buf, this.item(i));
        }
        if (this.isNonOpaque()) {
            buf.append('/');
            this.appendAlphaChannelMinified(buf);
        }
        buf.append(')');
        return buf.toString();
    }

    StringBuilder appendComponentMinifiedCssText(StringBuilder buf, PrimitiveValue component) {
        return buf.append(component.getMinifiedCssText(""));
    }

    boolean isNonOpaque() {
        return this.alpha.getPrimitiveType() != CSSValue.Type.NUMERIC || ((CSSTypedValue)((Object)this.alpha)).getFloatValue((short)0) != 1.0f;
    }

    void appendAlphaChannel(SimpleWriter wri) throws IOException {
        if (this.alpha.getUnitType() == 0) {
            String text = this.formattedNumber((TypedValue)this.alpha);
            wri.write((CharSequence)text);
        } else {
            this.alpha.writeCssText(wri);
        }
    }

    StringBuilder appendAlphaChannel(StringBuilder buf) {
        String text = this.alpha.getUnitType() == 0 && !((NumberValue)this.alpha).isSpecified() ? this.formattedNumber((TypedValue)this.alpha) : this.alpha.getCssText();
        return buf.append(text);
    }

    StringBuilder appendAlphaChannelMinified(StringBuilder buf) {
        String text = this.alpha.getUnitType() == 0 && !((NumberValue)this.alpha).isSpecified() ? this.formattedNumberMinified((TypedValue)this.alpha) : this.alpha.getMinifiedCssText("");
        return buf.append(text);
    }

    private String formattedNumber(TypedValue alpha) {
        float f = alpha.getFloatValue((short)0);
        NumberFormat format = NumberFormat.getNumberInstance(Locale.ROOT);
        format.setMaximumFractionDigits(4);
        format.setMinimumFractionDigits(0);
        return format.format(f);
    }

    private String formattedNumberMinified(TypedValue alpha) {
        float f = alpha.getFloatValue((short)0);
        NumberFormat format = NumberFormat.getNumberInstance(Locale.ROOT);
        format.setMaximumFractionDigits(4);
        format.setMinimumFractionDigits(0);
        format.setMinimumIntegerDigits(0);
        return format.format(f);
    }

    void appendHue(StringBuilder buf, PrimitiveValue hue) {
        short unit = hue.getUnitType();
        if (unit == 80) {
            NumberValue deg = (NumberValue)hue;
            float val = deg.getFloatValue(unit);
            NumberValue number = NumberValue.createCSSNumberValue((short)0, val);
            if (!deg.isSpecified()) {
                number.setAbsolutizedUnit();
            }
            String s = number.getCssText();
            buf.append(s);
        } else {
            buf.append(hue.getCssText());
        }
    }

    void writeHue(SimpleWriter wri, PrimitiveValue hue) throws IOException {
        short unit = hue.getUnitType();
        if (unit == 80) {
            NumberValue deg = (NumberValue)hue;
            float val = deg.getFloatValue(unit);
            NumberValue number = NumberValue.createCSSNumberValue((short)0, val);
            if (!deg.isSpecified()) {
                number.setAbsolutizedUnit();
            }
            number.writeCssText(wri);
        } else {
            hue.writeCssText(wri);
        }
    }

    void appendMinifiedHue(StringBuilder buf, PrimitiveValue hue) {
        short unit = hue.getUnitType();
        if (unit == 80) {
            NumberValue deg = (NumberValue)hue;
            float val = deg.getFloatValue(unit);
            NumberValue number = NumberValue.createCSSNumberValue((short)0, val);
            if (!deg.isSpecified()) {
                number.setAbsolutizedUnit();
            }
            String s = number.getMinifiedCssText("");
            buf.append(s);
        } else {
            buf.append(hue.getMinifiedCssText(""));
        }
    }

    void set(BaseColor color) {
        this.alpha = color.alpha;
    }

    static void setLabColor(double[] lab, PrimitiveValue alpha, LABColorImpl labColor) {
        NumberValue primiL = NumberValue.createCSSNumberValue((short)2, (float)lab[0]);
        NumberValue primia = NumberValue.createCSSNumberValue((short)0, (float)lab[1]);
        NumberValue primib = NumberValue.createCSSNumberValue((short)0, (float)lab[2]);
        primiL.setAbsolutizedUnit();
        primia.setAbsolutizedUnit();
        primib.setAbsolutizedUnit();
        labColor.setLightness(primiL);
        labColor.setA(primia);
        labColor.setB(primib);
        labColor.setAlpha(alpha.clone());
    }

    public int hashCode() {
        int prime = 31;
        int result = Objects.hash(this.getColorSpace().toLowerCase(Locale.ROOT));
        result = 31 * result + Objects.hash(new Object[]{this.getColorModel()});
        result = 31 * result + Objects.hash(this.alpha);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(this instanceof BaseColor)) {
            return false;
        }
        BaseColor other = (BaseColor)obj;
        return Objects.equals(this.alpha, other.alpha) && this.getColorSpace().equals(other.getColorSpace()) && Objects.equals((Object)this.getColorModel(), (Object)other.getColorModel());
    }

    @Override
    public abstract CSSColorValue.ColorModel getColorModel();

    @Override
    public abstract NumberValue component(String var1);

    @Override
    public abstract PrimitiveValue item(int var1);

    @Override
    public int getLength() {
        return 4;
    }

    abstract void setComponent(int var1, PrimitiveValue var2);

    abstract void setColorComponents(double[] var1);

    @Override
    public abstract double[] toNumberArray() throws DOMException;

    @Override
    public double[] toXYZ(Illuminant white) {
        double[] rgb = this.toSRGB(true);
        double[] xyz = ColorUtil.srgbToXYZd65(rgb[0], rgb[1], rgb[2]);
        if (white == Illuminant.D50) {
            xyz = ColorUtil.d65xyzToD50(xyz);
        }
        return xyz;
    }

    @Override
    public double[] toXYZ(double[] white) {
        double[] rgb = this.toSRGB(true);
        double[] xyz = ColorUtil.srgbToXYZd65(rgb[0], rgb[1], rgb[2]);
        if (!Arrays.equals(Illuminants.whiteD65, white)) {
            double[][] cam = new double[3][3];
            ChromaticAdaption.chromaticAdaptionMatrix(Illuminants.whiteD65, white, cam);
            double[] result = new double[3];
            Matrices.multiplyByVector3((double[][])cam, (double[])xyz, (double[])result);
            xyz = result;
        }
        return xyz;
    }

    void toLABColor(LABColorImpl color) throws DOMException {
        double[] xyz = this.toXYZ(Illuminant.D50);
        double[] lab = new double[3];
        ColorUtil.xyzD50ToLab(xyz, lab);
        BaseColor.setLabColor(lab, this.getAlpha(), color);
    }

    @Override
    public BaseColor toColorSpace(String colorSpace) throws DOMException {
        ColorConverter converter = new ColorConverter(true);
        converter.toColorSpace(this, colorSpace, true);
        return converter.getLastColor();
    }

    @Override
    public boolean isInGamut(String colorSpace) {
        double[] comp;
        colorSpace = colorSpace.toLowerCase(Locale.ROOT);
        if (this.getColorSpace().equals(colorSpace) || this.getSpace() == Space.sRGB || this.getSpace() == Space.Linear_sRGB) {
            return true;
        }
        switch (colorSpace) {
            case "xyz": 
            case "xyz-d65": 
            case "xyz-d50": 
            case "lab": 
            case "lch": 
            case "oklab": 
            case "oklch": {
                return true;
            }
            case "srgb": 
            case "hsl": 
            case "hsla": 
            case "hwb": 
            case "rgb": {
                colorSpace = "srgb-linear";
            }
        }
        ColorConverter converter = new ColorConverter(false);
        for (double c : comp = converter.toColorSpace(this, colorSpace, false)) {
            if (!(c <= -1.0E-4) && !(c >= 1.0001)) continue;
            return false;
        }
        return true;
    }

    @Override
    public float deltaEOK(CSSColor color) {
        double[] ok1 = BaseColor.toOKLab(this);
        double[] ok2 = BaseColor.toOKLab((BaseColor)color);
        return (float)ColorUtil.deltaEokLab(ok1, ok2);
    }

    private static double[] toOKLab(BaseColor color) {
        if (color.getSpace() == Space.OK_Lab) {
            return color.toNumberArray();
        }
        double[] result = new double[3];
        if (color.getSpace() == Space.OK_LCh) {
            double[] lch = color.toNumberArray();
            ColorUtil.lchToLab(lch, result);
        } else {
            double[] xyz = color.toXYZ(Illuminant.D65);
            ColorUtil.xyzD65ToOkLab(xyz, result);
        }
        return result;
    }

    abstract double[] toSRGB(boolean var1);

    @Override
    public abstract ColorValue packInValue();

    @Override
    public abstract BaseColor clone();

    static enum Space {
        sRGB,
        Linear_sRGB,
        p3,
        A98_RGB,
        ProPhoto_RGB,
        Rec2020,
        CIE_XYZ,
        CIE_XYZ_D50,
        CIE_Lab,
        CIE_LCh,
        OK_Lab,
        OK_LCh,
        OTHER;

    }
}

