/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.DOMHierarchyRequestException;
import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.DOMNodeList;
import io.sf.carte.doc.dom.ElementList;
import io.sf.carte.doc.dom.EmptyNodeList;
import io.sf.carte.doc.dom.NodeFilter;
import io.sf.carte.doc.dom.NodeListIterator;
import io.sf.carte.doc.style.css.CSSDocument;
import java.io.Serializable;
import java.text.Normalizer;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

abstract class AbstractDOMNode
implements DOMNode,
Serializable {
    private static final long serialVersionUID = 1L;
    private final short nodeType;
    private AbstractDOMNode parentNode = null;
    AbstractDOMNode previousSibling = null;
    AbstractDOMNode nextSibling = null;
    private Map<String, Object> userData = null;
    private Map<String, UserDataHandler> userDataHandler = null;
    static final RawNodeList emptyNodeList = new EmptyNodeList();

    AbstractDOMNode(short nodeType) {
        this.nodeType = nodeType;
    }

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
    }

    @Override
    public short getNodeType() {
        return this.nodeType;
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    void setParentNode(AbstractDOMNode parentNode) {
        this.parentNode = parentNode;
    }

    void setAttributeOwner(DOMElement newOwner) {
        this.parentNode = newOwner;
    }

    @Override
    public DOMNode getParentNode() {
        return this.parentNode;
    }

    AbstractDOMNode parentNode() {
        return this.parentNode;
    }

    boolean isDocumentDescendant() {
        AbstractDOMNode node = this;
        AbstractDOMNode parent;
        while ((parent = node.parentNode) != null) {
            node = parent;
        }
        return node.getNodeType() == 9;
    }

    @Override
    public DOMNodeList getChildNodes() {
        return this.getNodeList();
    }

    RawNodeList getNodeList() {
        return emptyNodeList;
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public DOMNode getFirstChild() {
        return this.getNodeList().getFirst();
    }

    @Override
    public DOMNode getLastChild() {
        return this.getNodeList().getLast();
    }

    @Override
    public DOMNode getPreviousSibling() {
        return this.previousSibling;
    }

    @Override
    public DOMNode getNextSibling() {
        return this.nextSibling;
    }

    @Override
    public DOMNode appendChild(Node newChild) throws DOMException {
        AbstractDOMNode added = (AbstractDOMNode)newChild;
        if (newChild.getNodeType() != 11) {
            this.preInsertChild(newChild, null);
            this.getNodeList().add(added);
            this.postInsertChild(added);
        } else {
            this.appendDocumentFragment(newChild);
        }
        return added;
    }

    void preInsertChild(Node newChild, Node refNode) {
        this.checkInsertNode(newChild, refNode);
        this.checkNewChildParentNode(newChild);
    }

    void checkInsertNode(Node newChild, Node refNode) {
        if (newChild.getNodeType() == 9) {
            throw new DOMHierarchyRequestException("Cannot append a document.");
        }
        this.checkInsertNodeHierarchy(newChild, refNode);
        this.checkDocumentOwner(newChild);
    }

    void checkInsertNodeHierarchy(Node newChild, Node refNode) {
        if (newChild.getNodeType() == 2) {
            throw new DOMHierarchyRequestException("Use setAttributeNode to add attribute nodes.");
        }
        for (Node node = this; node != null; node = node.getParentNode()) {
            if (!node.isSameNode(newChild)) continue;
            throw new DOMHierarchyRequestException("Cannot insert itself or an ancestor.");
        }
    }

    void checkDocumentOwner(Node newChild) {
        if (newChild.getOwnerDocument() != this.getOwnerDocument()) {
            throw new DOMException(4, "Different document owners.");
        }
    }

    void checkNewChildParentNode(Node newChild) {
        Node node = newChild.getParentNode();
        if (node != null) {
            node.removeChild(newChild);
        }
    }

    void checkReplaceNode(Node newChild, Node oldNode) {
        if (newChild.getNodeType() == 9) {
            throw new DOMHierarchyRequestException("Cannot append a document.");
        }
        this.checkReplaceNodeHierarchy(newChild, oldNode);
        this.checkDocumentOwner(newChild);
    }

    void checkReplaceNodeHierarchy(Node newChild, Node oldNode) {
        this.checkInsertNodeHierarchy(newChild, null);
    }

    void postInsertChild(AbstractDOMNode newChild) {
        newChild.setParentNode(this);
    }

    private void appendDocumentFragment(Node newChild) {
        Node added = newChild.getFirstChild();
        while (added != null) {
            Node next = added.getNextSibling();
            this.appendChild(added);
            added = next;
        }
    }

    @Override
    public DOMNode insertBefore(Node newChild, Node refChild) throws DOMException {
        AbstractDOMNode inserted = (AbstractDOMNode)newChild;
        AbstractDOMNode refNode = (AbstractDOMNode)refChild;
        if (refNode != null) {
            if (refNode != inserted) {
                if (!this.getNodeList().contains(refNode)) {
                    throw new DOMException(8, "Not a child of this node.");
                }
                if (inserted.getNodeType() == 11) {
                    this.insertDocumentFragment(inserted, refNode);
                    return inserted;
                }
                this.preInsertChild(inserted, refNode);
                this.getNodeList().insertBefore(inserted, refNode);
                this.postInsertChild(inserted);
            }
        } else {
            this.appendChild(inserted);
        }
        return inserted;
    }

    private void insertDocumentFragment(AbstractDOMNode newChild, AbstractDOMNode refNode) {
        AbstractDOMNode curNode = (AbstractDOMNode)newChild.getFirstChild();
        while (curNode != null) {
            AbstractDOMNode next = curNode.nextSibling;
            this.insertBefore(curNode, refNode);
            curNode = next;
        }
    }

    @Override
    public DOMNode replaceChild(Node newChild, Node oldChild) throws DOMException {
        int index = this.getNodeList().indexOf(oldChild);
        if (index == -1) {
            throw new DOMException(8, "Not a child of this node.");
        }
        AbstractDOMNode replaced = (AbstractDOMNode)oldChild;
        AbstractDOMNode newNode = (AbstractDOMNode)newChild;
        if (replaced != newNode) {
            if (newChild.getNodeType() == 11) {
                this.replaceWithDocumentFragment(newNode, replaced);
            } else {
                this.replaceWithNonDocumentFragment(newNode, replaced);
            }
            replaced.setParentNode(null);
            this.postRemoveChild(replaced);
        }
        return replaced;
    }

    private void replaceWithNonDocumentFragment(AbstractDOMNode newNode, AbstractDOMNode replaced) {
        this.preReplaceChild(newNode, replaced);
        replaced = this.getNodeList().replace(newNode, replaced);
        AbstractDOMNode.callUserHandlers((short)3, replaced, null);
        newNode.setParentNode(this);
    }

    void preReplaceChild(AbstractDOMNode newNode, AbstractDOMNode replaced) {
        this.preInsertChild(newNode, null);
    }

    private void replaceWithDocumentFragment(AbstractDOMNode newChild, AbstractDOMNode replaced) {
        AbstractDOMNode curNode = (AbstractDOMNode)newChild.getFirstChild();
        if (curNode != null) {
            AbstractDOMNode next = curNode.nextSibling;
            this.replaceWithNonDocumentFragment(curNode, replaced);
            AbstractDOMNode lastNode = curNode;
            curNode = next;
            while (curNode != null) {
                next = curNode.nextSibling;
                this.insertAfter(curNode, lastNode);
                lastNode = curNode;
                curNode = next;
            }
        }
    }

    void insertAfter(AbstractDOMNode newNode, AbstractDOMNode refNode) {
        this.preInsertChild(newNode, refNode);
        AbstractDOMNode next = refNode.nextSibling;
        if (next != null) {
            this.getNodeList().insertBefore(newNode, next);
        } else {
            this.getNodeList().add(newNode);
        }
        this.postInsertChild(newNode);
    }

    @Override
    public DOMNode removeChild(Node oldChild) throws DOMException {
        if (!this.getNodeList().contains(oldChild)) {
            throw new DOMException(8, "Not a child.");
        }
        AbstractDOMNode removed = (AbstractDOMNode)oldChild;
        removed.removeFromParent(this.getNodeList());
        this.postRemoveChild(removed);
        return removed;
    }

    void postRemoveChild(AbstractDOMNode removed) {
    }

    void removeFromParent(RawNodeList nodeList) {
        this.setParentNode(null);
        nodeList.remove(this);
        AbstractDOMNode.callUserHandlers((short)3, this, null);
    }

    @Override
    public void removeAllChild() {
        if (this.hasChildNodes()) {
            RawNodeList childnodes = this.getNodeList();
            for (AbstractDOMNode removed : childnodes) {
                removed.removeFromParent(childnodes);
                this.postRemoveChild(removed);
            }
        }
    }

    static void callUserHandlers(short operation, AbstractDOMNode child, Node destNode) {
        if (child.userDataHandler != null) {
            for (Map.Entry<String, UserDataHandler> entry : child.userDataHandler.entrySet()) {
                String key = entry.getKey();
                UserDataHandler handler = entry.getValue();
                if (handler == null) continue;
                handler.handle(operation, key, child.userData.get(key), child, destNode);
            }
        }
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        this.lazyUserData();
        Object old_data = this.userData.get(key);
        this.userData.put(key, data);
        this.userDataHandler.put(key, handler);
        return old_data;
    }

    private void lazyUserData() {
        if (this.userData == null) {
            this.userData = new HashMap<String, Object>(2);
            this.userDataHandler = new HashMap<String, UserDataHandler>(2);
        }
    }

    @Override
    public Object getUserData(String key) {
        return this.userData != null ? this.userData.get(key) : null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void normalize() {
        node /* !! */  = this.getFirstChild();
        lasttype = 1;
        config = this.getOwnerDocument().domConfig;
        isWhitespacePre = 0;
        if (!config.useComputedStyles) {
            isWhitespacePre = 2;
        }
        if (!config.cssWhitespaceProcessing) {
            isWhitespacePre = 1;
        }
        lastnode /* !! */  = null;
        while (node /* !! */  != null) {
            block22: {
                block21: {
                    next = node /* !! */ .getNextSibling();
                    type = node /* !! */ .getNodeType();
                    if (type != 3) break block21;
                    text = (Text)node /* !! */ ;
                    data = text.getData();
                    if (data.length() == 0) {
                        ((AbstractDOMNode)text).removeFromParent(this.getNodeList());
                        node /* !! */  = next;
                        continue;
                    }
                    v0 = isECW = config.cssWhitespaceProcessing != false && text.isElementContentWhitespace() != false;
                    if (isECW && isWhitespacePre == 0) {
                        if (this.isWhitespacePreserving()) {
                            isWhitespacePre = 1;
                            isECW = false;
                        } else {
                            isWhitespacePre = 2;
                        }
                    }
                    if (isECW) {
                        if (lastnode /* !! */  == null) {
                            ((AbstractDOMNode)node /* !! */ ).removeFromParent(this.getNodeList());
                            node /* !! */  = next;
                            continue;
                        }
                        if (next == null) {
                            ((AbstractDOMNode)node /* !! */ ).removeFromParent(this.getNodeList());
                            while (lastnode /* !! */  != null && lastnode /* !! */ .getNodeType() == 3 && ((Text)lastnode /* !! */ ).isElementContentWhitespace()) {
                                ((AbstractDOMNode)lastnode /* !! */ ).removeFromParent(this.getNodeList());
                                lastnode /* !! */  = lastnode /* !! */ .getPreviousSibling();
                            }
                            break;
                        }
                        text.setData(" ");
                        data = " ";
                    } else if (config.normalizeCharacters && data != (normalized = Normalizer.normalize(data, Normalizer.Form.NFC))) {
                        text.setData(normalized);
                        data = normalized;
                    }
                    if (lasttype != 3) break block22;
                    prevText = (Text)lastnode /* !! */ ;
                    if (!prevText.isElementContentWhitespace() || isWhitespacePre == 1) ** GOTO lbl-1000
                    if (isWhitespacePre == 0) {
                        v1 = this.whitespacePreserving();
                        isWhitespacePre = v1;
                        ** if (v1 != 1) goto lbl-1000
                    }
                    ** GOTO lbl-1000
lbl-1000:
                    // 2 sources

                    {
                        if (!isECW || next != null && (next.getNodeType() != 3 || !((Text)next).isElementContentWhitespace())) {
                            prevText.setData(prevText.getData() + data);
                        }
                        ** GOTO lbl58
                    }
lbl-1000:
                    // 2 sources

                    {
                        if (!isECW) {
                            prevText.setData(" " + data);
                        }
                    }
lbl58:
                    // 4 sources

                    ((AbstractDOMNode)node /* !! */ ).removeFromParent(this.getNodeList());
                    node /* !! */  = next;
                    continue;
                }
                if (type == 1) {
                    node /* !! */ .normalize();
                } else if (type == 8 && !config.keepComments) {
                    ((AbstractDOMNode)node /* !! */ ).removeFromParent(this.getNodeList());
                }
            }
            lasttype = type;
            lastnode /* !! */  = node /* !! */ ;
            node /* !! */  = next;
        }
    }

    private byte whitespacePreserving() {
        return this.isWhitespacePreserving() ? (byte)1 : 2;
    }

    private boolean isWhitespacePreserving() {
        if (this.getNodeType() == 1) {
            String value = ((DOMElement)this).getComputedStyle(null).getPropertyValue("white-space");
            return "pre".equalsIgnoreCase(value) || "pre-wrap".equalsIgnoreCase(value) || "break-spaces".equalsIgnoreCase(value);
        }
        return false;
    }

    @Override
    @Deprecated
    public Object getFeature(String feature, String version) {
        return null;
    }

    @Override
    @Deprecated
    public boolean isSupported(String feature, String version) {
        return true;
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        Node node;
        if (other == this) {
            return 0;
        }
        if (this.getOwnerDocument() != other.getOwnerDocument()) {
            return 1;
        }
        short mask = 0;
        int mydepth = 1;
        int otherdepth = 1;
        for (node = this.getParentNode(); node != null; node = node.getParentNode()) {
            if (node.equals(other)) {
                mask = (short)(mask + 16);
                mask = (short)(mask + 4);
                break;
            }
            mydepth = (short)(mydepth + 1);
        }
        if (mask == 0) {
            for (node = other.getParentNode(); node != null; node = node.getParentNode()) {
                if (node.equals(this)) {
                    mask = (short)(mask + 8);
                    mask = (short)(mask + 2);
                    break;
                }
                otherdepth = (short)(otherdepth + 1);
            }
        }
        if (mask == 0) {
            int depth = mydepth > otherdepth ? otherdepth : mydepth;
            int[] myindex = new int[depth];
            int[] otherindex = new int[depth];
            this.computeIndexArray(this, myindex);
            this.computeIndexArray((AbstractDOMNode)other, otherindex);
            for (int k = 0; k < depth; k = (int)((short)(k + 1))) {
                if (myindex[k] == otherindex[k]) continue;
                if (myindex[k] > otherindex[k]) {
                    return 4;
                }
                return 2;
            }
        }
        return mask;
    }

    private void computeIndexArray(AbstractDOMNode node, int[] myindex) {
        AbstractDOMNode parent = (AbstractDOMNode)node.getParentNode();
        int i = myindex.length - 1;
        while (parent != null) {
            myindex[i] = parent.getNodeList().indexOf(node);
            node = parent;
            parent = (AbstractDOMNode)node.getParentNode();
            --i;
        }
    }

    @Override
    public String getTextContent() throws DOMException {
        String text;
        switch (this.getNodeType()) {
            case 1: 
            case 5: 
            case 6: 
            case 11: {
                if (this.getNodeList().isEmpty()) {
                    text = "";
                    break;
                }
                StringBuilder buf = new StringBuilder(64);
                this.appendTextContent(buf);
                text = buf.toString();
                break;
            }
            case 3: {
                text = this.getNodeValue();
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                text = this.getNodeValue();
                break;
            }
            default: {
                text = null;
            }
        }
        return text;
    }

    void appendTextContent(StringBuilder buf) {
        switch (this.getNodeType()) {
            case 1: 
            case 5: 
            case 6: 
            case 11: {
                AbstractDOMNode node = this.getNodeList().getFirst();
                while (node != null) {
                    short type = node.getNodeType();
                    if (type == 8 || type == 7) {
                        node = node.nextSibling;
                        continue;
                    }
                    node.appendTextContent(buf);
                    node = node.nextSibling;
                }
                break;
            }
            case 3: {
                String text = this.getNodeValue();
                buf.append(text);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: {
                String text = this.getNodeValue();
                buf.append(text);
                break;
            }
        }
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        this.getNodeList().clear();
        if (textContent != null && textContent.length() != 0) {
            AbstractDOMNode text = (AbstractDOMNode)((Object)this.getOwnerDocument().createTextNode(textContent));
            this.getNodeList().add(text);
            text.setParentNode(this);
        }
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return null;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return null;
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return this.getOwnerDocument().isDefaultNamespace(namespaceURI);
    }

    @Override
    public boolean isEqualNode(Node arg) {
        if (arg != null && this.getNodeType() == arg.getNodeType() && this.getNodeName().equals(arg.getNodeName()) && this.stringEquals(this.getLocalName(), arg.getLocalName()) && this.stringEquals(this.getNamespaceURI(), arg.getNamespaceURI()) && this.stringEquals(this.getPrefix(), arg.getPrefix()) && this.stringEquals(this.getNodeValue(), arg.getNodeValue()) && this.getNodeList().getLength() == arg.getChildNodes().getLength()) {
            Node node = this.getFirstChild();
            Node othernode = arg.getFirstChild();
            while (node != null) {
                if (!node.isEqualNode(othernode)) {
                    return false;
                }
                node = node.getNextSibling();
                othernode = othernode.getNextSibling();
            }
            NamedNodeMap nmap = this.getAttributes();
            NamedNodeMap othernmap = arg.getAttributes();
            if (nmap == null) {
                return othernmap == null;
            }
            int sz = nmap.getLength();
            if (sz == othernmap.getLength()) {
                block1: for (int i = 0; i < sz; ++i) {
                    Attr attr = (Attr)nmap.item(i);
                    for (int j = 0; j < sz; ++j) {
                        Attr otherAttr = (Attr)othernmap.item(j);
                        if (attr.isEqualNode(otherAttr) && attr.isId() == otherAttr.isId()) continue block1;
                    }
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean stringEquals(String str1, String str2) {
        if (str1 == str2) {
            return true;
        }
        if (str1 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    @Override
    public boolean isSameNode(Node other) {
        return other == this;
    }

    public boolean contains(Node node) {
        Node n = node;
        do {
            if (n != this) continue;
            return true;
        } while ((n = n.getParentNode()) != null);
        return false;
    }

    @Override
    public abstract DOMDocument getOwnerDocument();

    static interface RawNodeList
    extends DOMNodeList {
        public void add(AbstractDOMNode var1) throws DOMException;

        public void insertBefore(AbstractDOMNode var1, AbstractDOMNode var2);

        public void clear();

        public AbstractDOMNode getFirst();

        public AbstractDOMNode getLast();

        public int indexOf(Node var1);

        public void remove(AbstractDOMNode var1);

        public AbstractDOMNode replace(AbstractDOMNode var1, AbstractDOMNode var2);

        public Iterator<DOMElement> elementIterator();

        public Iterator<DOMElement> elementIterator(String var1) throws DOMException;

        public Iterator<DOMElement> elementIteratorNS(String var1, String var2);

        public Iterator<Attr> attributeIterator();
    }

    static interface ChildCollections
    extends RawNodeList {
        public ElementList getChildren();

        public Iterator<DOMNode> createDescendingIterator();

        public Iterator<DOMNode> createIterator(BitSet var1);

        public Iterator<DOMNode> createIterator(int var1, NodeFilter var2);

        public NodeListIterator createListIterator();

        public ElementList getElementsByTagNameNS(String var1, String var2);

        public ElementList getElementsByTagName(String var1, boolean var2);

        public ElementList getElementsByClassName(String var1, CSSDocument.ComplianceMode var2);
    }
}

