/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import java.net.URL;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.link.LinkController;

class ChatHistoryHyperlinkHandler {
    private static final LinkControllerAdapter DEFAULT_LINK_CONTROLLER = new LinkControllerAdapter(){

        @Override
        public Hyperlink createHyperlink(String uriText) throws Exception {
            return LinkController.createHyperlink((String)uriText);
        }

        @Override
        public void loadHyperlink(Hyperlink hyperlink) {
            LinkController.getController().loadHyperlink(hyperlink);
        }
    };
    private final LinkControllerAdapter linkController;

    static LinkControllerAdapter defaultLinkControllerAdapter() {
        return DEFAULT_LINK_CONTROLLER;
    }

    ChatHistoryHyperlinkHandler(LinkControllerAdapter linkController) {
        this.linkController = linkController;
    }

    HyperlinkListener createListener() {
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent event) {
                if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                String uriText = ChatHistoryHyperlinkHandler.this.uriText(event);
                if (uriText == null || uriText.trim().isEmpty()) {
                    return;
                }
                try {
                    Hyperlink hyperlink = ChatHistoryHyperlinkHandler.this.linkController.createHyperlink(uriText);
                    ChatHistoryHyperlinkHandler.this.linkController.loadHyperlink(hyperlink);
                }
                catch (Exception ignored) {
                    LogUtils.warn((Throwable)ignored);
                }
            }
        };
    }

    private String uriText(HyperlinkEvent event) {
        URL url = event.getURL();
        if (url != null) {
            return url.toExternalForm();
        }
        return event.getDescription();
    }

    static interface LinkControllerAdapter {
        public Hyperlink createHyperlink(String var1) throws Exception;

        public void loadHyperlink(Hyperlink var1);
    }
}

