/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon.hierarchicalicons;

import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.icon.hierarchicalicons.HierarchicalIcons;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.styles.LogicalStyleController;

class AccumulatedIcons
implements IExtension {
    private static final AccumulatedIcons EMPTY_SET = new AccumulatedIcons(Collections.emptyList());
    private final TreeSet<NamedIcon> childIcons;
    private final Collection<? extends NamedIcon> ownIcons;

    AccumulatedIcons(Collection<? extends NamedIcon> ownIcons) {
        this.ownIcons = ownIcons;
        this.childIcons = new TreeSet();
    }

    public Collection<NamedIcon> getAccumulatedIcons() {
        return this.childIcons;
    }

    private void addAccumulatedIconsToTreeSet(NodeModel child) {
        IconController iconController = IconController.getController();
        this.childIcons.addAll(iconController.getIcons(child, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE));
        AccumulatedIcons icons = child.getExtension(AccumulatedIcons.class);
        if (icons == null) {
            return;
        }
        this.childIcons.addAll(icons.childIcons);
    }

    static boolean setStyleCheckForChange(NodeModel node, HierarchicalIcons.Mode mode) {
        Collection<NamedIcon> ownIcons = IconController.getController().getIcons(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        AccumulatedIcons iconSet = new AccumulatedIcons(ownIcons);
        boolean first = true;
        for (NodeModel child : node.getChildren()) {
            if (first || mode.equals((Object)HierarchicalIcons.Mode.UNION)) {
                iconSet.addAccumulatedIconsToTreeSet(child);
            } else {
                AccumulatedIcons iconSet2 = new AccumulatedIcons(Collections.EMPTY_SET);
                iconSet2.addAccumulatedIconsToTreeSet(child);
                iconSet.childIcons.retainAll(iconSet2.childIcons);
                if (iconSet.ownIcons.isEmpty() && iconSet.childIcons.isEmpty()) break;
            }
            first = false;
        }
        iconSet.childIcons.removeAll(ownIcons);
        boolean setContainsIcons = !iconSet.ownIcons.isEmpty() || !iconSet.childIcons.isEmpty();
        AccumulatedIcons oldSet = (AccumulatedIcons)node.putExtension(setContainsIcons ? iconSet : EMPTY_SET);
        if (iconSet.equals(oldSet) || iconSet.ownIcons.isEmpty() && iconSet.childIcons.isEmpty() && oldSet == null) {
            return false;
        }
        Controller.getCurrentModeController().getMapController().delayedNodeRefresh(node, "hierarchical_icons", null, null);
        return true;
    }

    public int hashCode() {
        return this.childIcons.hashCode() + this.ownIcons.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AccumulatedIcons) {
            AccumulatedIcons ai = (AccumulatedIcons)obj;
            return this.ownIcons.equals(ai.ownIcons) && this.childIcons.equals(ai.childIcons);
        }
        return false;
    }

    public String toString() {
        return "AccumulatedIcons [ownIcons=" + this.ownIcons + ", childIcons=" + this.childIcons + "]";
    }
}

