/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias;

import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.ParseIssue;
import org.junit.Assert;
import org.junit.Test;

public class GalimatiasParseExceptionTest {
    @Test
    public void defaultsParseIssueToUnspecified() {
        GalimatiasParseException exception = new GalimatiasParseException("message");
        Assert.assertEquals((Object)((Object)ParseIssue.UNSPECIFIED), (Object)((Object)exception.getParseIssue()));
    }

    @Test
    public void defaultsParseIssueToUnspecifiedWhenPositionIsProvided() {
        GalimatiasParseException exception = new GalimatiasParseException("message", 1);
        Assert.assertEquals((Object)((Object)ParseIssue.UNSPECIFIED), (Object)((Object)exception.getParseIssue()));
    }

    @Test
    public void defaultsPositionToNegativeOne() {
        GalimatiasParseException exception = new GalimatiasParseException("message");
        Assert.assertEquals((long)-1L, (long)exception.getPosition());
    }

    @Test
    public void setsParseIssueToUnspecifiedWhenNullIsProvided() {
        GalimatiasParseException exception = new GalimatiasParseException("message", null, 1, new RuntimeException());
        Assert.assertEquals((Object)((Object)ParseIssue.UNSPECIFIED), (Object)((Object)exception.getParseIssue()));
    }

    @Test
    public void setsAllFieldsCorrectlyWhenFullConstructorIsUsed() {
        String message = "message";
        ParseIssue parseIssue = ParseIssue.INVALID_PERCENT_ENCODING;
        boolean position = true;
        RuntimeException cause = new RuntimeException();
        GalimatiasParseException exception = new GalimatiasParseException("message", parseIssue, 1, cause);
        Assert.assertEquals((Object)"message", (Object)exception.getMessage());
        Assert.assertEquals((Object)((Object)parseIssue), (Object)((Object)exception.getParseIssue()));
        Assert.assertEquals((long)1L, (long)exception.getPosition());
        Assert.assertEquals((Object)cause, (Object)exception.getCause());
    }

    @Test
    public void setsAllFieldsCorrectlyWhenBuilderIsUsed() {
        String message = "message";
        ParseIssue parseIssue = ParseIssue.INVALID_PERCENT_ENCODING;
        boolean position = true;
        RuntimeException cause = new RuntimeException();
        GalimatiasParseException exception = GalimatiasParseException.builder().withMessage("message").withParseIssue(parseIssue).withPosition(1).withCause(cause).build();
        Assert.assertEquals((Object)"message", (Object)exception.getMessage());
        Assert.assertEquals((Object)((Object)parseIssue), (Object)((Object)exception.getParseIssue()));
        Assert.assertEquals((long)1L, (long)exception.getPosition());
        Assert.assertEquals((Object)cause, (Object)exception.getCause());
    }
}

