/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardConfiguration;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardConfigurationList;
import org.jkiss.dbeaver.ui.dashboard.navigator.DashboardCreateWizardPage;
import org.jkiss.dbeaver.ui.dashboard.navigator.DashboardResourceHandler;
import org.jkiss.dbeaver.ui.dashboard.view.DataSourceDashboardView;

public class DashboardCreateWizard
extends Wizard
implements INewWizard {
    private final DBPDataSourceContainer dataSourceContainer;
    @Nullable
    private IFolder folder;
    private DashboardCreateWizardPage pageContent;
    private String errorMessage;
    private IStructuredSelection entitySelection;
    @Nullable
    private DBPProject project;

    public DashboardCreateWizard() {
        this.dataSourceContainer = null;
    }

    public DashboardCreateWizard(DBPDataSourceContainer dataSourceContainer) {
        this.dataSourceContainer = dataSourceContainer;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("Create dashboard");
        this.setNeedsProgressMonitor(true);
        if (this.dataSourceContainer != null) {
            this.project = this.dataSourceContainer.getProject();
        } else {
            Object element;
            IFolder dashboardFolder = null;
            if (selection != null && (element = selection.getFirstElement()) != null) {
                dashboardFolder = (IFolder)Platform.getAdapterManager().getAdapter(element, IFolder.class);
            }
            if (dashboardFolder == null) {
                DBPProject activeProject = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
                if (activeProject == null) {
                    this.errorMessage = "Can't create dashboard without active project";
                } else {
                    try {
                        dashboardFolder = DashboardResourceHandler.getDashboardsFolder(activeProject, true);
                    }
                    catch (CoreException e) {
                        this.errorMessage = e.getMessage();
                    }
                }
                if (selection != null && !selection.isEmpty() && Platform.getAdapterManager().getAdapter(selection.getFirstElement(), DBSEntity.class) != null) {
                    this.entitySelection = selection;
                }
            }
            if (dashboardFolder != null) {
                this.folder = dashboardFolder;
                this.project = DBPPlatformDesktop.getInstance().getWorkspace().getProject(dashboardFolder.getProject());
            }
        }
    }

    public void addPages() {
        super.addPages();
        this.pageContent = new DashboardCreateWizardPage(this.project, this.dataSourceContainer);
        this.addPage((IWizardPage)this.pageContent);
        if (this.getContainer() != null) {
            this.pageContent.setErrorMessage(this.errorMessage);
        }
    }

    public void setContainer(IWizardContainer wizardContainer) {
        super.setContainer(wizardContainer);
        if (this.pageContent != null) {
            this.pageContent.setErrorMessage(this.errorMessage);
        }
    }

    public boolean performFinish() {
        try {
            if (this.dataSourceContainer != null) {
                DashboardConfigurationList configurationList = new DashboardConfigurationList(this.dataSourceContainer);
                configurationList.checkDefaultDashboardExistence();
                DashboardConfiguration dashboard = configurationList.createDashboard(this.pageContent.getDashboardId(), this.pageContent.getDashboardName());
                dashboard.setInitDefaultCharts(this.pageContent.isInitDefCharts());
                configurationList.saveConfiguration();
                DataSourceDashboardView.openView(UIUtils.getActiveWorkbenchWindow(), this.dataSourceContainer.getProject(), this.dataSourceContainer, dashboard.getDashboardId());
                return true;
            }
            IFile diagramFile = DashboardResourceHandler.createDashboard(this.pageContent.getDashboardName(), this.folder, (DBRProgressMonitor)new VoidProgressMonitor());
            DBPResourceHandler handler = DBPPlatformDesktop.getInstance().getWorkspace().getResourceHandler((IResource)diagramFile);
            if (handler != null) {
                handler.openResource((IResource)diagramFile);
                return true;
            }
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Error creating dashboard", null, (Throwable)e);
        }
        return false;
    }
}

