/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.spreadsheet;

import org.eclipse.swt.graphics.Point;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.data.hints.DBDValueHint;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridController;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridHint;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.data.DBDValueHintActionHandler;
import org.jkiss.utils.CommonUtils;

public class SpreadsheetHint
implements IGridHint {
    private final IResultSetController controller;
    private final DBDValueHint valueHint;

    public SpreadsheetHint(IResultSetController controller, DBDValueHint valueHint) {
        this.controller = controller;
        this.valueHint = valueHint;
    }

    @Override
    @Nullable
    public String getHintLabel() {
        return this.valueHint.getHintDescription();
    }

    @Override
    @Nullable
    public String getText() {
        return this.valueHint.getHintText();
    }

    @Override
    @Nullable
    public DBPImage getIcon() {
        return this.valueHint.getHintIcon();
    }

    @Override
    public boolean isError() {
        return this.valueHint.getHintStyle() == DBDValueHint.HintStyle.ERROR;
    }

    @Override
    public boolean isReadOnly() {
        return CommonUtils.isBitSet((int)this.valueHint.getHintOptions(), (int)1);
    }

    @Override
    public boolean hasAction() {
        return this.valueHint instanceof DBDValueHintActionHandler;
    }

    @Override
    public void performAction(@NotNull IGridController grid, @NotNull Point location, long state) {
        try {
            DBDValueHint dBDValueHint = this.valueHint;
            if (!(dBDValueHint instanceof DBDValueHintActionHandler)) {
                throw new DBCException("Hint doesn't support action");
            }
            DBDValueHintActionHandler actionHandler = (DBDValueHintActionHandler)dBDValueHint;
            actionHandler.performAction(this.controller, location, state);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Hint error", "Error execution hint action", (Throwable)e);
        }
    }

    @Override
    public String getActionToolTip() {
        DBDValueHint dBDValueHint = this.valueHint;
        if (dBDValueHint instanceof DBDValueHintActionHandler) {
            DBDValueHintActionHandler ah = (DBDValueHintActionHandler)dBDValueHint;
            return ah.getActionText();
        }
        return null;
    }
}

