/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone.cli;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.cli.AbstractCommandLineParameterHandler;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import picocli.CommandLine;

@CommandLine.Command(name="database-driver-list", aliases={"-database-driver-list", "-databaseList"}, description={"Show list of supported database drivers in json format."})
public class DataBaseInfoHandler
extends AbstractCommandLineParameterHandler {
    private static final String OUTPUT_DATABASES_JSON = "database.drivers.json";
    private static final String PRODUCT_ID_LABEL = "id";
    private static final String PRODUCT_NAME_LABEL = "name";
    private static final String PRODUCT_VERSION_LABEL = "version";
    private static final String PRODUCT_DESCRIPTION_LABEL = "description";
    private static final String PRODUCT_EDITION_LABEL = "edition";
    private static final String DATABASES_LABEL = "databases";
    private static final String DB_NAME_LABEL = "name";
    private static final String DB_CATEGORY_LABEL = "category";
    private static final String DB_EMBEDDED_LABEL = "embedded";
    private static final String DB_REQUIRE_DOWNLOAD_LABEL = "download";
    private static final String DB_ADITIONAL_FEATURE_LABEL = "pro";
    private static final Log log = Log.getLog(DataBaseInfoHandler.class);
    private static final Gson DB_GSON = new GsonBuilder().setStrictness(Strictness.LENIENT).serializeNulls().create();
    @CommandLine.Parameters(index="0", description={"Export directory"}, arity="1")
    private String directory;

    public void run() {
        Path path = Path.of(this.directory, new String[0]);
        if (!path.toFile().exists()) {
            log.error((Object)("Directory by path '" + this.directory + "' does not exists"));
            return;
        }
        if (!path.toFile().isDirectory()) {
            log.error((Object)("Target location is not a directory '" + this.directory + "'"));
            return;
        }
        this.publishDataBaseInfo(path.resolve(OUTPUT_DATABASES_JSON));
    }

    private void publishDataBaseInfo(@NotNull Path path) {
        List<DriverDescriptor> drivers = this.getSupportedDBInstances();
        if (drivers.isEmpty()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter mdWriter = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (JsonWriter jsonWriter = DB_GSON.newJsonWriter((Writer)mdWriter);){
                    jsonWriter.setIndent("\t");
                    jsonWriter.beginObject();
                    JSONUtils.field((JsonWriter)jsonWriter, (String)PRODUCT_ID_LABEL, (String)Platform.getProduct().getId());
                    JSONUtils.field((JsonWriter)jsonWriter, (String)PRODUCT_EDITION_LABEL, (String)Platform.getProduct().getProperty("appEdition"));
                    JSONUtils.field((JsonWriter)jsonWriter, (String)"name", (String)GeneralUtils.getProductName());
                    JSONUtils.field((JsonWriter)jsonWriter, (String)PRODUCT_VERSION_LABEL, (String)GeneralUtils.getPlainVersion());
                    JSONUtils.field((JsonWriter)jsonWriter, (String)PRODUCT_DESCRIPTION_LABEL, (String)Platform.getProduct().getDescription());
                    jsonWriter.name(DATABASES_LABEL);
                    jsonWriter.beginArray();
                    for (DriverDescriptor driver : drivers) {
                        jsonWriter.beginObject();
                        JSONUtils.field((JsonWriter)jsonWriter, (String)"name", (String)driver.getName());
                        JSONUtils.serializeObjectList((JsonWriter)jsonWriter, (String)DB_CATEGORY_LABEL, (Collection)driver.getCategories());
                        if (driver.isEmbedded()) {
                            JSONUtils.field((JsonWriter)jsonWriter, (String)DB_EMBEDDED_LABEL, (boolean)Boolean.TRUE);
                        }
                        if (this.isRequireToDownload(driver)) {
                            JSONUtils.field((JsonWriter)jsonWriter, (String)DB_REQUIRE_DOWNLOAD_LABEL, (boolean)Boolean.TRUE);
                        }
                        if (this.isExtendedInPro(driver)) {
                            JSONUtils.field((JsonWriter)jsonWriter, (String)DB_ADITIONAL_FEATURE_LABEL, (boolean)Boolean.TRUE);
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                    jsonWriter.endObject();
                    jsonWriter.flush();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    private List<DriverDescriptor> getSupportedDBInstances() {
        ArrayList<DriverDescriptor> supportedDataBases = new ArrayList<DriverDescriptor>();
        DataSourceProviderRegistry dataSourceRegistry = DataSourceProviderRegistry.getInstance();
        List dataSourceProviders = dataSourceRegistry.getDataSourceProviders();
        for (DataSourceProviderDescriptor providerDescriptor : dataSourceProviders) {
            for (DriverDescriptor driverDescriptor : providerDescriptor.getEnabledDrivers()) {
                supportedDataBases.add(driverDescriptor);
            }
        }
        Collections.sort(supportedDataBases, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        return supportedDataBases;
    }

    private boolean isRequireToDownload(DriverDescriptor driver) {
        return driver.getDriverLibraries().stream().map(DBPDriverLibrary::getLocalFile).filter(Objects::nonNull).map(path -> path.toAbsolutePath().toString()).findAny().isEmpty();
    }

    private boolean isExtendedInPro(DriverDescriptor driver) {
        return !driver.getDriverReplacementsInfo().isEmpty();
    }
}

