/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.internal;

import java.lang.reflect.Executable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

public final class CompletionStageUtil {
    private static final Flow.Subscription NO_OP_SUBSCRIPTION;
    public static final CompletableFuture<Void> VOID_COMPLETED_FUTURE;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;

    private CompletionStageUtil() {
    }

    public static void acceptCompletion(CompletionHandler handler) {
        try {
            handler.handle();
        }
        catch (Exception unhandledException) {
            throw new CompletionException(unhandledException);
        }
    }

    public static <T> T handleCompletion(T result, Throwable throwable, CompletionHandler handler) {
        CompletionStageUtil.acceptCompletion(handler);
        if (throwable == null) {
            return result;
        }
        if (throwable instanceof CompletionException) {
            throw (CompletionException)throwable;
        }
        throw new CompletionException(throwable);
    }

    public static <T> BiFunction<T, Throwable, T> completionHandler(CompletionHandler handler) {
        return (r2, e2) -> CompletionStageUtil.handleCompletion(r2, e2, handler);
    }

    public static <T, U> U handleNormalCompletion(T result, NormalCompletionHandler<T, U> handler) {
        try {
            return handler.handle(result);
        }
        catch (Exception unhandledException) {
            throw new CompletionException(unhandledException);
        }
    }

    public static <T, U> U handleNormalCompletion(T result, Throwable throwable, NormalCompletionHandler<T, U> handler) {
        if (throwable == null) {
            return CompletionStageUtil.handleNormalCompletion(result, handler);
        }
        if (throwable instanceof CompletionException) {
            throw (CompletionException)throwable;
        }
        throw new CompletionException(throwable);
    }

    public static <T, U> Function<T, U> normalCompletionHandler(NormalCompletionHandler<T, U> handler) {
        return r2 -> CompletionStageUtil.handleNormalCompletion(r2, handler);
    }

    public static <E extends Throwable, T> T handleExceptionalCompletion(Throwable throwable, Class<E> handledType, ExceptionalCompletionHandler<? super E, ? extends T> handler) {
        if (throwable == null) {
            return null;
        }
        Throwable unwrappedThrowable = CompletionStageUtil.unwrapCompletionException(throwable);
        if (handledType.isInstance(unwrappedThrowable)) {
            try {
                return handler.handle(unwrappedThrowable);
            }
            catch (Exception unhandledException) {
                throw new CompletionException(unhandledException);
            }
        }
        throw new CompletionException(unwrappedThrowable);
    }

    public static <E extends Throwable, T> Function<Throwable, T> exceptionalCompletionHandler(Class<E> handledType, ExceptionalCompletionHandler<? super E, T> handler) {
        return e2 -> CompletionStageUtil.handleExceptionalCompletion(e2, handledType, handler);
    }

    public static <T, E extends Throwable, U> U handleCompletion(T result, NormalCompletionHandler<? super T, U> normalHandler, Throwable throwable, Class<E> handledErrorType, ExceptionalCompletionHandler<? super E, ? extends U> errorHandler) {
        return throwable == null ? CompletionStageUtil.handleNormalCompletion(result, normalHandler) : CompletionStageUtil.handleExceptionalCompletion(throwable, handledErrorType, errorHandler);
    }

    public static <T, E extends Throwable, U> BiFunction<T, Throwable, U> completionHandler(NormalCompletionHandler<T, U> normalHandler, Class<E> handledErrorType, ExceptionalCompletionHandler<? super E, U> errorHandler) {
        return (t2, e2) -> CompletionStageUtil.handleCompletion(t2, normalHandler, e2, handledErrorType, errorHandler);
    }

    public static Throwable unwrapCompletionException(Throwable throwable) {
        if (throwable instanceof CompletionException) {
            return throwable.getCause();
        }
        return throwable;
    }

    public static <T> CompletionStage<T> completedStage(T value) {
        return CompletableFuture.completedStage(value);
    }

    public static <T> CompletionStage<T> failedStage(Throwable failure) {
        return CompletableFuture.failedStage(failure);
    }

    public static Flow.Publisher<Void> newNoItemPublisher(CompletionStage<Void> itemStage, Executor publishingExecutor) {
        return CompletionStageUtil.newBatchItemPublisher(itemStage, nil -> NoItemIterator.INSTANCE, publishingExecutor);
    }

    public static <T> Flow.Publisher<T> newSingleItemPublisher(CompletionStage<T> itemStage, Executor publishingExecutor) {
        return CompletionStageUtil.newBatchItemPublisher(itemStage, x$0 -> new SingleItemIterator<Object>(x$0), publishingExecutor);
    }

    public static <T, U> Flow.Publisher<U> newBatchItemPublisher(CompletionStage<T> batchItemStage, Function<T, Iterator<U>> iteratorFunction, Executor publishingExecutor) {
        return new BatchItemPublisher<T, U>(batchItemStage, iteratorFunction, publishingExecutor);
    }

    public static <T> CompletionStage<T> subscribeForSingleItem(Flow.Publisher<T> publisher) {
        final CompletableFuture nextSignalFuture = new CompletableFuture();
        publisher.subscribe(new Flow.Subscriber<T>(){
            Flow.Subscription subscription;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                this.subscription.request(1L);
            }

            @Override
            public void onNext(T nextItem) {
                this.subscription.cancel();
                nextSignalFuture.complete(nextItem);
            }

            @Override
            public void onComplete() {
                nextSignalFuture.complete(null);
            }

            @Override
            public void onError(Throwable error) {
                nextSignalFuture.completeExceptionally(error);
            }

            static {
                try {
                    $$$methodRef$$$4 = 2.class.getDeclaredConstructor(CompletableFuture.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$3 = 2.class.getDeclaredMethod("onError", Throwable.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$2 = 2.class.getDeclaredMethod("onComplete", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 2.class.getDeclaredMethod("onNext", Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("onSubscribe", Flow.Subscription.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        return nextSignalFuture;
    }

    public static void callOnComplete(CompletionStage<Void> completionStage, Consumer<Throwable> callback) {
        CompletionStageUtil.callOnComplete(completionStage, (T nil, Throwable error) -> callback.accept((Throwable)error));
    }

    public static <T> void callOnComplete(CompletionStage<T> completionStage, BiConsumer<T, Throwable> callback) {
        CompletableFuture<T> future = completionStage.toCompletableFuture();
        if (future.isDone() && !future.isCompletedExceptionally()) {
            callback.accept(future.join(), null);
        } else {
            future.whenComplete((BiConsumer)callback);
        }
    }

    public static <T extends Throwable> T suppress(T throwable, Throwable suppressed) {
        if (suppressed != null) {
            throwable.addSuppressed(suppressed);
        }
        return throwable;
    }

    static {
        try {
            $$$methodRef$$$27 = CompletionStageUtil.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = CompletionStageUtil.class.getDeclaredMethod("lambda$completionHandler$0", CompletionHandler.class, Object.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = CompletionStageUtil.class.getDeclaredMethod("lambda$normalCompletionHandler$1", NormalCompletionHandler.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = CompletionStageUtil.class.getDeclaredMethod("lambda$exceptionalCompletionHandler$2", Class.class, ExceptionalCompletionHandler.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = CompletionStageUtil.class.getDeclaredMethod("lambda$completionHandler$3", NormalCompletionHandler.class, Class.class, ExceptionalCompletionHandler.class, Object.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = CompletionStageUtil.class.getDeclaredMethod("lambda$newNoItemPublisher$4", Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = CompletionStageUtil.class.getDeclaredMethod("lambda$newSingleItemPublisher$5", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = CompletionStageUtil.class.getDeclaredMethod("lambda$callOnComplete$6", Consumer.class, Void.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = CompletionStageUtil.class.getDeclaredMethod("suppress", Throwable.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = CompletionStageUtil.class.getDeclaredMethod("callOnComplete", CompletionStage.class, BiConsumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = CompletionStageUtil.class.getDeclaredMethod("callOnComplete", CompletionStage.class, Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = CompletionStageUtil.class.getDeclaredMethod("subscribeForSingleItem", Flow.Publisher.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = CompletionStageUtil.class.getDeclaredMethod("newBatchItemPublisher", CompletionStage.class, Function.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = CompletionStageUtil.class.getDeclaredMethod("newSingleItemPublisher", CompletionStage.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = CompletionStageUtil.class.getDeclaredMethod("newNoItemPublisher", CompletionStage.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = CompletionStageUtil.class.getDeclaredMethod("failedStage", Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = CompletionStageUtil.class.getDeclaredMethod("completedStage", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = CompletionStageUtil.class.getDeclaredMethod("unwrapCompletionException", Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = CompletionStageUtil.class.getDeclaredMethod("completionHandler", NormalCompletionHandler.class, Class.class, ExceptionalCompletionHandler.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = CompletionStageUtil.class.getDeclaredMethod("handleCompletion", Object.class, NormalCompletionHandler.class, Throwable.class, Class.class, ExceptionalCompletionHandler.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = CompletionStageUtil.class.getDeclaredMethod("exceptionalCompletionHandler", Class.class, ExceptionalCompletionHandler.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = CompletionStageUtil.class.getDeclaredMethod("handleExceptionalCompletion", Throwable.class, Class.class, ExceptionalCompletionHandler.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = CompletionStageUtil.class.getDeclaredMethod("normalCompletionHandler", NormalCompletionHandler.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = CompletionStageUtil.class.getDeclaredMethod("handleNormalCompletion", Object.class, Throwable.class, NormalCompletionHandler.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = CompletionStageUtil.class.getDeclaredMethod("handleNormalCompletion", Object.class, NormalCompletionHandler.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = CompletionStageUtil.class.getDeclaredMethod("completionHandler", CompletionHandler.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = CompletionStageUtil.class.getDeclaredMethod("handleCompletion", Object.class, Throwable.class, CompletionHandler.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = CompletionStageUtil.class.getDeclaredMethod("acceptCompletion", CompletionHandler.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        NO_OP_SUBSCRIPTION = new Flow.Subscription(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            public void request(long n2) {
            }

            @Override
            public void cancel() {
            }

            static {
                try {
                    $$$methodRef$$$2 = 1.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredMethod("cancel", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("request", Long.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        };
        VOID_COMPLETED_FUTURE = CompletableFuture.completedFuture(null);
    }

    private static class IteratorSubscription<T>
    implements Flow.Subscription {
        private final Flow.Subscriber<? super T> subscriber;
        private final Iterator<T> itemIterator;
        private final Executor executor;
        private final Monitor signalMonitor = Monitor.newInstance();
        private final AtomicLong demand = new AtomicLong(0L);
        private final Consumer<IteratorSubscription> onCancel;
        private volatile boolean isCancelled = false;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;

        private IteratorSubscription(Flow.Subscriber<? super T> subscriber, Iterator<T> itemIterator, Executor executor, Consumer<IteratorSubscription> onCancel) {
            this.subscriber = subscriber;
            this.itemIterator = itemIterator;
            this.executor = executor;
            this.onCancel = onCancel;
        }

        @Override
        public void request(long n2) {
            if (this.isCancelled) {
                return;
            }
            if (n2 < 1L) {
                this.emitError(new IllegalArgumentException("Received a negative subscription request. Argument to request(long) was: " + n2));
            } else {
                boolean demandIncreasedFromZero;
                boolean bl = demandIncreasedFromZero = 0L == this.demand.getAndUpdate(existingDemand -> {
                    long newDemand = existingDemand + n2;
                    return newDemand > 0L ? newDemand : Long.MAX_VALUE;
                });
                if (demandIncreasedFromZero) {
                    this.executor.execute(this::emitItems);
                }
            }
        }

        @Override
        public void cancel() {
            this.isCancelled = true;
            this.onCancel.accept(this);
        }

        public boolean equals(Object object) {
            return object instanceof IteratorSubscription && ((IteratorSubscription)object).subscriber.equals(this.subscriber);
        }

        public int hashCode() {
            return this.subscriber.hashCode();
        }

        private final void emitItems() {
            long unfilledDemand = this.demand.get();
            while (unfilledDemand > 0L) {
                int i2 = 0;
                while ((long)i2 < unfilledDemand && this.itemIterator.hasNext()) {
                    this.emitItem(this.itemIterator.next());
                    ++i2;
                }
                if (!this.itemIterator.hasNext()) {
                    this.emitComplete();
                    return;
                }
                long itemsEmitted = unfilledDemand;
                unfilledDemand = this.demand.updateAndGet(existingDemand -> {
                    if (existingDemand == Long.MAX_VALUE) {
                        return Long.MAX_VALUE;
                    }
                    return existingDemand - itemsEmitted;
                });
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void emitItem(T t2) {
            boolean bl = (0L & TraceControllerImpl.feature) != 0L;
            try (Monitor.CloseableLock lock = this.signalMonitor.acquireCloseableLock();){
                if (this.isCancelled) {
                    return;
                }
                try {
                    void item;
                    this.subscriber.onNext(item);
                }
                catch (Throwable onNextFailure) {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$5, Level.FINEST, IteratorSubscription.class, $$$methodRef$$$5, "Subscriber.onNext(Object) threw an exception", onNextFailure);
                    }
                    this.cancel();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void emitError(Throwable throwable) {
            boolean bl = (0L & TraceControllerImpl.feature) != 0L;
            try (Monitor.CloseableLock lock = this.signalMonitor.acquireCloseableLock();){
                if (this.isCancelled) {
                    return;
                }
                this.cancel();
                try {
                    void error;
                    this.subscriber.onError((Throwable)error);
                }
                catch (Throwable onErrorFailure) {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$6, Level.FINEST, IteratorSubscription.class, $$$methodRef$$$6, "Subscriber.onError(Throwable) threw an exception", onErrorFailure);
                    }
                }
            }
        }

        private final void emitComplete() {
            boolean bl = (0L & TraceControllerImpl.feature) != 0L;
            try (Monitor.CloseableLock lock = this.signalMonitor.acquireCloseableLock();){
                if (this.isCancelled) {
                    return;
                }
                this.cancel();
                try {
                    this.subscriber.onComplete();
                }
                catch (Throwable onCompleteFailure) {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$7, Level.FINEST, IteratorSubscription.class, $$$methodRef$$$7, "Subscriber.onComplete() threw an exception", onCompleteFailure);
                    }
                }
            }
        }

        static {
            try {
                $$$methodRef$$$10 = IteratorSubscription.class.getDeclaredConstructor(Flow.Subscriber.class, Iterator.class, Executor.class, Consumer.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$9 = IteratorSubscription.class.getDeclaredMethod("lambda$request$0", Long.TYPE, Long.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$8 = IteratorSubscription.class.getDeclaredMethod("lambda$emitItems$1", Long.TYPE, Long.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = IteratorSubscription.class.getDeclaredMethod("emitComplete", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = IteratorSubscription.class.getDeclaredMethod("emitError", Throwable.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = IteratorSubscription.class.getDeclaredMethod("emitItem", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = IteratorSubscription.class.getDeclaredMethod("emitItems", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = IteratorSubscription.class.getDeclaredMethod("hashCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = IteratorSubscription.class.getDeclaredMethod("equals", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = IteratorSubscription.class.getDeclaredMethod("cancel", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = IteratorSubscription.class.getDeclaredMethod("request", Long.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    private static final class BatchItemPublisher<U, T>
    implements Flow.Publisher<T> {
        private final CompletionStage<U> batchItemStage;
        private final Function<U, Iterator<T>> iteratorFunction;
        private final Executor executor;
        private final CopyOnWriteArraySet<IteratorSubscription> subscriptions = new CopyOnWriteArraySet();
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;

        private BatchItemPublisher(CompletionStage<U> batchItemStage, Function<U, Iterator<T>> iteratorFunction, Executor executor) {
            this.batchItemStage = batchItemStage;
            this.iteratorFunction = iteratorFunction;
            this.executor = executor;
        }

        @Override
        public void subscribe(Flow.Subscriber<? super T> subscriber) {
            Objects.requireNonNull(subscriber);
            try {
                this.executor.execute(() -> CompletionStageUtil.callOnComplete(this.batchItemStage, (batchItem, failure) -> {
                    if (failure != null) {
                        this.subscribeToFailedBatch(subscriber, (Throwable)failure);
                    } else {
                        this.subscribeToBatch(subscriber, batchItem);
                    }
                }));
            }
            catch (Throwable throwable) {
                this.subscribeToFailedBatch(subscriber, throwable);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void subscribeToBatch(Flow.Subscriber<? super T> subscriber, U u2) {
            void subscriber2;
            void batchItem;
            boolean bl = (0L & TraceControllerImpl.feature) != 0L;
            Iterator<T> itemIterator = this.iteratorFunction.apply(batchItem);
            IteratorSubscription<T> newSubscription = new IteratorSubscription<T>(subscriber2, itemIterator, this.executor, this.subscriptions::remove);
            if (!this.subscriptions.add(newSubscription)) {
                this.subscriptions.stream().filter(newSubscription::equals).findFirst().ifPresent(subscription -> subscription.emitError(new IllegalStateException("Subscriber argument to subscribe(Subscriber) is already subscribed")));
            } else {
                try (Monitor.CloseableLock lock = newSubscription.signalMonitor.acquireCloseableLock();){
                    subscriber2.onSubscribe(newSubscription);
                    if (batchItem == null) {
                        newSubscription.emitComplete();
                    }
                }
                catch (Throwable onSubscribeFailure) {
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$1, Level.FINEST, BatchItemPublisher.class, $$$methodRef$$$1, "Subscriber.onSubscribe() threw an exception", onSubscribeFailure);
                    }
                    newSubscription.cancel();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void subscribeToFailedBatch(Flow.Subscriber<? super T> subscriber, Throwable throwable) {
            block2: {
                boolean bl = (0L & TraceControllerImpl.feature) != 0L;
                try {
                    void failure;
                    void subscriber2;
                    subscriber2.onSubscribe(NO_OP_SUBSCRIPTION);
                    subscriber2.onError(CompletionStageUtil.unwrapCompletionException((Throwable)failure));
                }
                catch (Throwable subscriberFailure) {
                    if (!bl) break block2;
                    OracleLog.log($$$loggerRef$$$2, Level.FINEST, BatchItemPublisher.class, $$$methodRef$$$2, "Subscriber threw an exception", subscriberFailure);
                }
            }
        }

        static {
            try {
                $$$methodRef$$$6 = BatchItemPublisher.class.getDeclaredConstructor(CompletionStage.class, Function.class, Executor.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = BatchItemPublisher.class.getDeclaredMethod("lambda$subscribe$0", Flow.Subscriber.class, Object.class, Throwable.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = BatchItemPublisher.class.getDeclaredMethod("lambda$subscribe$1", Flow.Subscriber.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = BatchItemPublisher.class.getDeclaredMethod("lambda$subscribeToBatch$2", IteratorSubscription.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = BatchItemPublisher.class.getDeclaredMethod("subscribeToFailedBatch", Flow.Subscriber.class, Throwable.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = BatchItemPublisher.class.getDeclaredMethod("subscribeToBatch", Flow.Subscriber.class, Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = BatchItemPublisher.class.getDeclaredMethod("subscribe", Flow.Subscriber.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    private static final class SingleItemIterator<T>
    implements Iterator<T> {
        private final T item;
        boolean hasNext = true;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        private SingleItemIterator(T item) {
            this.item = item;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public T next() {
            this.hasNext = false;
            return this.item;
        }

        static {
            try {
                $$$methodRef$$$2 = SingleItemIterator.class.getDeclaredConstructor(Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = SingleItemIterator.class.getDeclaredMethod("next", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = SingleItemIterator.class.getDeclaredMethod("hasNext", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    private static final class NoItemIterator
    implements Iterator<Void> {
        private static final NoItemIterator INSTANCE;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        private NoItemIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Void next() {
            throw new NoSuchElementException();
        }

        static {
            try {
                $$$methodRef$$$3 = NoItemIterator.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = NoItemIterator.class.getDeclaredMethod("next", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = NoItemIterator.class.getDeclaredMethod("next", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = NoItemIterator.class.getDeclaredMethod("hasNext", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            INSTANCE = new NoItemIterator();
        }
    }

    @FunctionalInterface
    public static interface ExceptionalCompletionHandler<E extends Throwable, T>
    extends Function<E, T> {
        public T handle(E var1) throws Exception;

        @Override
        default public T apply(E input) {
            try {
                return this.handle(input);
            }
            catch (Exception exception) {
                throw new CompletionException(exception);
            }
        }
    }

    @FunctionalInterface
    public static interface NormalCompletionHandler<T, U>
    extends Function<T, U> {
        public U handle(T var1) throws Exception;

        @Override
        default public U apply(T input) {
            try {
                return this.handle(input);
            }
            catch (Exception exception) {
                throw new CompletionException(exception);
            }
        }
    }

    @FunctionalInterface
    public static interface CompletionHandler
    extends Runnable {
        public void handle() throws Exception;

        @Override
        default public void run() {
            try {
                this.handle();
            }
            catch (Exception exception) {
                throw new CompletionException(exception);
            }
        }
    }
}

