/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type.slots;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.BuiltinSlotWrapperSignature;
import com.oracle.graal.python.builtins.objects.type.slots.NodeFactoryUtils;
import com.oracle.graal.python.builtins.objects.type.slots.Slot2Builtin;
import com.oracle.graal.python.builtins.objects.type.slots.SlotWrapperDocstrings;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotHashFun;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.function.BuiltinFunctionRootNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.TruffleWeakReference;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class TpSlot {
    public static Object toNative(TpSlots.TpSlotMeta slotMeta, TpSlot slot, Object defaultValue) {
        if (slot == null) {
            return defaultValue;
        }
        if (slot instanceof TpSlotNative) {
            TpSlotNative nativeSlot = (TpSlotNative)slot;
            return nativeSlot.getCallable();
        }
        if (slot instanceof TpSlotManaged) {
            TpSlotManaged managedSlot = (TpSlotManaged)slot;
            return TpSlot.getNativeWrapper(slotMeta, managedSlot);
        }
        throw CompilerDirectives.shouldNotReachHere((String)"TpSlotWrapper should wrap only managed slots. Native slots should go directly to native unwrapped.");
    }

    private static Object getNativeWrapper(TpSlots.TpSlotMeta slotMeta, TpSlotManaged slot) {
        if (slot == TpSlotHashFun.HASH_NOT_IMPLEMENTED) {
            return CApiContext.getNativeSymbol(null, NativeCAPISymbol.FUN_PYOBJECT_HASH_NOT_IMPLEMENTED);
        }
        if (slot == TpSlotIterNext.NEXT_NOT_IMPLEMENTED) {
            return CApiContext.getNativeSymbol(null, NativeCAPISymbol.FUN_PY_OBJECT_NEXT_NOT_IMPLEMENTED);
        }
        assert (PythonContext.get(null).ownsGil());
        if (slot.slotWrapper == null) {
            slot.slotWrapper = slotMeta.createNativeWrapper(slot);
        }
        return slot.slotWrapper;
    }

    public static int getBuiltinsCallTargetsCount() {
        TpSlotBuiltinCallTargetRegistry.countRead = true;
        return TpSlotBuiltinCallTargetRegistry.globalIndex.get();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class TpSlotNative
    extends TpSlot {
        final Object callable;

        public TpSlotNative(Object callable) {
            this.callable = callable;
        }

        public static TpSlotNative createCExtSlot(Object callable) {
            return new TpSlotCExtNative(callable);
        }

        public final boolean isSameCallable(TpSlotNative other, InteropLibrary interop) {
            if (this == other || this.callable == other.callable) {
                return true;
            }
            interop.toNative(this.callable);
            interop.toNative(other.callable);
            try {
                return interop.asPointer(this.callable) == interop.asPointer(other.callable);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }

        public final Object getCallable() {
            return this.callable;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class TpSlotManaged
    extends TpSlot {
        private Object slotWrapper;
    }

    static abstract class TpSlotBuiltinCallTargetRegistry {
        private static final AtomicInteger globalIndex = new AtomicInteger();
        private static boolean countRead = false;

        static int getNextCallTargetIndex() {
            assert (!countRead) : "Some builtin is initialized after the array with call targets was created, make sure that static initializers of all builtin slots run before context initialization and that all call target indexes are initialized when the static initializers are run.";
            return globalIndex.getAndIncrement();
        }

        private TpSlotBuiltinCallTargetRegistry() {
        }
    }

    public static abstract class TpSlotSimpleBuiltinBase<T extends PythonBuiltinBaseNode>
    extends TpSlotBuiltinBase<T> {
        protected TpSlotSimpleBuiltinBase(NodeFactory<T> nodeFactory, BuiltinSlotWrapperSignature signature, ExternalFunctionNodes.PExternalFunctionWrapper wrapper) {
            super(nodeFactory, signature, wrapper);
            assert (this.getSlotSignatureAnnotation() == null);
        }

        @Override
        public void initialize(PythonLanguage language) {
        }
    }

    public static abstract class TpSlotBuiltinBase<T extends PythonBuiltinBaseNode>
    extends TpSlotBuiltin<T> {
        private final BuiltinSlotWrapperSignature signature;
        private final ExternalFunctionNodes.PExternalFunctionWrapper wrapper;

        protected TpSlotBuiltinBase(NodeFactory<T> nodeFactory, BuiltinSlotWrapperSignature signature, ExternalFunctionNodes.PExternalFunctionWrapper wrapper) {
            super(nodeFactory);
            this.signature = signature;
            this.wrapper = wrapper;
        }

        @Override
        public PBuiltinFunction createBuiltin(Python3Core core, Object type, TruffleString tsName, ExternalFunctionNodes.PExternalFunctionWrapper wrapper) {
            if (wrapper != this.wrapper) {
                return null;
            }
            return this.createBuiltin(core, type, tsName, this.signature, wrapper, this.getNodeFactory());
        }
    }

    public static final class TpSlotPythonSingle
    extends TpSlotPython {
        private final TruffleWeakReference<Object> callable;
        private final TruffleWeakReference<Object> type;
        private final TruffleString name;

        public TpSlotPythonSingle(Object callable, Object type, TruffleString name) {
            this(callable, (TruffleWeakReference<Object>)new TruffleWeakReference(type), name);
        }

        private TpSlotPythonSingle(Object callable, TruffleWeakReference<Object> type, TruffleString name) {
            assert (callable != null);
            this.callable = new TruffleWeakReference(callable);
            this.type = type;
            this.name = name;
        }

        @Override
        public TpSlotPython forNewType(Object klass) {
            Object newCallable = LookupAttributeInMRONode.Dynamic.getUncached().execute(klass, this.name);
            return newCallable == this.callable.get() ? this : new TpSlotPythonSingle(newCallable, this.type, this.name);
        }

        public Object getCallable() {
            return this.safeGet(this.callable);
        }

        public Object getType() {
            return this.safeGet(this.type);
        }
    }

    public static abstract class TpSlotBuiltin<T extends PythonBuiltinBaseNode>
    extends TpSlotManaged {
        private final NodeFactory<T> nodeFactory;

        protected TpSlotBuiltin(NodeFactory<T> nodeFactory) {
            assert (nodeFactory != null);
            this.nodeFactory = nodeFactory;
        }

        protected final T createNode() {
            return (T)((Object)((PythonBuiltinBaseNode)((Object)this.nodeFactory.createNode(new Object[0]))));
        }

        protected final Class<? extends T> getNodeClass() {
            return this.nodeFactory.getNodeClass();
        }

        protected final NodeFactory<T> getNodeFactory() {
            return this.nodeFactory;
        }

        final Slot.SlotSignature getSlotSignatureAnnotation() {
            return this.nodeFactory.getNodeClass().getAnnotation(Slot.SlotSignature.class);
        }

        public abstract void initialize(PythonLanguage var1);

        public abstract PythonObject createBuiltin(Python3Core var1, Object var2, TruffleString var3, ExternalFunctionNodes.PExternalFunctionWrapper var4);

        final PBuiltinFunction createBuiltin(Python3Core core, Object type, TruffleString tsName, BuiltinSlotWrapperSignature signature, ExternalFunctionNodes.PExternalFunctionWrapper wrapper, NodeFactory<? extends PythonBuiltinBaseNode> factory) {
            PythonBuiltinClassType bt;
            String name = tsName.toJavaStringUncached();
            Slot.SlotSignature slotSignature = factory.getNodeClass().getAnnotation(Slot.SlotSignature.class);
            Slot2Builtin builtin = new Slot2Builtin(slotSignature, name, signature);
            Class<?> nodeClass = NodeFactoryUtils.NodeFactoryBase.getWrappedNodeClass(factory);
            TpSlotBuiltin.validateSlotNode(factory, nodeClass, slotSignature);
            PythonBuiltinClassType builtinType = type instanceof PythonBuiltinClassType ? (bt = (PythonBuiltinClassType)((Object)type)) : null;
            RootCallTarget callTarget = core.getLanguage().createCachedCallTarget(l -> new BuiltinFunctionRootNode((PythonLanguage)((Object)l), builtin, factory, true, builtinType), factory.getNodeClass(), nodeClass, builtinType, name);
            PBuiltinFunction function = PFactory.createWrapperDescriptor(core.getLanguage(), tsName, type, PythonBuiltins.numDefaults(builtin), 0, callTarget, this, wrapper);
            function.setAttribute(SpecialAttributeNames.T___DOC__, SlotWrapperDocstrings.getDocstring(name));
            return function;
        }

        static RootCallTarget createSlotCallTarget(PythonLanguage language, BuiltinSlotWrapperSignature signature, NodeFactory<? extends PythonBuiltinBaseNode> factory, String name) {
            Slot.SlotSignature slotSignature = factory.getNodeClass().getAnnotation(Slot.SlotSignature.class);
            Slot2Builtin builtin = new Slot2Builtin(slotSignature, name, signature);
            Class<?> nodeClass = NodeFactoryUtils.NodeFactoryBase.getWrappedNodeClass(factory);
            TpSlotBuiltin.validateSlotNode(factory, nodeClass, slotSignature);
            return language.createCachedCallTarget(l -> new BuiltinFunctionRootNode((PythonLanguage)((Object)l), builtin, factory, true), factory.getNodeClass(), nodeClass, name);
        }

        private static void validateSlotNode(NodeFactory<? extends PythonBuiltinBaseNode> factory, Class<?> nodeClass, Slot.SlotSignature slotSignature) {
            assert (nodeClass == factory.getNodeClass() || slotSignature == null) : "@SlotSignature cannot be used for builtin slot nodes that are wrapped into multiple builtin magic methods";
        }

        public static boolean isSlotFactory(NodeFactory<?> factory) {
            return ((Slot[])factory.getNodeClass().getAnnotationsByType(Slot.class)).length > 0 || NodeFactoryUtils.NodeFactoryBase.class.isAssignableFrom(factory.getClass());
        }
    }

    public static final class TpSlotCExtNative
    extends TpSlotNative {
        public TpSlotCExtNative(Object callable) {
            super(callable);
        }
    }

    public static abstract class TpSlotPython
    extends TpSlotManaged {
        public abstract TpSlotPython forNewType(Object var1);

        final Object safeGet(TruffleWeakReference<Object> weakRef) {
            if (weakRef == null) {
                return null;
            }
            Object result = weakRef.get();
            assert (result != null) : "Object cached in " + this.getClass().getSimpleName() + " disappeared";
            return result;
        }

        static TruffleWeakReference<Object> asWeakRef(Object value) {
            return value == null || value == PNone.NO_VALUE ? null : new TruffleWeakReference(value);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class IsSameSlotNode
    extends Node {
        public abstract boolean execute(Node var1, TpSlot var2, TpSlot var3);

        @Specialization
        static boolean pythonWrappers(TpSlotPython a, TpSlotPython b) {
            return true;
        }

        @Specialization
        static boolean nativeSlots(TpSlotNative a, TpSlotNative b, @CachedLibrary(limit="1") InteropLibrary interop) {
            return a.isSameCallable(b, interop);
        }

        @Fallback
        static boolean others(TpSlot a, TpSlot b) {
            assert (IsSameSlotNode.hasExpectedType(a) && IsSameSlotNode.hasExpectedType(b));
            return a == b;
        }

        private static boolean hasExpectedType(TpSlot x) {
            return x instanceof TpSlotBuiltin || x instanceof TpSlotNative || x instanceof TpSlotPython;
        }
    }
}

