/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core.v3;

import com.amazon.redshift.core.Tuple;
import com.amazon.redshift.jdbc.RedshiftConnectionImpl;

public final class RedshiftMemoryUtils {
    static final double MEMORY_ESTIMATE_SCALING_FACTOR = 1.2;
    private static final int NODE_OVERHEAD_64BIT = 32;
    private static final int NODE_OVERHEAD_32BIT = 16;
    private static final int NODE_OVERHEAD = RedshiftConnectionImpl.IS_64_BIT_JVM ? 32 : 16;

    private RedshiftMemoryUtils() {
        throw new AssertionError((Object)"Utility class should not be instantiated");
    }

    public static int calculateNodeSize(Tuple row) {
        if (row == null) {
            return 0;
        }
        int rawSize = row.getTupleSize() + NODE_OVERHEAD;
        return (int)((double)rawSize * 1.2);
    }
}

