# This file has been autogenerated by the pywayland scanner

# Copyright © 2012, 2013 Intel Corporation
# Copyright © 2015, 2016 Jan Arne Petersen
# Copyright © 2017, 2018 Red Hat, Inc.
# Copyright © 2018       Purism SPC
#
# Permission to use, copy, modify, distribute, and sell this
# software and its documentation for any purpose is hereby granted
# without fee, provided that the above copyright notice appear in
# all copies and that both that copyright notice and this permission
# notice appear in supporting documentation, and that the name of
# the copyright holders not be used in advertising or publicity
# pertaining to distribution of the software without specific,
# written prior permission.  The copyright holders make no
# representations about the suitability of this software for any
# purpose.  It is provided "as is" without express or implied
# warranty.
#
# THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
# SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
# SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
# ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
# THIS SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..wayland import WlSurface


class ZwpTextInputV3(Interface):
    """Text input

    The :class:`ZwpTextInputV3` interface represents text input and input
    methods associated with a seat. It provides enter/leave events to follow
    the text input focus for a seat.

    Requests are used to enable/disable the text-input object and set state
    information like surrounding and selected text or the content type. The
    information about the entered text is sent to the text-input object via the
    preedit_string and commit_string events.

    Text is valid UTF-8 encoded, indices and lengths are in bytes. Indices must
    not point to middle bytes inside a code point: they must either point to
    the first byte of a code point or to the end of the buffer. Lengths must be
    measured between two valid indices.

    Focus moving throughout surfaces will result in the emission of
    :func:`ZwpTextInputV3.enter()` and :func:`ZwpTextInputV3.leave()` events.
    The focused surface must commit :func:`ZwpTextInputV3.enable()` and
    :func:`ZwpTextInputV3.disable()` requests as the keyboard focus moves
    across editable and non-editable elements of the UI. Those two requests are
    not expected to be paired with each other, the compositor must be able to
    handle consecutive series of the same request.

    State is sent by the state requests (set_surrounding_text, set_content_type
    and set_cursor_rectangle) and a commit request. After an enter event or
    disable request all state information is invalidated and needs to be resent
    by the client.
    """

    name = "zwp_text_input_v3"
    version = 1

    class change_cause(enum.IntEnum):
        input_method = 0
        other = 1

    class content_hint(enum.IntFlag):
        none = 0x0
        completion = 0x1
        spellcheck = 0x2
        auto_capitalization = 0x4
        lowercase = 0x8
        uppercase = 0x10
        titlecase = 0x20
        hidden_text = 0x40
        sensitive_data = 0x80
        latin = 0x100
        multiline = 0x200

    class content_purpose(enum.IntEnum):
        normal = 0
        alpha = 1
        digits = 2
        number = 3
        phone = 4
        url = 5
        email = 6
        name_ = 7
        password = 8
        pin = 9
        date = 10
        time = 11
        datetime = 12
        terminal = 13


class ZwpTextInputV3Proxy(Proxy[ZwpTextInputV3]):
    interface = ZwpTextInputV3

    @ZwpTextInputV3.request()
    def destroy(self) -> None:
        """Destroy the wp_text_input

        Destroy the wp_text_input object. Also disables all surfaces enabled
        through this wp_text_input object.
        """
        self._marshal(0)
        self._destroy()

    @ZwpTextInputV3.request()
    def enable(self) -> None:
        """Request text input to be enabled

        Requests text input on the surface previously obtained from the enter
        event.

        This request must be issued every time the focused text input changes
        to a new one, including within the current surface. Use
        :func:`ZwpTextInputV3.disable()` when there is no longer any input
        focus on the current surface.

        Clients must not enable more than one text input on the single seat and
        should disable the current text input before enabling the new one.
        Requests to enable a text input when another text input is enabled on
        the same seat must be ignored by compositor.

        This request resets all state associated with previous enable, disable,
        set_surrounding_text, set_text_change_cause, set_content_type, and
        set_cursor_rectangle requests, as well as the state associated with
        preedit_string, commit_string, and delete_surrounding_text events.

        The set_surrounding_text, set_content_type and set_cursor_rectangle
        requests must follow if the text input supports the necessary
        functionality.

        State set with this request is double-buffered. It will get applied on
        the next :func:`ZwpTextInputV3.commit()` request, and stay valid until
        the next committed enable or disable request.

        The changes must be applied by the compositor after issuing a
        :func:`ZwpTextInputV3.commit()` request.
        """
        self._marshal(1)

    @ZwpTextInputV3.request()
    def disable(self) -> None:
        """Disable text input on a surface

        Explicitly disable text input on the current surface (typically when
        there is no focus on any text entry inside the surface).

        State set with this request is double-buffered. It will get applied on
        the next :func:`ZwpTextInputV3.commit()` request.
        """
        self._marshal(2)

    @ZwpTextInputV3.request(
        Argument(ArgumentType.String),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def set_surrounding_text(self, text: str, cursor: int, anchor: int) -> None:
        """Sets the surrounding text

        Sets the surrounding plain text around the input, excluding the preedit
        text.

        The client should notify the compositor of any changes in any of the
        values carried with this request, including changes caused by handling
        incoming text-input events as well as changes caused by other
        mechanisms like keyboard typing.

        If the client is unaware of the text around the cursor, it should not
        issue this request, to signify lack of support to the compositor.

        Text is UTF-8 encoded, and should include the cursor position, the
        complete selection and additional characters before and after them.
        There is a maximum length of wayland messages, so text can not be
        longer than 4000 bytes.

        Cursor is the byte offset of the cursor within text buffer.

        Anchor is the byte offset of the selection anchor within text buffer.
        If there is no selected text, anchor is the same as cursor.

        If any preedit text is present, it is replaced with a cursor for the
        purpose of this event.

        Values set with this request are double-buffered. They will get applied
        on the next :func:`ZwpTextInputV3.commit()` request, and stay valid
        until the next committed enable or disable request.

        The initial state for affected fields is empty, meaning that the text
        input does not support sending surrounding text. If the empty values
        get applied, subsequent attempts to change them may have no effect.

        :param text:
        :type text:
            `ArgumentType.String`
        :param cursor:
        :type cursor:
            `ArgumentType.Int`
        :param anchor:
        :type anchor:
            `ArgumentType.Int`
        """
        self._marshal(3, text, cursor, anchor)

    @ZwpTextInputV3.request(
        Argument(ArgumentType.Uint),
    )
    def set_text_change_cause(self, cause: int) -> None:
        """Indicates the cause of surrounding text change

        Tells the compositor why the text surrounding the cursor changed.

        Whenever the client detects an external change in text, cursor, or
        anchor posision, it must issue this request to the compositor. This
        request is intended to give the input method a chance to update the
        preedit text in an appropriate way, e.g. by removing it when the user
        starts typing with a keyboard.

        cause describes the source of the change.

        The value set with this request is double-buffered. It must be applied
        and reset to initial at the next :func:`ZwpTextInputV3.commit()`
        request.

        The initial value of cause is input_method.

        :param cause:
        :type cause:
            `ArgumentType.Uint`
        """
        self._marshal(4, cause)

    @ZwpTextInputV3.request(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def set_content_type(self, hint: int, purpose: int) -> None:
        """Set content purpose and hint

        Sets the content purpose and content hint. While the purpose is the
        basic purpose of an input field, the hint flags allow to modify some of
        the behavior.

        Values set with this request are double-buffered. They will get applied
        on the next :func:`ZwpTextInputV3.commit()` request. Subsequent
        attempts to update them may have no effect. The values remain valid
        until the next committed enable or disable request.

        The initial value for hint is none, and the initial value for purpose
        is normal.

        :param hint:
        :type hint:
            `ArgumentType.Uint`
        :param purpose:
        :type purpose:
            `ArgumentType.Uint`
        """
        self._marshal(5, hint, purpose)

    @ZwpTextInputV3.request(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def set_cursor_rectangle(self, x: int, y: int, width: int, height: int) -> None:
        """Set cursor position

        Marks an area around the cursor as a x, y, width, height rectangle in
        surface local coordinates.

        Allows the compositor to put a window with word suggestions near the
        cursor, without obstructing the text being input.

        If the client is unaware of the position of edited text, it should not
        issue this request, to signify lack of support to the compositor.

        Values set with this request are double-buffered. They will get applied
        on the next :func:`ZwpTextInputV3.commit()` request, and stay valid
        until the next committed enable or disable request.

        The initial values describing a cursor rectangle are empty. That means
        the text input does not support describing the cursor area. If the
        empty values get applied, subsequent attempts to change them may have
        no effect.

        :param x:
        :type x:
            `ArgumentType.Int`
        :param y:
        :type y:
            `ArgumentType.Int`
        :param width:
        :type width:
            `ArgumentType.Int`
        :param height:
        :type height:
            `ArgumentType.Int`
        """
        self._marshal(6, x, y, width, height)

    @ZwpTextInputV3.request()
    def commit(self) -> None:
        """Commit state

        Atomically applies state changes recently sent to the compositor.

        The commit request establishes and updates the state of the client, and
        must be issued after any changes to apply them.

        Text input state (enabled status, content purpose, content hint,
        surrounding text and change cause, cursor rectangle) is conceptually
        double-buffered within the context of a text input, i.e. between a
        committed enable request and the following committed enable or disable
        request.

        Protocol requests modify the pending state, as opposed to the current
        state in use by the input method. A commit request atomically applies
        all pending state, replacing the current state. After commit, the new
        pending state is as documented for each related request.

        Requests are applied in the order of arrival.

        Neither current nor pending state are modified unless noted otherwise.

        The compositor must count the number of commit requests coming from
        each :class:`ZwpTextInputV3` object and use the count as the serial in
        done events.
        """
        self._marshal(7)


class ZwpTextInputV3Resource(Resource):
    interface = ZwpTextInputV3

    @ZwpTextInputV3.event(
        Argument(ArgumentType.Object, interface=WlSurface),
    )
    def enter(self, surface: WlSurface) -> None:
        """Enter event

        Notification that this seat's text-input focus is on a certain surface.

        If client has created multiple text input objects, compositor must send
        this event to all of them.

        When the seat has the keyboard capability the text-input focus follows
        the keyboard focus. This event sets the current surface for the text-
        input object.

        :param surface:
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        """
        self._post_event(0, surface)

    @ZwpTextInputV3.event(
        Argument(ArgumentType.Object, interface=WlSurface),
    )
    def leave(self, surface: WlSurface) -> None:
        """Leave event

        Notification that this seat's text-input focus is no longer on a
        certain surface. The client should reset any preedit string previously
        set.

        The leave notification clears the current surface. It is sent before
        the enter notification for the new focus. After leave event, compositor
        must ignore requests from any text input instances until next enter
        event.

        When the seat has the keyboard capability the text-input focus follows
        the keyboard focus.

        :param surface:
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        """
        self._post_event(1, surface)

    @ZwpTextInputV3.event(
        Argument(ArgumentType.String, nullable=True),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def preedit_string(self, text: str | None, cursor_begin: int, cursor_end: int) -> None:
        """Pre-edit

        Notify when a new composing text (pre-edit) should be set at the
        current cursor position. Any previously set composing text must be
        removed. Any previously existing selected text must be removed.

        The argument text contains the pre-edit string buffer.

        The parameters cursor_begin and cursor_end are counted in bytes
        relative to the beginning of the submitted text buffer. Cursor should
        be hidden when both are equal to -1.

        They could be represented by the client as a line if both values are
        the same, or as a text highlight otherwise.

        Values set with this event are double-buffered. They must be applied
        and reset to initial on the next :func:`ZwpTextInputV3.done()` event.

        The initial value of text is an empty string, and cursor_begin,
        cursor_end and cursor_hidden are all 0.

        :param text:
        :type text:
            `ArgumentType.String` or `None`
        :param cursor_begin:
        :type cursor_begin:
            `ArgumentType.Int`
        :param cursor_end:
        :type cursor_end:
            `ArgumentType.Int`
        """
        self._post_event(2, text, cursor_begin, cursor_end)

    @ZwpTextInputV3.event(
        Argument(ArgumentType.String, nullable=True),
    )
    def commit_string(self, text: str | None) -> None:
        """Text commit

        Notify when text should be inserted into the editor widget. The text to
        commit could be either just a single character after a key press or the
        result of some composing (pre-edit).

        Values set with this event are double-buffered. They must be applied
        and reset to initial on the next :func:`ZwpTextInputV3.done()` event.

        The initial value of text is an empty string.

        :param text:
        :type text:
            `ArgumentType.String` or `None`
        """
        self._post_event(3, text)

    @ZwpTextInputV3.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def delete_surrounding_text(self, before_length: int, after_length: int) -> None:
        """Delete surrounding text

        Notify when the text around the current cursor position should be
        deleted.

        Before_length and after_length are the number of bytes before and after
        the current cursor index (excluding the selection) to delete.

        If a preedit text is present, in effect before_length is counted from
        the beginning of it, and after_length from its end (see done event
        sequence).

        Values set with this event are double-buffered. They must be applied
        and reset to initial on the next :func:`ZwpTextInputV3.done()` event.

        The initial values of both before_length and after_length are 0.

        :param before_length:
            length of text before current cursor position
        :type before_length:
            `ArgumentType.Uint`
        :param after_length:
            length of text after current cursor position
        :type after_length:
            `ArgumentType.Uint`
        """
        self._post_event(4, before_length, after_length)

    @ZwpTextInputV3.event(
        Argument(ArgumentType.Uint),
    )
    def done(self, serial: int) -> None:
        """Apply changes

        Instruct the application to apply changes to state requested by the
        preedit_string, commit_string and delete_surrounding_text events. The
        state relating to these events is double-buffered, and each one
        modifies the pending state. This event replaces the current state with
        the pending state.

        The application must proceed by evaluating the changes in the following
        order:

        1. Replace existing preedit string with the cursor. 2. Delete requested
        surrounding text. 3. Insert commit string with the cursor at its end.
        4. Calculate surrounding text to send. 5. Insert new preedit text in
        cursor position. 6. Place cursor inside preedit text.

        The serial number reflects the last state of the
        :class:`ZwpTextInputV3` object known to the compositor. The value of
        the serial argument must be equal to the number of commit requests
        already issued on that object.

        When the client receives a done event with a serial different than the
        number of past commit requests, it must proceed with evaluating and
        applying the changes as normal, except it should not change the current
        state of the :class:`ZwpTextInputV3` object. All pending state requests
        (set_surrounding_text, set_content_type and set_cursor_rectangle) on
        the :class:`ZwpTextInputV3` object should be sent and committed after
        receiving a :func:`ZwpTextInputV3.done()` event with a matching serial.

        :param serial:
        :type serial:
            `ArgumentType.Uint`
        """
        self._post_event(5, serial)


class ZwpTextInputV3Global(Global):
    interface = ZwpTextInputV3


ZwpTextInputV3._gen_c()
ZwpTextInputV3.proxy_class = ZwpTextInputV3Proxy
ZwpTextInputV3.resource_class = ZwpTextInputV3Resource
ZwpTextInputV3.global_class = ZwpTextInputV3Global
