/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.ast.PyAstParameterList;
import com.jetbrains.python.psi.PsiReferenceEx;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyStringLiteralCoreUtil;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocStringParameterReference
extends PsiReferenceBase<PyStringLiteralExpression>
implements PsiReferenceEx {
    private final ReferenceType myType;

    public DocStringParameterReference(PyStringLiteralExpression element, TextRange range, ReferenceType refType) {
        super((PsiElement)element, range);
        this.myType = refType;
    }

    public PyElement resolve() {
        PyDocStringOwner owner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PyDocStringOwner.class);
        if (owner instanceof PyFunction) {
            return this.resolveParameter((PyFunction)owner);
        }
        if (owner instanceof PyClass) {
            PyClass pyClass = (PyClass)owner;
            PyFunction init2 = pyClass.findMethodByName("__init__", false, null);
            if (this.myType == ReferenceType.PARAMETER) {
                return init2 != null ? this.resolveParameter(init2) : this.resolveClassVariable(pyClass);
            }
            if (this.myType == ReferenceType.INSTANCE_VARIABLE || this.myType == ReferenceType.VARIABLE || this.myType == ReferenceType.PARAMETER_TYPE) {
                PyNamedParameter parameter;
                if (this.myType == ReferenceType.PARAMETER_TYPE && init2 != null && (parameter = this.resolveParameter(init2)) != null) {
                    return parameter;
                }
                PyTargetExpression instanceAttr = this.resolveInstanceVariable(pyClass);
                return instanceAttr != null ? instanceAttr : this.resolveClassVariable(pyClass);
            }
            if (this.myType == ReferenceType.CLASS_VARIABLE) {
                return this.resolveClassVariable(pyClass);
            }
        }
        if (owner instanceof PyFile && this.myType == ReferenceType.GLOBAL_VARIABLE) {
            return this.resolveGlobalVariable((PyFile)owner);
        }
        return null;
    }

    @Nullable
    private PyTargetExpression resolveGlobalVariable(@NotNull PyFile owner) {
        if (owner == null) {
            DocStringParameterReference.$$$reportNull$$$0(0);
        }
        return owner.findTopLevelAttribute(this.getCanonicalText());
    }

    @Nullable
    private PyTargetExpression resolveInstanceVariable(@NotNull PyClass owner) {
        if (owner == null) {
            DocStringParameterReference.$$$reportNull$$$0(1);
        }
        return owner.findInstanceAttribute(this.getCanonicalText(), true);
    }

    @Nullable
    private PyTargetExpression resolveClassVariable(@NotNull PyClass owner) {
        if (owner == null) {
            DocStringParameterReference.$$$reportNull$$$0(2);
        }
        return owner.findClassAttribute(this.getCanonicalText(), true, null);
    }

    @Nullable
    private PyNamedParameter resolveParameter(PyFunction owner) {
        PyAstParameterList parameterList = owner.getParameterList();
        PyNamedParameter resolved = parameterList.findParameterByName(this.getCanonicalText());
        if (resolved != null) {
            return resolved;
        }
        for (PyParameter parameter : parameterList.getParameters()) {
            PyNamedParameter namedParameter;
            if (!(parameter instanceof PyNamedParameter) || !(namedParameter = (PyNamedParameter)parameter).isKeywordContainer() && !namedParameter.isPositionalContainer()) continue;
            return namedParameter;
        }
        return null;
    }

    public Object @NotNull [] getVariants() {
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            DocStringParameterReference.$$$reportNull$$$0(3);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    public List<PyNamedParameter> collectParameterVariants() {
        PyDocStringOwner owner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PyDocStringOwner.class);
        if (owner instanceof PyFunction) {
            ArrayList<PyNamedParameter> result2 = new ArrayList<PyNamedParameter>();
            List<PyNamedParameter> namedParameters = ParamHelper.collectNamedParameters((PyParameterList)((PyFunction)owner).getParameterList());
            HashSet<String> usedParameters = new HashSet<String>();
            PyStringLiteralExpression expression = (PyStringLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PyStringLiteralExpression.class, (boolean)false);
            if (expression != null) {
                PsiReference[] references2;
                for (PsiReference ref : references2 = expression.getReferences()) {
                    if (!(ref instanceof DocStringParameterReference) || !((DocStringParameterReference)ref).getType().equals((Object)this.myType)) continue;
                    usedParameters.add(ref.getCanonicalText());
                }
            }
            for (PyNamedParameter param : namedParameters) {
                if (usedParameters.contains(param.getName())) continue;
                result2.add(param);
            }
            ArrayList<PyNamedParameter> arrayList = result2;
            if (arrayList == null) {
                DocStringParameterReference.$$$reportNull$$$0(4);
            }
            return arrayList;
        }
        List<PyNamedParameter> list = Collections.emptyList();
        if (list == null) {
            DocStringParameterReference.$$$reportNull$$$0(5);
        }
        return list;
    }

    public ReferenceType getType() {
        return this.myType;
    }

    @Override
    @Nullable
    public HighlightSeverity getUnresolvedHighlightSeverity(TypeEvalContext context) {
        return HighlightSeverity.WEAK_WARNING;
    }

    @Override
    @Nullable
    public String getUnresolvedDescription() {
        PyDocStringOwner owner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PyDocStringOwner.class);
        if (owner instanceof PyFunction) {
            PyFunction function = (PyFunction)owner;
            return PyPsiBundle.message("unresolved.docstring.param.reference", function.getName(), this.getCanonicalText());
        }
        return null;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        TextRange range;
        Pair<String, String> quotes;
        if (newElementName == null) {
            DocStringParameterReference.$$$reportNull$$$0(6);
        }
        if ((quotes = PyStringLiteralCoreUtil.getQuotes((range = this.getRangeInElement()).substring(((PyStringLiteralExpression)this.myElement).getText()))) != null) {
            range = TextRange.create((int)(range.getStartOffset() + ((String)quotes.first).length()), (int)(range.getEndOffset() - ((String)quotes.second).length()));
        }
        String newName = range.replace(((PyStringLiteralExpression)this.myElement).getText(), newElementName);
        ((PyStringLiteralExpression)this.myElement).replace(PyElementGenerator.getInstance(((PyStringLiteralExpression)this.myElement).getProject()).createStringLiteralAlreadyEscaped(newName));
        return this.myElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/DocStringParameterReference";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/DocStringParameterReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectParameterVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveGlobalVariable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolveInstanceVariable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveClassVariable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    public static enum ReferenceType {
        PARAMETER,
        PARAMETER_TYPE,
        KEYWORD,
        VARIABLE,
        CLASS_VARIABLE,
        INSTANCE_VARIABLE,
        GLOBAL_VARIABLE;

    }
}

