/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.sequence;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tribuo.Output;
import org.tribuo.Prediction;
import org.tribuo.evaluation.metrics.EvaluationMetric;
import org.tribuo.evaluation.metrics.MetricContext;
import org.tribuo.evaluation.metrics.MetricID;
import org.tribuo.provenance.DataProvenance;
import org.tribuo.provenance.EvaluationProvenance;
import org.tribuo.sequence.SequenceDataSource;
import org.tribuo.sequence.SequenceDataset;
import org.tribuo.sequence.SequenceEvaluation;
import org.tribuo.sequence.SequenceEvaluator;
import org.tribuo.sequence.SequenceModel;

public abstract class AbstractSequenceEvaluator<T extends Output<T>, C extends MetricContext<T>, E extends SequenceEvaluation<T>, M extends EvaluationMetric<T, C>>
implements SequenceEvaluator<T, E> {
    @Override
    public final E evaluate(SequenceModel<T> model, SequenceDataset<T> dataset) {
        List<List<Prediction<T>>> predictions = model.predict(dataset);
        return this.evaluate(model, predictions, (DataProvenance)dataset.getProvenance());
    }

    @Override
    public final E evaluate(SequenceModel<T> model, SequenceDataSource<T> datasource) {
        List<List<Prediction<T>>> predictions = model.predict(datasource);
        return this.evaluate(model, predictions, (DataProvenance)datasource.getProvenance());
    }

    @Override
    public final E evaluate(SequenceModel<T> model, List<List<Prediction<T>>> predictions, DataProvenance dataProvenance) {
        EvaluationProvenance provenance = new EvaluationProvenance(model.getProvenance(), dataProvenance);
        C context = this.createContext(model, predictions);
        Set<M> metrics = this.createMetrics(model);
        Map<MetricID<T>, Double> results = this.computeResults(context, metrics);
        return this.createEvaluation(context, results, provenance);
    }

    protected Map<MetricID<T>, Double> computeResults(C ctx, Set<? extends EvaluationMetric<T, C>> metrics) {
        HashMap<MetricID<T>, Double> results = new HashMap<MetricID<T>, Double>();
        for (EvaluationMetric<T, C> metric : metrics) {
            MetricID<T> id = metric.getID();
            double value = metric.compute(ctx);
            results.put(id, value);
        }
        return results;
    }

    protected abstract Set<M> createMetrics(SequenceModel<T> var1);

    protected abstract C createContext(SequenceModel<T> var1, List<List<Prediction<T>>> var2);

    protected abstract E createEvaluation(C var1, Map<MetricID<T>, Double> var2, EvaluationProvenance var3);
}

