/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.pluginimporter;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.pluginimporter.Installer;
import org.netbeans.modules.autoupdate.pluginimporter.PluginImporter;
import org.netbeans.modules.autoupdate.ui.api.PluginManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class ImportManager
extends Panel {
    private final File srcCluster;
    private final File dest;
    private final PluginImporter importer;
    private static ImportManager INSTANCE = null;
    private List<Boolean> checkedToInstall = Collections.emptyList();
    private List<Boolean> checkedToImport = Collections.emptyList();
    private List<UpdateElement> toInstall = Collections.emptyList();
    private List<UpdateElement> toImport = Collections.emptyList();
    private Notification currentNotification = null;
    private JButton bImport;
    private JButton bNo;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTextPane jTextPane1;
    private JLabel lBroken;
    private JLabel lDesc;
    private JLabel lToImport;
    private JLabel lToInstall;
    private JPanel pProgress;
    private JTable tToImport;
    private JTable tToInstall;
    private JTextPane tpBroken;

    public ImportManager(File src, File dest, PluginImporter importer) {
        this.srcCluster = src;
        this.dest = dest;
        this.importer = importer;
        this.initialize();
        INSTANCE = this;
    }

    public PluginImporter getPluginImporter() {
        return this.importer;
    }

    private void initialize() {
        this.toInstall = new ArrayList<UpdateElement>(this.importer.getPluginsAvailableToInstall());
        this.toInstall.sort(new Comparator<UpdateElement>(){

            @Override
            public int compare(UpdateElement o1, UpdateElement o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        this.checkedToInstall = new ArrayList<Boolean>(Collections.nCopies(this.importer.getPluginsAvailableToInstall().size(), Boolean.TRUE));
        this.toImport = new ArrayList<UpdateElement>(this.importer.getPluginsToImport());
        this.toImport.sort(new Comparator<UpdateElement>(){

            @Override
            public int compare(UpdateElement o1, UpdateElement o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        this.checkedToImport = new ArrayList<Boolean>(Collections.nCopies(this.toImport.size(), Boolean.FALSE));
        this.initComponents();
        this.tpBroken.setEnabled(!this.importer.getBrokenPlugins().isEmpty());
        this.lBroken.setEnabled(!this.importer.getBrokenPlugins().isEmpty());
        if (!this.importer.getBrokenPlugins().isEmpty()) {
            this.tpBroken.setText(this.importer.getBrokenPlugins().toString());
        }
        this.refreshUI();
    }

    public static ImportManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAvailable() {
        this.remindLater();
        String msg = NbBundle.getMessage(ImportManager.class, (String)"ImportNotifier_PluginAvailableForImport", (Object)(this.toImport.size() + this.toInstall.size()));
        String details = NbBundle.getMessage(ImportManager.class, (String)"ImportNotifier_PluginAvailableForImport_Details", (Object)this.srcCluster);
        MyAction a = new MyAction();
        ImportManager importManager = this;
        synchronized (importManager) {
            if (null != this.currentNotification) {
                this.currentNotification.clear();
            }
            Notification notification = NotificationDisplayer.getDefault().notify(msg, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/autoupdate/pluginimporter/resources/import.png", (boolean)false), details, (ActionListener)a);
            a.notification = notification;
            this.currentNotification = notification;
        }
    }

    public void attachButtons(JButton bImport, JButton bNo) {
        this.bImport = bImport;
        this.bNo = bNo;
        bImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source instanceof JButton) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            ImportManager.this.doImport();
                        }
                    });
                }
            }
        });
        this.refreshUI();
    }

    public void remindLater() {
        Preferences p = NbPreferences.forModule(Installer.class);
        p.put("import-from", this.srcCluster.toString());
    }

    public void dontRemind() {
        Preferences p = NbPreferences.forModule(Installer.class);
        try {
            p.clear();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doImport() {
        boolean res;
        block25: {
            res = true;
            if (this.checkedToImport.indexOf(Boolean.TRUE) != -1) {
                HashSet<UpdateElement> reallyToImport = new HashSet<UpdateElement>();
                for (UpdateElement el : this.toImport) {
                    if (!this.checkedToImport.get(this.toImport.indexOf(el)).booleanValue()) continue;
                    reallyToImport.add(el);
                }
                if (reallyToImport.size() > 0) {
                    ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ImportManager.class, (String)"ImportManager.Progress.Name"));
                    final JComponent progressComp = ProgressHandleFactory.createProgressComponent((ProgressHandle)handle);
                    final JLabel detailLabel = new JLabel(NbBundle.getMessage(ImportManager.class, (String)"ImportManager.Progress.Label"));
                    detailLabel.setHorizontalAlignment(2);
                    this.setProgressComponent(detailLabel, progressComp);
                    try {
                        this.importer.importPlugins(reallyToImport, this.srcCluster, this.dest, handle);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        this.toImport.clear();
                        this.checkedToImport.clear();
                    }
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){
                            final /* synthetic */ ImportManager this$0;
                            {
                                this.this$0 = this$0;
                            }

                            @Override
                            public void run() {
                                detailLabel.setVisible(false);
                                progressComp.setVisible(false);
                                this.this$0.tToImport.setModel(this.this$0.getModel(this.this$0.toImport, this.this$0.checkedToImport));
                                this.this$0.refreshUI();
                            }
                        });
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (InvocationTargetException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            try {
                this.dontRemind();
                if (this.checkedToInstall.indexOf(Boolean.TRUE) == -1) break block25;
                final OperationContainer oc = OperationContainer.createForInstall();
                for (UpdateElement el : this.toInstall) {
                    OperationContainer.OperationInfo info;
                    if (!this.checkedToInstall.get(this.toInstall.indexOf(el)).booleanValue() || (info = oc.add(el)) == null) continue;
                    for (UpdateElement required : info.getRequiredElements()) {
                        if (required.getUpdateUnit().isPending()) continue;
                        oc.add(required);
                    }
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){
                        final /* synthetic */ ImportManager this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            PluginManager.openInstallWizard((OperationContainer)oc, (boolean)true);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    this$0.toInstall.clear();
                                    this$0.checkedToInstall.clear();
                                }
                            });
                        }
                    });
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ImportManager.this.tToInstall.setModel(ImportManager.this.getModel(ImportManager.this.toInstall, ImportManager.this.checkedToInstall));
                            ImportManager.this.refreshUI();
                        }
                    });
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                throw throwable;
            }
        }
        try {
            SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return res;
    }

    private void setProgressComponent(final JLabel detail, final JComponent progressComponent) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setProgressComponentInAwt(detail, progressComponent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ ImportManager this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.setProgressComponentInAwt(detail, progressComponent);
                }
            });
        }
    }

    private void setProgressComponentInAwt(JLabel detail, JComponent progressComponent) {
        assert (this.pProgress != null);
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called in EQ.";
        progressComponent.setMinimumSize(progressComponent.getPreferredSize());
        this.pProgress.setVisible(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.pProgress.add((Component)progressComponent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.pProgress.add((Component)detail, gridBagConstraints);
        this.validate();
    }

    private TableModel getModel(final List<UpdateElement> plugins, final List<Boolean> checked) {
        return new AbstractTableModel(this){
            final /* synthetic */ ImportManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public int getRowCount() {
                return plugins.size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return checked.get(rowIndex);
                    }
                    case 1: {
                        return ((UpdateElement)plugins.get(rowIndex)).getDisplayName();
                    }
                }
                return null;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return Boolean.class;
                    }
                    case 1: {
                        return String.class;
                    }
                }
                return null;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return NbBundle.getMessage(ImportManager.class, (String)"ImportNotifier_Install");
                    }
                    case 1: {
                        return NbBundle.getMessage(ImportManager.class, (String)"ImportNotifier_Plugin");
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return true;
                    }
                    case 1: {
                        return false;
                    }
                }
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        checked.set(rowIndex, (Boolean)aValue);
                        this.this$0.refreshUI();
                        break;
                    }
                    case 1: {
                        assert (false) : "Name is not editable.";
                        break;
                    }
                }
            }
        };
    }

    private void initComponents() {
        this.jScrollPane3 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.lToInstall = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tToInstall = new JTable();
        this.lToImport = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.tToImport = new JTable();
        this.lBroken = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.tpBroken = new JTextPane();
        this.lDesc = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.pProgress = new JPanel();
        this.jScrollPane3.setViewportView(this.jTextPane1);
        this.lToInstall.setLabelFor(this.lToInstall);
        Mnemonics.setLocalizedText((JLabel)this.lToInstall, (String)NbBundle.getMessage(ImportManager.class, (String)"ImportManager.lToInstall.text"));
        this.tToInstall.setModel(this.getModel(this.toInstall, this.checkedToInstall));
        this.tToInstall.setAutoResizeMode(4);
        this.tToInstall.setOpaque(false);
        this.jScrollPane1.setViewportView(this.tToInstall);
        this.lToImport.setLabelFor(this.tToImport);
        Mnemonics.setLocalizedText((JLabel)this.lToImport, (String)NbBundle.getMessage(ImportManager.class, (String)"ImportManager.lToImport.text"));
        this.tToImport.setModel(this.getModel(this.toImport, this.checkedToImport));
        this.tToImport.setAutoResizeMode(4);
        this.tToImport.setOpaque(false);
        this.jScrollPane2.setViewportView(this.tToImport);
        this.lBroken.setLabelFor(this.tpBroken);
        Mnemonics.setLocalizedText((JLabel)this.lBroken, (String)NbBundle.getMessage(ImportManager.class, (String)"ImportManager.lBroken.text"));
        this.tpBroken.setEditable(false);
        this.tpBroken.setEnabled(false);
        this.tpBroken.setOpaque(false);
        this.jScrollPane4.setViewportView(this.tpBroken);
        this.lDesc.setFont(this.lDesc.getFont().deriveFont(this.lDesc.getFont().getStyle() | 1));
        Mnemonics.setLocalizedText((JLabel)this.lDesc, (String)NbBundle.getMessage(ImportManager.class, (String)"ImportManager.lDesc.text", (Object[])new Object[]{this.srcCluster}));
        this.pProgress.setLayout(new GridBagLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.pProgress, GroupLayout.Alignment.LEADING, -1, 688, Short.MAX_VALUE).addComponent(this.jScrollPane4, -1, 688, Short.MAX_VALUE).addComponent(this.lToImport, GroupLayout.Alignment.LEADING, -2, 688, Short.MAX_VALUE).addComponent(this.jSeparator2, GroupLayout.Alignment.LEADING, -1, 688, Short.MAX_VALUE).addComponent(this.lToInstall, GroupLayout.Alignment.LEADING).addComponent(this.lDesc, GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 688, Short.MAX_VALUE).addComponent(this.jSeparator1, GroupLayout.Alignment.LEADING, -1, 688, Short.MAX_VALUE).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -1, 688, Short.MAX_VALUE).addComponent(this.lBroken, GroupLayout.Alignment.LEADING, -1, 688, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lDesc).addGap(7, 7, 7).addComponent(this.lToInstall).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 123, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lToImport).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 158, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lBroken).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4, -1, 75, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pProgress, -2, 21, -2).addContainerGap()));
    }

    private void refreshUI() {
        this.lToImport.setEnabled(this.toImport.size() > 0);
        this.tToImport.setEnabled(this.toImport.size() > 0);
        this.lToInstall.setEnabled(this.toInstall.size() > 0);
        this.tToInstall.setEnabled(this.toInstall.size() > 0);
        TableColumn activeColumn = this.tToImport.getColumnModel().getColumn(0);
        activeColumn.setMaxWidth(this.tToImport.getTableHeader().getHeaderRect((int)0).width);
        activeColumn = this.tToInstall.getColumnModel().getColumn(0);
        activeColumn.setMaxWidth(this.tToInstall.getTableHeader().getHeaderRect((int)0).width);
        if (this.bImport != null) {
            this.bImport.setEnabled(this.checkedToInstall.indexOf(Boolean.TRUE) != -1 || this.checkedToImport.indexOf(Boolean.TRUE) != -1);
        }
    }

    private class MyAction
    extends AbstractAction {
        final JButton bRemindLaterButton = new JButton();
        final JButton bImportButton = new JButton();
        final JButton bNoButton = new JButton();
        private Notification notification;

        public MyAction() {
            Mnemonics.setLocalizedText((AbstractButton)this.bRemindLaterButton, (String)NbBundle.getMessage(ImportManager.class, (String)"ImportNotifier_bRemindLater"));
            Mnemonics.setLocalizedText((AbstractButton)this.bImportButton, (String)NbBundle.getMessage(ImportManager.class, (String)"ImportNotifier_bImport"));
            Mnemonics.setLocalizedText((AbstractButton)this.bNoButton, (String)NbBundle.getMessage(ImportManager.class, (String)"ImportNotifier_bNo"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImportManager ui = ImportManager.getInstance();
            ui.getPluginImporter().reinspect();
            ui.initialize();
            ui.attachButtons(this.bImportButton, this.bNoButton);
            DialogDescriptor dd = new DialogDescriptor((Object)ui, NbBundle.getMessage(Installer.class, (String)"Installer_DialogTitle"), true, new Object[]{this.bImportButton, this.bNoButton, this.bRemindLaterButton}, NotifyDescriptor.OK_OPTION, 0, null, null);
            dd.setClosingOptions(new Object[]{this.bImportButton, this.bNoButton, this.bRemindLaterButton});
            DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
            if (this.bImportButton.equals(dd.getValue()) || this.bNoButton.equals(dd.getValue())) {
                ui.dontRemind();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (null != MyAction.this.notification) {
                            MyAction.this.notification.clear();
                        }
                    }
                });
            } else if (this.bRemindLaterButton.equals(dd.getValue())) {
                ui.remindLater();
            }
        }
    }
}

