/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;
import org.netbeans.modules.profiler.snaptracer.impl.swing.LabelRenderer;

public final class EnhancedLabelRenderer
extends LabelRenderer {
    private static final EnhancedInsets EMPTY_INSETS = new EnhancedInsets();
    private EnhancedInsets marginInsets;
    private EnhancedInsets borderInsets;
    private Border border;
    private Color background;

    public void setMargin(Insets marginInsets) {
        this.marginInsets = marginInsets == null ? EMPTY_INSETS : new EnhancedInsets(marginInsets);
    }

    @Override
    public void setBorder(Border border) {
        this.border = border;
        this.borderInsets = border == null ? EMPTY_INSETS : new EnhancedInsets(border.getBorderInsets(this));
    }

    @Override
    public Border getBorder() {
        return this.border;
    }

    @Override
    public void setBackground(Color background) {
        this.background = background;
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    private EnhancedInsets getMarginInsets() {
        if (this.marginInsets == null) {
            this.marginInsets = EMPTY_INSETS;
        }
        return this.marginInsets;
    }

    private EnhancedInsets getBorderInsets() {
        if (this.borderInsets == null) {
            this.borderInsets = EMPTY_INSETS;
        }
        return this.borderInsets;
    }

    @Override
    protected void prePaint(Graphics g, int x, int y) {
        if (this.background != null) {
            g.setColor(this.background);
            EnhancedInsets margin = this.getMarginInsets();
            Dimension size = this.getPreferredSize();
            g.fillRect(x - margin.left, y - margin.top, size.width + margin.width(), size.height + margin.height());
        }
    }

    @Override
    protected void postPaint(Graphics g, int x, int y) {
        if (this.border != null) {
            EnhancedInsets bi = this.getBorderInsets();
            EnhancedInsets margin = this.getMarginInsets();
            Dimension size = this.getPreferredSize();
            this.border.paintBorder(this, g, x - margin.left - bi.left, y - margin.top - bi.top, size.width + margin.width() + bi.width(), size.height + margin.height() + bi.height());
        }
    }

    private static class EnhancedInsets
    extends Insets {
        public EnhancedInsets() {
            this(0, 0, 0, 0);
        }

        public EnhancedInsets(Insets insets) {
            this(insets.top, insets.left, insets.bottom, insets.right);
        }

        public EnhancedInsets(int top, int left, int bottom, int right) {
            super(top, left, bottom, right);
        }

        public int width() {
            return this.left + this.right;
        }

        public int height() {
            return this.top + this.bottom;
        }
    }
}

