/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.ModificationResultBasedFix;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

class CreateEnumConstant
extends ModificationResultBasedFix
implements Fix {
    private String name;
    private String inFQN;
    private ClasspathInfo cpInfo;
    private FileObject targetFile;
    private ElementHandle<TypeElement> target;
    private TypeMirrorHandle<TypeMirror> proposedType;

    public CreateEnumConstant(CompilationInfo info, String name, Set<Modifier> modifiers, TypeElement target, TypeMirror proposedType, FileObject targetFile) {
        this.name = name;
        this.inFQN = target.getQualifiedName().toString();
        this.cpInfo = info.getClasspathInfo();
        this.targetFile = targetFile;
        this.target = ElementHandle.create((Element)target);
        if (proposedType.getKind() == TypeKind.NULL) {
            TypeElement tel = info.getElements().getTypeElement("java.lang.Object");
            if (tel != null) {
                proposedType = tel.asType();
                this.proposedType = TypeMirrorHandle.create((TypeMirror)proposedType);
            } else {
                this.proposedType = null;
            }
        } else {
            this.proposedType = TypeMirrorHandle.create((TypeMirror)proposedType);
        }
    }

    public String getText() {
        return NbBundle.getMessage(CreateEnumConstant.class, (String)"LBL_FIX_Create_Enum_Constant", (Object)this.name, (Object)this.inFQN);
    }

    public ChangeInfo implement() throws Exception {
        ModificationResult diff = this.getModificationResult();
        return Utilities.commitAndComputeChangeInfo(this.targetFile, diff, null);
    }

    @Override
    public ModificationResult getModificationResult() throws IOException {
        JavaSource js = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[]{this.targetFile});
        return js.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy working) throws IOException {
                working.toPhase(JavaSource.Phase.RESOLVED);
                TypeElement targetType = (TypeElement)CreateEnumConstant.this.target.resolve((CompilationInfo)working);
                if (targetType == null) {
                    ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve target.");
                    return;
                }
                ClassTree targetTree = working.getTrees().getTree(targetType);
                if (targetTree == null) {
                    ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve target tree: " + String.valueOf(targetType.getQualifiedName()) + ".");
                    return;
                }
                TypeMirror proposedType = CreateEnumConstant.this.proposedType.resolve((CompilationInfo)working);
                TreeMaker make = working.getTreeMaker();
                int mods = 16384;
                ModifiersTree modds = make.Modifiers((long)mods, Collections.emptyList());
                VariableTree var = make.Variable(modds, (CharSequence)CreateEnumConstant.this.name, make.Type(proposedType), null);
                List<? extends Tree> members = targetTree.getMembers();
                ArrayList<? extends Tree> newMembers = new ArrayList<Tree>(members);
                int pos = -1;
                for (Tree tree : members) {
                    if (tree.getKind() != Tree.Kind.VARIABLE || !working.getTreeUtilities().isEnumConstant((VariableTree)tree)) continue;
                    pos = members.indexOf(tree);
                }
                newMembers.add(pos + 1, var);
                ClassTree enumm = make.Enum(targetTree.getModifiers(), (CharSequence)targetTree.getSimpleName(), targetTree.getImplementsClause(), newMembers);
                working.rewrite((Tree)targetTree, (Tree)enumm);
            }
        });
    }

    String toDebugString(CompilationInfo info) {
        return "CreateEnumConstant:" + this.name + ":" + this.target.getQualifiedName() + ":" + this.proposedType.resolve(info).toString();
    }
}

