/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.htmlui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.netbeans.api.htmlui.HTMLDialog;
import org.netbeans.modules.htmlui.Buttons;
import org.netbeans.modules.htmlui.ContextAccessor;
import org.netbeans.modules.htmlui.HtmlPair;
import org.netbeans.spi.htmlui.HTMLViewerSpi;
import org.openide.util.Lookup;

public final class HTMLDialogBase {
    private final Buttons<?, ?> buttons;
    private final HtmlPair<?, ?> view;

    private HTMLDialogBase(HtmlPair<?, ?> view, Buttons<?, ?> buttons) {
        this.buttons = buttons;
        this.view = view;
    }

    public static HTMLDialogBase create(String url, String[] resources, final Runnable onPageLoad, HTMLDialog.OnSubmit onSubmit, String[] techIds, final Class<?> component) {
        URL u;
        ClassLoader loader = onPageLoad.getClass().getClassLoader();
        try {
            u = new URL(url);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(url, ex);
        }
        class AcceptAndInit
        implements Consumer<String>,
        Callable<Lookup> {
            private Buttons<?, ?> buttons;

            AcceptAndInit() {
            }

            synchronized <A, B> Buttons<A, B> assignButtons(Buttons<A, B> b) {
                if (this.buttons != null) {
                    throw new IllegalStateException();
                }
                this.buttons = b;
                this.notifyAll();
                return b;
            }

            private Buttons<?, ?> awaitButtons() {
                assert (Thread.holdsLock(this));
                while (this.buttons == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return this.buttons;
            }

            @Override
            public synchronized void accept(String t) {
                this.awaitButtons().accept(t);
            }

            @Override
            public Lookup call() throws Exception {
                onPageLoad.run();
                this.initializeButtons();
                return null;
            }

            private synchronized void initializeButtons() {
                if (component != null) {
                    return;
                }
                this.awaitButtons().buttons();
            }
        }
        AcceptAndInit init = new AcceptAndInit();
        HTMLViewerSpi.Context c = ContextAccessor.getDefault().newContext(loader, u, resources, techIds, onSubmit, init, init, component);
        HtmlPair<?, ?> view = HtmlPair.newView(c);
        Buttons buttons = component == null ? new Buttons(view, onSubmit) : null;
        HTMLDialogBase base = new HTMLDialogBase(view, init.assignButtons(buttons));
        view.component(Void.class);
        return base;
    }

    public <C> C component(Class<C> type) {
        return this.view.component(type);
    }

    protected void onSubmit(String id) {
        this.buttons.accept(id);
    }

    public void show(HTMLDialog.OnSubmit onSubmit) {
    }

    public String showAndWait() {
        return this.buttons.obtainResult();
    }
}

