/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.packer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigesterUtils {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDigest(String alg, InputStream is) throws NoSuchAlgorithmException {
        String result;
        try {
            try {
                int numRead;
                byte[] buffer = new byte[1024];
                MessageDigest md = MessageDigest.getInstance(alg);
                do {
                    if ((numRead = is.read(buffer)) <= 0) continue;
                    md.update(buffer, 0, numRead);
                } while (numRead != -1);
                result = new String(DigesterUtils.encodeHex(md.digest()));
            }
            finally {
                is.close();
            }
        }
        catch (IOException e) {
            result = null;
        }
        return result;
    }

    public static String getSha1Digest(String content) {
        try {
            ByteArrayInputStream fis = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
            return DigesterUtils.getDigest("SHA1", fis);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static String getSha1Digest(InputStream is) {
        try {
            return DigesterUtils.getDigest("SHA1", is);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static String getSha1Digest(File file) throws IOException {
        String string;
        FileInputStream fis = new FileInputStream(file);
        try {
            string = DigesterUtils.getDigest("SHA1", fis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException | NoSuchAlgorithmException e) {
                return null;
            }
        }
        fis.close();
        return string;
    }

    public static String getMd5Digest(String content) {
        try {
            ByteArrayInputStream fis = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
            return DigesterUtils.getDigest("MD5", fis);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static String getMd5Digest(InputStream is) {
        try {
            return DigesterUtils.getDigest("MD5", is);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static String getMd5Digest(File file) throws IOException {
        String string;
        FileInputStream fis = new FileInputStream(file);
        try {
            string = DigesterUtils.getDigest("MD5", fis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fis).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException | NoSuchAlgorithmException e) {
                return null;
            }
        }
        ((InputStream)fis).close();
        return string;
    }

    public static char[] encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
        }
        return out;
    }
}

