/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.database.model.UpdateConsoleConnectionDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateConsoleConnectionRequest
extends BmcRequest<UpdateConsoleConnectionDetails> {
    private String dbNodeId;
    private String consoleConnectionId;
    private UpdateConsoleConnectionDetails updateConsoleConnectionDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getDbNodeId() {
        return this.dbNodeId;
    }

    public String getConsoleConnectionId() {
        return this.consoleConnectionId;
    }

    public UpdateConsoleConnectionDetails getUpdateConsoleConnectionDetails() {
        return this.updateConsoleConnectionDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateConsoleConnectionDetails getBody$() {
        return this.updateConsoleConnectionDetails;
    }

    public Builder toBuilder() {
        return new Builder().dbNodeId(this.dbNodeId).consoleConnectionId(this.consoleConnectionId).updateConsoleConnectionDetails(this.updateConsoleConnectionDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dbNodeId=").append(String.valueOf(this.dbNodeId));
        sb.append(",consoleConnectionId=").append(String.valueOf(this.consoleConnectionId));
        sb.append(",updateConsoleConnectionDetails=").append(String.valueOf((Object)this.updateConsoleConnectionDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateConsoleConnectionRequest)) {
            return false;
        }
        UpdateConsoleConnectionRequest other = (UpdateConsoleConnectionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dbNodeId, other.dbNodeId) && Objects.equals(this.consoleConnectionId, other.consoleConnectionId) && Objects.equals((Object)this.updateConsoleConnectionDetails, (Object)other.updateConsoleConnectionDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dbNodeId == null ? 43 : this.dbNodeId.hashCode());
        result = result * 59 + (this.consoleConnectionId == null ? 43 : this.consoleConnectionId.hashCode());
        result = result * 59 + (this.updateConsoleConnectionDetails == null ? 43 : this.updateConsoleConnectionDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateConsoleConnectionRequest, UpdateConsoleConnectionDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dbNodeId = null;
        private String consoleConnectionId = null;
        private UpdateConsoleConnectionDetails updateConsoleConnectionDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder dbNodeId(String dbNodeId) {
            this.dbNodeId = dbNodeId;
            return this;
        }

        public Builder consoleConnectionId(String consoleConnectionId) {
            this.consoleConnectionId = consoleConnectionId;
            return this;
        }

        public Builder updateConsoleConnectionDetails(UpdateConsoleConnectionDetails updateConsoleConnectionDetails) {
            this.updateConsoleConnectionDetails = updateConsoleConnectionDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateConsoleConnectionRequest o) {
            this.dbNodeId(o.getDbNodeId());
            this.consoleConnectionId(o.getConsoleConnectionId());
            this.updateConsoleConnectionDetails(o.getUpdateConsoleConnectionDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateConsoleConnectionRequest build() {
            UpdateConsoleConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateConsoleConnectionDetails body) {
            this.updateConsoleConnectionDetails(body);
            return this;
        }

        public UpdateConsoleConnectionRequest buildWithoutInvocationCallback() {
            UpdateConsoleConnectionRequest request = new UpdateConsoleConnectionRequest();
            request.dbNodeId = this.dbNodeId;
            request.consoleConnectionId = this.consoleConnectionId;
            request.updateConsoleConnectionDetails = this.updateConsoleConnectionDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

