/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.jsp;

import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.java.JavaI18nFinder;
import org.netbeans.modules.i18n.java.JavaI18nSupport;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

public class JspI18nSupport
extends JavaI18nSupport {
    public JspI18nSupport(DataObject sourceDataObject) {
        super(sourceDataObject);
    }

    @Override
    protected I18nSupport.I18nFinder createFinder() {
        return new JspI18nFinder(this.document);
    }

    @Override
    public boolean hasAdditionalCustomizer() {
        return false;
    }

    @Override
    public JPanel getAdditionalCustomizer() {
        return null;
    }

    @Override
    public void performAdditionalChanges() {
    }

    public static class JspI18nFinder
    extends JavaI18nFinder {
        protected static final int STATE_JSP = 8;
        protected static final int STATE_JSP_START_SCRIPTING = 9;
        protected static final int STATE_JSP_SCRIPTING = 10;
        protected static final int STATE_JSP_END_SCRIPTING = 11;
        private static final String[] jspStrings = new String[]{"jsp:declaration", "jsp:expression", "jsp:scriptlet"};
        private int oldJavaState;

        public JspI18nFinder(StyledDocument document) {
            super(document);
            this.state = 8;
        }

        @Override
        protected void reset() {
            super.reset();
            this.state = 8;
        }

        @Override
        protected HardCodedString handleCharacter(char character) {
            if (this.state == 8) {
                return this.handleStateJsp(character);
            }
            if (this.state == 9) {
                return this.handleStateJspStartScripting(character);
            }
            if (this.state == 10) {
                return this.handleStateJspScripting(character);
            }
            if (this.state == 11) {
                return this.handleStateJspEndScripting(character);
            }
            if (character == '%') {
                this.oldJavaState = this.state = 11;
                return null;
            }
            if (character == '<') {
                for (int i = 0; i < jspStrings.length; ++i) {
                    if (!this.isNextString("</" + jspStrings[i] + ">")) continue;
                    this.position += jspStrings[i].length() + 2;
                    this.state = 8;
                    return null;
                }
            }
            return super.handleCharacter(character);
        }

        protected HardCodedString handleStateJsp(char character) {
            if (character == '<') {
                this.state = 9;
            }
            return null;
        }

        protected HardCodedString handleStateJspStartScripting(char character) {
            if (character == '%') {
                this.state = 10;
            } else if (character == 'j') {
                for (int i = 0; i < jspStrings.length; ++i) {
                    if (!this.isNextString(jspStrings[i] + ">")) continue;
                    this.position += jspStrings[i].length();
                    this.state = 0;
                }
            } else {
                this.state = 8;
            }
            return null;
        }

        private boolean isNextString(String nextString) {
            if (this.buffer.length < this.position + nextString.length()) {
                return false;
            }
            try {
                if (nextString.equals(this.document.getText(this.position, nextString.length()))) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return false;
        }

        protected HardCodedString handleStateJspScripting(char character) {
            this.state = character == '@' || character == '-' ? 8 : 0;
            return null;
        }

        protected HardCodedString handleStateJspEndScripting(char character) {
            this.state = character == '>' ? 8 : this.oldJavaState;
            return null;
        }
    }

    public static class Factory
    extends I18nSupport.Factory {
        @Override
        public I18nSupport createI18nSupport(DataObject dataObject) {
            return new JspI18nSupport(dataObject);
        }

        @Override
        public Class getDataObjectClass() {
            try {
                return Class.forName("org.netbeans.modules.web.core.jsploader.JspDataObject", false, (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class));
            }
            catch (ClassNotFoundException cnfe) {
                return null;
            }
        }
    }
}

