/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.appsrvapi;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;

public class PortDetector {
    private static final int PORT_CHECK_TIMEOUT = 4000;

    public static boolean isSecurePort(String hostname, int port) throws IOException, ConnectException, SocketTimeoutException {
        Socket socket;
        block3: {
            socket = new Socket();
            try {
                socket.connect(new InetSocketAddress(hostname, port), 4000);
                socket.setSoTimeout(4000);
            }
            catch (SocketException ex) {
                String socksNonProxyHosts = System.getProperty("socksNonProxyHosts");
                if (socksNonProxyHosts == null || socksNonProxyHosts.indexOf("localhost") >= 0) break block3;
                String localhost = socksNonProxyHosts.length() > 0 ? "|localhost" : "localhost";
                System.setProperty("socksNonProxyHosts", socksNonProxyHosts + localhost);
                ConnectException ce = new ConnectException();
                ce.initCause(ex);
                throw ce;
            }
        }
        String testQuery = "GET / HTTP/1.0";
        PrintWriter pw = new PrintWriter(socket.getOutputStream());
        pw.println(testQuery);
        pw.println();
        pw.flush();
        InputStream is = socket.getInputStream();
        byte[] respArr = new byte[1024];
        boolean isSecure = true;
        while (is.read(respArr) != -1) {
            String resp = new String(respArr);
            if (PortDetector.checkHelper(resp)) continue;
            isSecure = false;
            break;
        }
        socket.close();
        return isSecure;
    }

    private static boolean checkHelper(String respText) {
        boolean isSecure = true;
        if (respText.startsWith("http/1.") || respText.startsWith("HTTP/1.")) {
            isSecure = false;
        } else if (respText.contains("<html")) {
            isSecure = false;
        } else if (respText.contains("</html")) {
            isSecure = false;
        } else if (respText.contains("connection: ")) {
            isSecure = false;
        }
        return isSecure;
    }

    public static void main(String[] args) throws IOException {
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        System.out.println("host:  port: " + port);
        System.out.println("isSecure: " + PortDetector.isSecurePort(host, port));
    }
}

