/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component;

import jakarta.faces.component.MethodBindingAdapterBase;
import jakarta.faces.component.StateHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.el.EvaluationException;
import jakarta.faces.el.MethodBinding;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ValueChangeEvent;
import jakarta.faces.event.ValueChangeListener;

class MethodBindingValueChangeListener
extends MethodBindingAdapterBase
implements ValueChangeListener,
StateHolder {
    private MethodBinding methodBinding = null;
    private boolean tranzient = false;

    public MethodBindingValueChangeListener() {
    }

    public MethodBindingValueChangeListener(MethodBinding methodBinding) {
        this.methodBinding = methodBinding;
    }

    public MethodBinding getWrapped() {
        return this.methodBinding;
    }

    @Override
    public void processValueChange(ValueChangeEvent actionEvent) throws AbortProcessingException {
        if (actionEvent == null) {
            throw new NullPointerException();
        }
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            this.methodBinding.invoke(context, new Object[]{actionEvent});
        }
        catch (EvaluationException ee) {
            Throwable cause = this.getExpectedCause(AbortProcessingException.class, ee);
            if (cause instanceof AbortProcessingException) {
                throw (AbortProcessingException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IllegalStateException(ee);
        }
    }

    @Override
    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object[] result = null;
        if (!this.tranzient) {
            if (this.methodBinding instanceof StateHolder) {
                Object[] stateStruct = new Object[]{((StateHolder)((Object)this.methodBinding)).saveState(context), this.methodBinding.getClass().getName()};
                result = stateStruct;
            } else {
                result = this.methodBinding;
            }
        }
        return result;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (null == state) {
            return;
        }
        if (!(state instanceof MethodBinding)) {
            Object[] stateStruct = (Object[])state;
            Object savedState = stateStruct[0];
            String className = stateStruct[1].toString();
            MethodBinding result = null;
            if (null != className) {
                Class toRestoreClass;
                try {
                    toRestoreClass = MethodBindingValueChangeListener.loadClass(className, this);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
                if (null != toRestoreClass) {
                    try {
                        result = (MethodBinding)toRestoreClass.newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new IllegalStateException(e);
                    }
                }
                if (null != result && null != savedState) {
                    ((StateHolder)((Object)result)).restoreState(context, savedState);
                }
                this.methodBinding = result;
            }
        } else {
            this.methodBinding = (MethodBinding)state;
        }
    }

    @Override
    public boolean isTransient() {
        return this.tranzient;
    }

    @Override
    public void setTransient(boolean newTransientValue) {
        this.tranzient = newTransientValue;
    }

    private static Class loadClass(String name, Object fallbackClass) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return Class.forName(name, false, loader);
    }
}

