/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;

public final class Rational
extends Number
implements Comparable<Rational> {
    private final long numerator;
    private final long denominator;
    public static final Rational ZERO = new Rational(0L, 1L);
    public static final Rational ONE = new Rational(1L, 1L);

    public Rational(long numerator, long denominator) {
        if (denominator <= 0L) {
            throw new IllegalArgumentException("Denominator must be positive!");
        }
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public long getNumerator() {
        return this.numerator;
    }

    public long getDenominator() {
        return this.denominator;
    }

    @Override
    public int compareTo(Rational that) {
        return Long.compare(this.numerator * that.denominator, this.denominator * that.numerator);
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public long longValue() {
        return this.numerator / this.denominator;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public double doubleValue() {
        return 1.0 * (double)this.numerator / (double)this.denominator;
    }

    public Rational negate() {
        return new Rational(-this.numerator, this.denominator);
    }

    public Rational add(Number value) {
        Rational that = Rational.valueOf(value);
        return new Rational(this.numerator * that.denominator + that.numerator * this.denominator, this.denominator * that.denominator);
    }

    public Rational subtract(Number value) {
        Rational that = Rational.valueOf(value);
        return this.add(that.negate());
    }

    public Rational multiply(Number value) {
        Rational that = Rational.valueOf(value);
        return new Rational(this.numerator * that.numerator, this.denominator * that.denominator);
    }

    public Rational divide(Number value) {
        return this.multiply(Rational.valueOf(value).inverse());
    }

    public Rational inverse() {
        long sign = this.numerator >= 0L ? 1L : -1L;
        return new Rational(sign * this.denominator, Math.abs(this.numerator));
    }

    public boolean lessThan(Number that) {
        return this.compareTo(Rational.valueOf(that)) < 0;
    }

    public boolean lessThanOrEqual(Number that) {
        return this.compareTo(Rational.valueOf(that)) <= 0;
    }

    public boolean greaterThan(Number that) {
        return this.compareTo(Rational.valueOf(that)) > 0;
    }

    public boolean greaterThanOrEqual(Number that) {
        return this.compareTo(Rational.valueOf(that)) >= 0;
    }

    public Rational simplify() {
        long gcd = Rational.gcd(Math.abs(this.numerator), this.denominator);
        return new Rational(this.numerator / gcd, this.denominator / gcd);
    }

    public String toString() {
        return this.toString("/");
    }

    public String toString(String delimiter) {
        if (this.denominator == 1L) {
            return Long.toString(this.numerator);
        }
        return this.numerator + delimiter + this.denominator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rational that = (Rational)o;
        return this.numerator * that.denominator == this.denominator * that.numerator;
    }

    public int hashCode() {
        return Objects.hash(this.numerator, this.denominator);
    }

    public static Rational valueOf(long value) {
        return new Rational(value, 1L);
    }

    public static Rational valueOf(double value) {
        int scale;
        BigDecimal bigDecimal = BigDecimal.valueOf(value);
        long numerator = bigDecimal.unscaledValue().longValue();
        long denominator = 1L;
        for (scale = bigDecimal.scale(); scale > 0; --scale) {
            denominator *= 10L;
        }
        while (scale < 0) {
            numerator *= 10L;
            ++scale;
        }
        return new Rational(numerator, denominator);
    }

    public static Rational valueOf(Number value) {
        if (value instanceof Rational) {
            return (Rational)value;
        }
        if (value instanceof Double || value instanceof Float) {
            return Rational.valueOf(value.doubleValue());
        }
        return Rational.valueOf(value.longValue());
    }

    public static Rational valueOf(String value) throws NumberFormatException {
        return Rational.valueOf(value, "/");
    }

    public static Rational valueOf(String value, String delimiter) throws NumberFormatException {
        String[] parts = value.split(delimiter, 2);
        try {
            long numerator = Long.parseLong(parts[0]);
            long denominator = 1L;
            if (parts.length == 2) {
                denominator = Long.parseLong(parts[1]);
            }
            return new Rational(numerator, denominator);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("For input string: \"" + value + "\"");
        }
    }

    private static long gcd(long a, long b) {
        BigInteger bigA = BigInteger.valueOf(a);
        BigInteger bigB = BigInteger.valueOf(b);
        return bigA.gcd(bigB).longValue();
    }
}

