/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class MatrixFromRowsNode extends ImplicitNode {

	public MatrixFromRowsNode(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Retrieves the input for the first row
	 *
	 * @return the input for the first row
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputA() throws Lib3MFException {
		Pointer bufferRow0 = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_matrixfromrowsnode_getinputa.invokeInt(new java.lang.Object[]{mHandle, bufferRow0}));
		Pointer valueRow0 = bufferRow0.getPointer(0);
		ImplicitPort row0 = null;
		if (valueRow0 == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Row0 was a null pointer");
		}
		row0 = mWrapper.PolymorphicFactory(valueRow0, ImplicitPort.class);
		return row0;
	}

	/**
	 * Retrieves the input for the second row
	 *
	 * @return the input for the second row
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputB() throws Lib3MFException {
		Pointer bufferRow1 = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_matrixfromrowsnode_getinputb.invokeInt(new java.lang.Object[]{mHandle, bufferRow1}));
		Pointer valueRow1 = bufferRow1.getPointer(0);
		ImplicitPort row1 = null;
		if (valueRow1 == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Row1 was a null pointer");
		}
		row1 = mWrapper.PolymorphicFactory(valueRow1, ImplicitPort.class);
		return row1;
	}

	/**
	 * Retrieves the input for the third row
	 *
	 * @return the input for the third row
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputC() throws Lib3MFException {
		Pointer bufferRow2 = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_matrixfromrowsnode_getinputc.invokeInt(new java.lang.Object[]{mHandle, bufferRow2}));
		Pointer valueRow2 = bufferRow2.getPointer(0);
		ImplicitPort row2 = null;
		if (valueRow2 == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Row2 was a null pointer");
		}
		row2 = mWrapper.PolymorphicFactory(valueRow2, ImplicitPort.class);
		return row2;
	}

	/**
	 * Retrieves the input for the fourth row
	 *
	 * @return the input for the fourth row
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputD() throws Lib3MFException {
		Pointer bufferRow3 = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_matrixfromrowsnode_getinputd.invokeInt(new java.lang.Object[]{mHandle, bufferRow3}));
		Pointer valueRow3 = bufferRow3.getPointer(0);
		ImplicitPort row3 = null;
		if (valueRow3 == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Row3 was a null pointer");
		}
		row3 = mWrapper.PolymorphicFactory(valueRow3, ImplicitPort.class);
		return row3;
	}

	/**
	 * Retrieves the output
	 *
	 * @return the output
	 * @throws Lib3MFException
	 */
	public ImplicitPort getOutputResult() throws Lib3MFException {
		Pointer bufferResult = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_matrixfromrowsnode_getoutputresult.invokeInt(new java.lang.Object[]{mHandle, bufferResult}));
		Pointer valueResult = bufferResult.getPointer(0);
		ImplicitPort result = null;
		if (valueResult == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Result was a null pointer");
		}
		result = mWrapper.PolymorphicFactory(valueResult, ImplicitPort.class);
		return result;
	}


}

