/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.idm.ClientPolicyConditionConfigurationRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyEvent;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyVote;
import org.keycloak.services.clientpolicy.condition.AbstractClientPolicyConditionProvider;
import org.keycloak.services.clientpolicy.context.JWTAuthorizationGrantContext;

public class IdentityProviderCondition
extends AbstractClientPolicyConditionProvider<Configuration> {
    public IdentityProviderCondition(KeycloakSession session) {
        super(session);
    }

    public Class<Configuration> getConditionConfigurationClass() {
        return Configuration.class;
    }

    public String getProviderId() {
        return "identity-provider-alias";
    }

    public ClientPolicyVote applyPolicy(ClientPolicyContext context) throws ClientPolicyException {
        return switch (context.getEvent()) {
            case ClientPolicyEvent.JWT_AUTHORIZATION_GRANT -> {
                if (this.isIdentityProvider(((JWTAuthorizationGrantContext)context).getIdentityProvider().getAlias())) {
                    yield ClientPolicyVote.YES;
                }
                yield ClientPolicyVote.NO;
            }
            default -> ClientPolicyVote.ABSTAIN;
        };
    }

    private boolean isIdentityProvider(String identityProviderAlias) throws ClientPolicyException {
        return ((Configuration)this.configuration).identityProviderAliases.contains(identityProviderAlias);
    }

    public static class Configuration
    extends ClientPolicyConditionConfigurationRepresentation {
        @JsonProperty(value="identity_provider_aliases")
        protected List<String> identityProviderAliases;

        public List<String> getIdentityProviderAliases() {
            return this.identityProviderAliases;
        }

        public void setIdentityProviderAliases(List<String> identityProviderAliases) {
            this.identityProviderAliases = identityProviderAliases;
        }
    }
}

