/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import org.keycloak.jose.jwk.JWK;

public class PublicKeyStorageUtils {
    static final JWK.Use DEFAULT_KEYUSE = JWK.Use.SIG;

    public static String getClientModelCacheKey(String realmId, String clientUuid) {
        return PublicKeyStorageUtils.getClientModelCacheKey(realmId, clientUuid, DEFAULT_KEYUSE);
    }

    public static String getIdpModelCacheKey(String realmId, String idpInternalId) {
        return realmId + "::idp::" + idpInternalId;
    }

    public static String getClientModelCacheKey(String realmId, String clientUuid, JWK.Use keyUse) {
        return realmId + "::client::" + clientUuid + "::keyuse::" + String.valueOf(keyUse);
    }
}

