/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import java.util.Arrays;
import java.util.Objects;

public enum KeyProtectionType {
    SOFTWARE(1, "software"),
    HARDWARE(2, "hardware"),
    TEE(4, "tee"),
    SECURE_ELEMENT(8, "secure_element"),
    REMOTE_HANDLE(16, "remote_handle");

    private static final String VALUE_OUT_OF_RANGE_TEMPLATE = "value %s is out of range";
    private final int value;
    private final String string;

    private KeyProtectionType(int value, String string2) {
        this.value = value;
        this.string = string2;
    }

    public static KeyProtectionType create(String value) {
        return Arrays.stream(KeyProtectionType.values()).filter(item -> Objects.equals(item.string, value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format(VALUE_OUT_OF_RANGE_TEMPLATE, value)));
    }

    public static KeyProtectionType create(int value) {
        if (value > 65535 || value < 0) {
            throw new IllegalArgumentException(String.format(VALUE_OUT_OF_RANGE_TEMPLATE, value));
        }
        return Arrays.stream(KeyProtectionType.values()).filter(item -> item.value == value).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format(VALUE_OUT_OF_RANGE_TEMPLATE, value)));
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.string;
    }
}

