/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.console;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Map;
import javajs.util.PT;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.undo.UndoManager;
import org.jmol.api.JmolScriptEditorInterface;
import org.jmol.awt.FileDropper;
import org.jmol.console.JmolConsole;
import org.jmol.i18n.GT;
import org.jmol.script.ScriptContext;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jmolpanel.PreferencesDialog;

public final class ScriptEditor
extends JDialog
implements JmolScriptEditorInterface,
ActionListener,
WindowListener {
    protected EditorTextPane editor;
    private JPanel buttonPanel;
    private JButton openButton;
    private JButton closeButton;
    private JButton loadButton;
    private JButton topButton;
    private JButton fontButton;
    private JButton checkButton;
    private JButton runButton;
    private JButton pauseButton;
    private JButton saveButton;
    private JButton saveAsButton;
    private JButton haltButton;
    private JButton clearButton;
    private JButton stateButton;
    private JButton consoleButton;
    private JButton stepButton;
    private JButton resumeButton;
    private Viewer vwr;
    private int state;
    private static final int STATE_EDITING = 1;
    private static final int STATE_RUNNING = 2;
    private static final int STATE_PAUSED = 3;
    private JmolConsole jmolConsole;
    protected String title;
    protected String parsedData = "";
    protected ScriptContext parsedContext;
    protected SimpleAttributeSet attHighlight;
    protected SimpleAttributeSet attEcho;
    protected SimpleAttributeSet attError;
    protected String filename;
    private Map<String, Object> map;
    private boolean noPrefs;
    private int fontSize;
    private String zipFileName;
    private static String[] lastOpened = new String[]{"?.spt", null};
    int lastIndices;

    public ScriptEditor() {
    }

    ScriptEditor(Viewer vwr, JFrame frame, JmolConsole jmolConsole) {
        super(frame, null, false);
        this.setAttributes();
        this.title = GT.$("Jmol Script Editor");
        this.setTitle(this.title);
        this.vwr = vwr;
        this.jmolConsole = jmolConsole;
        this.layoutWindow(this.getContentPane());
        this.setSize(745, 400);
        if (frame != null) {
            this.setLocationRelativeTo(frame);
        }
    }

    private void setAttributes() {
        this.attHighlight = new SimpleAttributeSet();
        StyleConstants.setBackground(this.attHighlight, Color.LIGHT_GRAY);
        StyleConstants.setForeground(this.attHighlight, Color.blue);
        StyleConstants.setBold(this.attHighlight, true);
        this.attEcho = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attEcho, Color.blue);
        StyleConstants.setBold(this.attEcho, true);
        this.attError = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attError, Color.red);
        StyleConstants.setBold(this.attError, true);
    }

    void layoutWindow(Container container) {
        this.editor = new EditorTextPane();
        this.editor.setDragEnabled(true);
        this.editor.setDropTarget(new DropTarget(this.editor, new FileDropper(null, this.vwr, this)));
        this.editor.setEnabled(true);
        this.editor.setDisabledTextColor(Color.DARK_GRAY);
        this.buttonPanel = new JPanel();
        JScrollPane editorPane = new JScrollPane(this.editor);
        this.updateFontSize();
        this.consoleButton = this.setButton(GT.$("Console"));
        if (!this.vwr.isApplet || this.vwr.getBooleanProperty("_signedApplet")) {
            this.openButton = this.setButton(GT.$("Open"));
        }
        this.fontButton = this.setButton(GT.$("Font"));
        this.loadButton = this.setButton(GT.$("Script"));
        this.checkButton = this.setButton(GT.$("Check"));
        this.topButton = this.setButton(PT.split(GT.$("Top[as in \"go to the top\" - (translators: remove this bracketed part]"), "[")[0]);
        this.runButton = this.setButton(GT.$("Run"));
        this.pauseButton = this.setButton(GT.$("Pause"));
        this.stepButton = this.setButton(GT.$("Step"));
        this.resumeButton = this.setButton(GT.$("Resume"));
        this.haltButton = this.setButton(GT.$("Halt"));
        this.clearButton = this.setButton(GT.$("Clear"));
        this.closeButton = this.setButton(GT.$("Close"));
        this.saveButton = this.setButton(GT.$("Save"));
        this.saveButton.setEnabled(false);
        this.saveAsButton = this.setButton(PT.rep(GT.$("&Save As..."), "&", ""));
        this.saveAsButton.setEnabled(false);
        JPanel buttonPanelWrapper = new JPanel();
        buttonPanelWrapper.setLayout(new BorderLayout());
        buttonPanelWrapper.add((Component)this.buttonPanel, "Center");
        JSplitPane spane = new JSplitPane(0, editorPane, buttonPanelWrapper);
        editorPane.setMinimumSize(new Dimension(300, 300));
        editorPane.setPreferredSize(new Dimension(5000, 5000));
        buttonPanelWrapper.setMinimumSize(new Dimension(60, 60));
        buttonPanelWrapper.setMaximumSize(new Dimension(1000, 60));
        buttonPanelWrapper.setPreferredSize(new Dimension(60, 60));
        spane.setDividerSize(0);
        spane.setResizeWeight(0.95);
        container.add(spane);
    }

    private JButton setButton(String s) {
        JButton b = new JButton(s);
        b.addActionListener(this);
        this.buttonPanel.add(b);
        return b;
    }

    public void notifyScriptStart() {
        this.setState();
    }

    private void setState() {
        this.state = this.vwr.eval.isPaused() ? 3 : (this.vwr.eval.isExecuting() ? 2 : 1);
        this.setEnables();
    }

    private void setEnables() {
        this.editor.setEnabled(this.state == 1);
        this.openButton.setEnabled(this.state == 1);
        this.closeButton.setEnabled(this.state == 1);
        this.loadButton.setEnabled(this.state == 1);
        this.topButton.setEnabled(this.state == 1);
        this.fontButton.setEnabled(this.state == 1);
        this.checkButton.setEnabled(this.state == 1);
        this.runButton.setEnabled(this.state == 1);
        this.pauseButton.setEnabled(this.state == 2);
        this.haltButton.setEnabled(this.state == 2 || this.state == 3);
        this.clearButton.setEnabled(this.state == 1);
        if (this.stateButton != null) {
            this.stateButton.setEnabled(this.state == 1);
        }
        this.consoleButton.setEnabled(true);
        this.stepButton.setEnabled(this.state == 1 || this.state == 3);
        this.resumeButton.setEnabled(this.state == 3);
    }

    public synchronized void notifyScriptTermination(String msg) {
        this.setState();
        String err = this.vwr.eval.getErrorMessage();
        if (err == null) {
            this.editor.editorDoc.clearHighlight();
            this.editor.setCaretPosition(this.editor.editorDoc.getLength());
        } else {
            this.editor.editorDoc.doHighlight(this.lastIndices >> 16, this.lastIndices & 0xFFFF, this.attError);
        }
    }

    @Override
    public void setVisible(boolean b) {
        boolean isChange = b != this.isVisible();
        super.setVisible(b);
        if (isChange) {
            this.vwr.getProperty("DATA_API", "scriptEditorState", b ? Boolean.TRUE : Boolean.FALSE);
        }
        if (b) {
            this.editor.grabFocus();
        }
    }

    public String getText() {
        return this.editor.getText();
    }

    public void output(String message) {
        this.setSaveEnabled(null);
        this.editor.clearContent(message);
    }

    private void setSaveEnabled(String zipName) {
        this.saveButton.setEnabled(zipName != null);
        this.saveAsButton.setEnabled(zipName != null);
        this.zipFileName = zipName;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void notifyContext(ScriptContext context, Object[] data) {
        boolean isOK = context.errorMessage == null;
        this.haltButton.setEnabled(isOK);
        this.pauseButton.setEnabled(isOK);
        this.resumeButton.setEnabled(false);
        this.setState();
        if (isOK) {
            this.setContext(context);
        }
    }

    private synchronized void setContext(ScriptContext context) {
        this.pauseButton.setEnabled(this.vwr.isScriptExecuting());
        if (context.script.indexOf("\u0001## EDITOR_IGNORE ##") >= 0) {
            return;
        }
        this.parsedContext = context;
        this.filename = context.scriptFileName;
        this.setTitle(this.title + this.parsedContext.contextPath);
        if (this.filename == null && context.functionName != null) {
            this.filename = "function " + context.functionName;
        }
        this.parsedData = this.editor.editorDoc.outputEcho(context.script);
        this.setState();
    }

    private void gotoCommand(int pt, SimpleAttributeSet attr) {
        ScriptContext context = this.parsedContext;
        try {
            try {
                int pt2;
                int pt1;
                this.setVisible(true);
                System.out.println(this.editor.getText());
                if (pt < 0) {
                    pt1 = 0;
                    pt2 = this.editor.getDocument().getLength();
                } else if (context == null || context.getTokenCount() < 0) {
                    pt2 = 0;
                    pt1 = 0;
                } else if (pt < context.getTokenCount()) {
                    pt1 = context.lineIndices[pt][0];
                    pt2 = context.lineIndices[pt][1];
                    if (pt1 == pt2 && pt1 >= 2) {
                        pt1 -= 2;
                    }
                } else {
                    pt1 = pt2 = this.editor.getDocument().getLength();
                }
                this.editor.setCaretPosition(pt1);
                this.editor.editorDoc.doHighlight(pt1, pt2, attr);
            }
            catch (Exception e) {
                this.editor.setCaretPosition(0);
            }
        }
        catch (Error error) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.checkAction(e);
    }

    private synchronized void checkAction(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.consoleButton) {
            this.jmolConsole.setVisible(true);
            return;
        }
        if (source == this.openButton) {
            this.doOpen();
            return;
        }
        if (source == this.closeButton) {
            this.setVisible(false);
            return;
        }
        if (source == this.loadButton) {
            this.setContext(this.vwr.getScriptContext("SE loadButton"));
            return;
        }
        if (source == this.topButton) {
            this.gotoTop();
            return;
        }
        if (source == this.fontButton) {
            this.doFont();
            return;
        }
        if (source == this.checkButton) {
            this.checkScript(0);
            return;
        }
        if (source == this.runButton) {
            this.doRun();
            return;
        }
        if (source == this.pauseButton) {
            this.doPause();
            return;
        }
        if (source == this.resumeButton) {
            this.doResume();
            return;
        }
        if (source == this.stepButton) {
            this.doStep();
            return;
        }
        if (source == this.clearButton) {
            this.editor.clearContent();
            return;
        }
        if (source == this.stateButton) {
            this.editor.clearContent(this.vwr.getStateInfo());
            return;
        }
        if (source == this.haltButton) {
            this.doHalt();
            return;
        }
        if (source == this.saveButton) {
            this.saveZip(false);
            return;
        }
        if (source == this.saveAsButton) {
            this.saveZip(true);
            return;
        }
    }

    private void doFont() {
        if (!Viewer.isJS && !this.noPrefs && this.updateFont()) {
            return;
        }
        this.vwr.setConsoleFontScale((this.vwr.getConsoleFontScale() + 1) % 5);
        this.updateFontSize();
    }

    private void doRun() {
        this.notifyScriptStart();
        String s = this.editor.getText();
        this.jmolConsole.execute(s + "\u0001## ISEDITOR");
    }

    private void doPause() {
        this.jmolConsole.execute("!pause\u0001##");
        this.state = 3;
        this.setEnables();
    }

    public void doStep() {
        int len;
        boolean isPaused = this.vwr.eval.isPaused();
        int pos = this.editor.getCaretPosition();
        if (pos == (len = this.editor.getText().length())) {
            pos = 0;
        }
        String s = isPaused ? "!step\u0001##" : this.editor.getText() + "\u0001## ISEDITOR" + "\u0001##SCRIPT_STEP" + "\u0001##SCRIPT_START" + pos;
        System.out.println(s);
        this.jmolConsole.execute(s);
        this.state = 2;
        this.setEnables();
    }

    protected void doResume() {
        this.jmolConsole.execute("!resume\u0001##");
        this.setState();
    }

    private void gotoPosition(int i, int j) {
        this.editor.scrollRectToVisible(new Rectangle(i, j));
    }

    private void doHalt() {
        this.vwr.haltScriptExecution();
        this.setState();
    }

    private boolean updateFont() {
        PreferencesDialog d = null;
        try {
            d = (PreferencesDialog)this.vwr.getProperty("DATA_API", "getPreference", null);
            if (d != null) {
                d.setFontScale(-1);
            }
            return true;
        }
        catch (Exception ee) {
            this.noPrefs = true;
            return false;
        }
    }

    private void saveZip(boolean isAs) {
        if (!isAs) {
            String script = this.editor.getText().trim();
            if (script.startsWith("load ")) {
                script = script.substring(script.indexOf(";") + 1);
            }
            this.map = (Map)this.vwr.fm.getFileAsMap(this.zipFileName, null, false);
            if (this.map == null) {
                return;
            }
            this.map.put("movie.spt", script);
        }
    }

    public void updateFontSize() {
        int scale = Viewer.isJS || this.noPrefs ? this.vwr.getConsoleFontScale() : PT.parseInt("" + (String)this.vwr.getProperty("DATA_API", "getPreference", "consoleFontScale"));
        scale = (scale < 0 ? 1 : scale) % 5;
        this.fontSize = scale * 4 + 12;
        if (this.editor != null) {
            this.editor.setFont(new Font("dialog", 0, this.fontSize));
        }
    }

    private void doOpen() {
        new Thread(){

            @Override
            public void run() {
                ScriptEditor.this.open();
            }
        }.start();
    }

    protected void open() {
        this.vwr.fm.getFileDataAsString(lastOpened, -1, false, false, true);
        this.editor.clearContent(lastOpened[1]);
        ScriptEditor.lastOpened[1] = null;
    }

    public void gotoTop() {
        this.editor.setCaretPosition(0);
        this.editor.grabFocus();
        this.editor.editorDoc.clearHighlight();
        this.gotoPosition(0, 0);
    }

    public void checkScript(int i) {
        if (i == 0) {
            this.parsedContext = null;
        }
        this.parseScript(this.editor.getText(), i);
    }

    protected void parseScript(String text, int i) {
        if (text == null || text.length() == 0) {
            this.parsedContext = null;
            this.parsedData = "";
            this.setTitle(this.title);
            return;
        }
        if (this.parsedContext == null || !text.equals(this.parsedData)) {
            this.parsedData = text;
            this.parsedContext = (ScriptContext)this.vwr.getProperty("DATA_API", "scriptCheck", text);
        }
        this.gotoParsedLine(i);
    }

    private void gotoParsedLine(int i) {
        this.setTitle(this.title + " " + this.parsedContext.contextPath + " -- " + (this.parsedContext.getTokenCount() < 0 ? "" : this.parsedContext.getTokenCount() + " commands ") + (this.parsedContext.iCommandError < 0 ? "" : " ERROR: " + this.parsedContext.errorType));
        boolean isError = i == 0 && this.parsedContext.iCommandError >= 0;
        this.gotoCommand(isError ? this.parsedContext.iCommandError : i, isError ? this.attError : this.attHighlight);
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public void show(String[] fileText) {
        if (fileText != null) {
            if (fileText[1] == null) {
                fileText[1] = "#no data#";
            }
            String filename = fileText[0];
            String msg = fileText[1];
            if (msg != null) {
                this.setFilename(filename);
                this.output(FileManager.getEmbeddedScript(msg));
            }
        }
        this.setVisible(true);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.updateFontSize();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void loadContent(String script) {
        System.out.println("SCRIPT is " + script);
    }

    @Override
    public void loadFile(String fileName) {
        if (FileManager.isEmbeddable(fileName)) {
            try {
                this.setSaveEnabled(fileName);
                this.output(this.vwr.fm.getEmbeddedFileState(fileName, false, "movie.spt"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                String data = this.vwr.fm.getEmbeddedFileState(fileName, false, "state.spt");
                if (data.indexOf("preferredWidthHeight") >= 0) {
                    this.vwr.sm.resizeInnerPanelString(data);
                }
                return;
            }
            catch (Throwable throwable) {}
        } else if (fileName.endsWith("spt")) {
            this.output(this.vwr.getAsciiFileOrNull(fileName));
            return;
        }
    }

    @Override
    public void notify(int msWalltime, Object[] data) {
        if (data == null) {
            this.notifyThisCommand(msWalltime, this.attHighlight);
            return;
        }
        if (msWalltime == Integer.MAX_VALUE) {
            this.notifyFont((Integer)data[0]);
        } else if (msWalltime == 0) {
            this.notifyDone();
        } else if (msWalltime > 0) {
            this.notifyScriptTermination((String)data[1]);
        } else if (msWalltime < 0) {
            if (msWalltime != -1) {
                this.notifyScriptStart();
            }
        } else if (this.isVisible() && ((String)data[2]).length() > 0) {
            this.notifyContext(this.vwr.getScriptContext("SE notify"), data);
        }
        this.setState();
    }

    private void notifyFont(int fontSize) {
        this.editor.setFont(new Font("dialog", 0, fontSize));
    }

    private void notifyDone() {
        this.state = 1;
        this.setState();
    }

    private void notifyThisCommand(int indices, SimpleAttributeSet att) {
        try {
            this.lastIndices = indices;
            this.setState();
            this.editor.editorDoc.clearHighlight();
            this.editor.editorDoc.doHighlight(indices >> 16, indices & 0xFFFF, att);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class EditorDocument
    extends DefaultStyledDocument {
        EditorTextPane EditorTextPane;
        protected UndoManager undo = new UndoManager();

        EditorDocument() {
            this.putProperty("__EndOfLine__", "\n");
            this.addUndoableEditListener(new MyUndoableEditListener());
        }

        void setEditorTextPane(EditorTextPane EditorTextPane2) {
            this.EditorTextPane = EditorTextPane2;
        }

        void doHighlight(int from, int to, SimpleAttributeSet attr) {
            this.clearHighlight();
            if (from >= to) {
                return;
            }
            this.setCharacterAttributes(from, to - from, attr, true);
            ScriptEditor.this.editor.select(from, to);
            ScriptEditor.this.editor.setSelectedTextColor(attr == ScriptEditor.this.attError ? Color.RED : Color.black);
        }

        void clearHighlight() {
            this.setCharacterAttributes(0, ScriptEditor.this.editor.editorDoc.getLength(), ScriptEditor.this.attEcho, true);
        }

        protected void undo() {
            try {
                this.undo.undo();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected void redo() {
            try {
                this.undo.redo();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void clearContent() {
            try {
                super.remove(0, this.getLength());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        String outputEcho(String text) {
            this.clearContent();
            if (text == null) {
                return "";
            }
            int pt = text.indexOf(1);
            if (pt >= 0) {
                text = text.substring(0, pt).trim();
            }
            if (!text.endsWith("\n")) {
                text = text + "\n";
            }
            try {
                super.insertString(0, text, ScriptEditor.this.attEcho);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
            return text;
        }

        protected class MyUndoableEditListener
        implements UndoableEditListener {
            protected MyUndoableEditListener() {
            }

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                EditorDocument.this.undo.addEdit(e.getEdit());
            }
        }
    }

    class EditorTextPane
    extends JTextPane {
        EditorDocument editorDoc;
        boolean checking;

        EditorTextPane() {
            super(new EditorDocument());
            this.checking = false;
            this.editorDoc = (EditorDocument)this.getDocument();
            this.editorDoc.setEditorTextPane(this);
        }

        public void clearContent() {
            ScriptEditor.this.filename = null;
            this.clearContent(null);
        }

        public synchronized void clearContent(String text) {
            this.editorDoc.outputEcho(text);
            ScriptEditor.this.parseScript(text, 0);
        }

        @Override
        protected void processKeyEvent(KeyEvent ke) {
            int kcode = ke.getKeyCode();
            int kid = ke.getID();
            if (kid == 401) {
                switch (kcode) {
                    case 90: {
                        if (!ke.isControlDown()) break;
                        if (ke.isShiftDown()) {
                            ScriptEditor.this.editor.editorDoc.redo();
                        } else {
                            ScriptEditor.this.editor.editorDoc.undo();
                        }
                        return;
                    }
                    case 89: {
                        if (!ke.isControlDown()) break;
                        ScriptEditor.this.editor.editorDoc.redo();
                        return;
                    }
                    case 116: {
                        return;
                    }
                    case 119: {
                        return;
                    }
                }
            }
            super.processKeyEvent(ke);
        }
    }
}

