/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles;

import java.awt.event.ActionEvent;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.EnabledAction;
import org.freeplane.core.ui.SelectableAction;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.MapStyle;

@SelectableAction(checkOnPopup=true, checkOnNodeChange=true)
@EnabledAction(checkOnNodeChange=true)
public class SetBooleanMapPropertyAction
extends AFreeplaneAction {
    private String propertyName;

    public SetBooleanMapPropertyAction(String propertyName) {
        super("SetBooleanMapPropertyAction." + propertyName, TextUtils.getRawText("OptionPanel." + propertyName), null);
        this.propertyName = propertyName;
        this.setIcon(propertyName + ".icon");
        this.setTooltip(this.getTooltipKey());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MapModel map;
        Controller controller = Controller.getCurrentController();
        NodeModel node = controller.getSelection().getSelected();
        ModeController modeController = controller.getModeController();
        MapStyle mapStyleController = MapStyle.getController(modeController);
        String value = mapStyleController.getPropertySetDefault(map = node.getMap(), this.propertyName);
        boolean set = !Boolean.parseBoolean(value);
        mapStyleController.setProperty(map, this.propertyName, Boolean.toString(set));
        this.setSelected(set);
    }

    @Override
    public String getTextKey() {
        return "OptionPanel." + this.propertyName;
    }

    @Override
    public String getTooltipKey() {
        return this.getTextKey() + ".tooltip";
    }

    @Override
    public void setSelected() {
        try {
            Controller controller = Controller.getCurrentController();
            NodeModel node = controller.getSelection().getSelected();
            ModeController modeController = controller.getModeController();
            MapStyle mapStyleController = MapStyle.getController(modeController);
            String value = mapStyleController.getPropertySetDefault(node.getMap(), this.propertyName);
            boolean isSet = Boolean.parseBoolean(value);
            this.setSelected(isSet);
        }
        catch (Exception e) {
            this.setSelected(false);
        }
    }

    @Override
    public void setEnabled() {
        Controller controller = Controller.getCurrentController();
        this.setEnabled(controller.getSelection() != null);
    }
}

