/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.freeplane.core.resources.components.GrabKeyDialog;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.PropertyBean;
import org.freeplane.core.util.TextUtils;

public class KeyProperty
extends PropertyBean
implements IPropertyControl {
    private static RowSpec rowSpec;
    private Icon icon;
    private String labelText;
    JButton mButton = new JButton();
    private int modifierMask = 0;

    public KeyProperty(String name) {
        super(name);
    }

    public KeyProperty(String shortcutKey, String labelText) {
        super(shortcutKey, null, null);
        this.labelText = labelText;
    }

    public void disableModifiers() {
        this.modifierMask = 14;
    }

    @Override
    public String getValue() {
        return this.mButton.getText();
    }

    @Override
    public JComponent getValueComponent() {
        return this.mButton;
    }

    @Override
    public void appendToForm(DefaultFormBuilder builder) {
        this.mButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GrabKeyDialog keyDialog = new GrabKeyDialog(KeyProperty.this.getValue(), KeyProperty.this.modifierMask);
                keyDialog.setVisible(true);
                if (keyDialog.isOK()) {
                    KeyProperty.this.setValue(keyDialog.getShortcut());
                    KeyProperty.this.firePropertyChangeEvent();
                }
            }
        });
        if (this.labelText == null) {
            this.labelText = TextUtils.getOptionalText(this.getLabel());
        }
        JLabel label = new JLabel(this.labelText, this.icon, 4);
        String tooltip = TextUtils.getOptionalText(this.getTooltip());
        label.setToolTipText(tooltip);
        this.setLabelComponent(label);
        if (rowSpec == null) {
            rowSpec = new RowSpec(RowSpec.FILL, (Size)Sizes.dluX((int)20), 0.0);
        }
        if (3 < builder.getColumn()) {
            builder.appendRelatedComponentsGapRow();
            builder.appendRow(rowSpec);
            builder.nextLine(2);
        } else {
            builder.nextColumn(2);
        }
        builder.add((Component)label);
        builder.nextColumn(2);
        builder.add((Component)this.mButton);
        this.mButton.setToolTipText(tooltip);
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        this.mButton.setEnabled(pEnabled);
        super.setEnabled(pEnabled);
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    @Override
    public void setValue(String value) {
        this.mButton.setText(value);
        this.mButton.setToolTipText(this.mButton.getText());
    }
}

