/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.MessageHandler;
import net.sf.freecol.common.networking.NetworkReplyObject;
import net.sf.freecol.common.networking.QuestionMessage;
import net.sf.freecol.common.networking.ReceivingThread;
import net.sf.freecol.common.networking.ReplyMessage;
import net.sf.freecol.common.networking.TrivialMessage;

public class Connection
implements Closeable {
    private static final Logger logger = Logger.getLogger(Connection.class.getName());
    public static final long DEFAULT_REPLY_TIMEOUT = 30000L;
    public static final char END_OF_STREAM = '\n';
    private static final char[] END_OF_STREAM_ARRAY = new char[]{'\n'};
    public static final int BUFFER_SIZE = 16384;
    public static final String NETWORK_REPLY_ID_TAG = "networkReplyId";
    public static final String QUESTION_TAG = "question";
    public static final String REPLY_TAG = "reply";
    public static final String SEND_SUFFIX = "-send";
    public static final String REPLY_SUFFIX = "-reply";
    private static final int TIMEOUT = 5000;
    private String name;
    private final Object socketLock = new Object();
    private Socket socket = null;
    private final Object inputLock = new Object();
    private BufferedReader br;
    private FreeColXMLReader xr;
    private final Object outputLock = new Object();
    private FreeColXMLWriter xw;
    private FreeColXMLWriter lw;
    private ReceivingThread receivingThread;
    private final Object receivingThreadLock = new Object();
    private MessageHandler messageHandler = null;
    private boolean connected = false;

    protected Connection(String name) {
        this.name = name;
        this.setSocket(null);
        this.br = null;
        this.xr = null;
        this.receivingThread = null;
        this.messageHandler = null;
        this.xw = null;
        this.setCommsLogging(FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.COMMS));
        this.connected = false;
    }

    public Connection(Socket socket, String name) throws IOException {
        this(name);
        this.setSocket(socket);
        this.br = new BufferedReader(new InputStreamReader(socket.getInputStream(), StandardCharsets.UTF_8));
        this.receivingThread = new ReceivingThread(this, name);
        this.xw = new FreeColXMLWriter(socket.getOutputStream(), FreeColXMLWriter.WriteScope.toSave(), false);
        this.connected = true;
    }

    public Connection(String host, int port, String name) throws IOException {
        this(Connection.createSocket(host, port), name);
    }

    private static Socket createSocket(String host, int port) throws IOException {
        Socket socket = new Socket();
        InetSocketAddress addr = new InetSocketAddress(host, port);
        socket.connect(addr, 5000);
        return socket;
    }

    public void startReceiving() {
        if (this.receivingThread != null) {
            this.receivingThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket getSocket() {
        Object object = this.socketLock;
        synchronized (object) {
            return this.socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSocket(Socket socket) {
        Object object = this.socketLock;
        synchronized (object) {
            this.socket = socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocket() {
        Object object = this.socketLock;
        synchronized (object) {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException ioe) {
                    logger.log(Level.WARNING, "Error closing socket", ioe);
                }
                finally {
                    this.socket = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeOutputStream() {
        Object object = this.outputLock;
        synchronized (object) {
            if (this.xw != null) {
                this.xw.close();
                this.xw = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInputStream() {
        Object object = this.inputLock;
        synchronized (object) {
            if (this.br != null) {
                try {
                    this.br.close();
                }
                catch (IOException ioe) {
                    logger.log(Level.WARNING, "Error closing buffered input", ioe);
                }
                finally {
                    this.br = null;
                }
            }
        }
    }

    public boolean isAlive() {
        return this.getSocket() != null;
    }

    public String getHostAddress() {
        Socket socket = this.getSocket();
        return socket == null ? "" : socket.getInetAddress().getHostAddress();
    }

    public int getPort() {
        Socket socket = this.getSocket();
        return socket == null ? -1 : socket.getPort();
    }

    public String getSocketName() {
        return this.isAlive() ? this.getHostAddress() + ":" + this.getPort() : "";
    }

    public synchronized MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public synchronized Connection setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWriteScope(FreeColXMLWriter.WriteScope ws) {
        Object object = this.outputLock;
        synchronized (object) {
            if (this.xw != null) {
                this.xw.setWriteScope(ws);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public final Connection setCommsLogging(boolean log) {
        FreeColXMLWriter lw = null;
        if (log) {
            try {
                lw = new FreeColXMLWriter(FreeColDirectories.getLogCommsWriter(), FreeColXMLWriter.WriteScope.toSave(), true);
            }
            catch (IOException | FreeColException ex) {
                lw = null;
                logger.log(Level.WARNING, "Comms logs disabled", ex);
            }
        }
        this.lw = lw;
        return this;
    }

    public void sendDisconnect() {
        try {
            this.send(TrivialMessage.disconnectMessage);
        }
        catch (IOException | XMLStreamException | FreeColException ex) {
            logger.log(Level.WARNING, "Failed to send disconnect", ex);
        }
    }

    public void sendReconnect() {
        try {
            this.send(TrivialMessage.reconnectMessage);
        }
        catch (IOException | XMLStreamException | FreeColException ex) {
            logger.log(Level.WARNING, "Failed to send reconnect", ex);
        }
    }

    public void disconnect() {
        this.connected = false;
        this.sendDisconnect();
        this.close();
    }

    public FreeColXMLReader getFreeColXMLReader() {
        return this.xr;
    }

    public String startListen() throws XMLStreamException {
        String line;
        try {
            line = this.br.readLine();
        }
        catch (IOException ioe) {
            line = null;
        }
        if (line == null) {
            return "disconnect";
        }
        try {
            this.xr = new FreeColXMLReader(new StringReader(line));
        }
        catch (Exception ex) {
            return "disconnect";
        }
        this.xr.nextTag();
        return this.xr.getLocalName();
    }

    public int getReplyId() {
        return this.xr == null ? -1 : this.xr.getAttribute(NETWORK_REPLY_ID_TAG, -1);
    }

    public void endListen() {
        this.xr = null;
    }

    public Message askMessage(Message message, long timeout) throws FreeColException, IOException, XMLStreamException, TimeoutException {
        if (message == null) {
            return null;
        }
        String tag = message.getType();
        if (Thread.currentThread() == this.receivingThread) {
            throw new IOException("wait(ReceivingThread) for: " + tag);
        }
        int replyId = this.receivingThread.getNextNetworkReplyId();
        QuestionMessage qm = new QuestionMessage(replyId, message);
        NetworkReplyObject nro = this.receivingThread.waitForNetworkReply(replyId);
        this.sendMessage(qm);
        Object response = nro.getResponse(timeout);
        if (response == null && !this.connected) {
            return null;
        }
        if (!(response instanceof ReplyMessage)) {
            throw new FreeColException("Bad response to " + replyId + "/" + tag + ": " + response);
        }
        ReplyMessage reply = (ReplyMessage)response;
        this.logMessage(reply, false);
        return reply.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Message message) throws FreeColException, IOException, XMLStreamException {
        if (message == null) {
            return;
        }
        Object object = this.outputLock;
        synchronized (object) {
            if (this.xw == null) {
                return;
            }
            message.toXML(this.xw);
            this.xw.writeCharacters(END_OF_STREAM_ARRAY, 0, END_OF_STREAM_ARRAY.length);
            this.xw.flush();
        }
        this.logMessage(message, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void logMessage(Message message, boolean send) {
        if (this.lw == null || message == null) {
            return;
        }
        try {
            FreeColXMLWriter freeColXMLWriter = this.lw;
            synchronized (freeColXMLWriter) {
                this.lw.writeComment(this.name + (send ? SEND_SUFFIX : REPLY_SUFFIX));
                message.toXML(this.lw);
                this.lw.writeCharacters(END_OF_STREAM_ARRAY, 0, END_OF_STREAM_ARRAY.length);
                this.lw.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Message handle(Message message) throws FreeColException {
        if (message == null) {
            return null;
        }
        MessageHandler mh = this.getMessageHandler();
        return mh == null ? null : mh.handle(this, message);
    }

    public Message reader() throws FreeColException, XMLStreamException {
        if (this.xr == null) {
            return null;
        }
        MessageHandler mh = this.getMessageHandler();
        if (mh == null) {
            throw new FreeColException("No handler at " + this.xr.getLocalName()).preserveDebug();
        }
        return mh.read(this);
    }

    public void request(Message message) throws FreeColException, IOException, XMLStreamException {
        if (message == null) {
            return;
        }
        try {
            Message response = this.askMessage(message, 30000L);
            if (response != null) {
                Message reply = this.handle(response);
                assert (reply == null);
            }
        }
        catch (TimeoutException e) {
            throw new IOException(e);
        }
    }

    public void send(Message message) throws FreeColException, IOException, XMLStreamException {
        if (message != null) {
            this.sendMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.receivingThreadLock;
        synchronized (object) {
            if (this.receivingThread != null) {
                this.receivingThread.askToStop("connection closing");
                this.receivingThread.interrupt();
                this.receivingThread = null;
            }
        }
        this.closeSocket();
        this.closeInputStream();
        this.closeOutputStream();
        logger.fine("Connection closed for " + this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("[Connection ").append(this.name).append(" (").append(this.getSocketName()).append(")]");
        return sb.toString();
    }
}

