/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.datatype;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformer;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformerDescriptor;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.registry.datatype.DataTypeAbstractDescriptor;

public class AttributeTransformerDescriptor
extends DataTypeAbstractDescriptor<DBDAttributeTransformer>
implements DBDAttributeTransformerDescriptor {
    private final String name;
    private final String description;
    private final boolean applyByDefault;
    private final boolean custom;
    private final DBPImage icon;
    private final List<DBPPropertyDescriptor> properties = new ArrayList<DBPPropertyDescriptor>();

    public AttributeTransformerDescriptor(IConfigurationElement config) {
        super(config, DBDAttributeTransformer.class);
        this.name = config.getAttribute("name");
        this.description = config.getAttribute("description");
        this.applyByDefault = "true".equals(config.getAttribute("applyByDefault"));
        this.custom = "true".equals(config.getAttribute("custom"));
        this.icon = this.iconToImage(config.getAttribute("icon"));
        for (IConfigurationElement prop : config.getChildren("propertyGroup")) {
            this.properties.addAll(PropertyDescriptor.extractProperties((IConfigurationElement)prop));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isApplicableByDefault() {
        return this.applyByDefault;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public List<DBPPropertyDescriptor> getProperties() {
        return this.properties;
    }

    public DBPImage getIcon() {
        return this.icon;
    }
}

