/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.Configuration;

public class UpToDateChecker {
    private final Configuration configuration;

    public UpToDateChecker(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean check() {
        try {
            ClassPathEntry classPathEntry;
            int index;
            ModificationTimeChecker checker = new ModificationTimeChecker();
            checker.updateInputModificationTime(this.configuration.lastModified);
            ClassPath programJars = this.configuration.programJars;
            ClassPath libraryJars = this.configuration.libraryJars;
            if (programJars != null) {
                for (index = 0; index < programJars.size(); ++index) {
                    classPathEntry = programJars.get(index);
                    checker.updateModificationTime(classPathEntry.getFile(), classPathEntry.isOutput());
                }
            }
            if (libraryJars != null) {
                for (index = 0; index < libraryJars.size(); ++index) {
                    classPathEntry = libraryJars.get(index);
                    checker.updateModificationTime(classPathEntry.getFile(), false);
                }
            }
            checker.updateInputModificationTime(this.configuration.applyMapping);
            checker.updateInputModificationTime(this.configuration.obfuscationDictionary);
            checker.updateInputModificationTime(this.configuration.classObfuscationDictionary);
            checker.updateInputModificationTime(this.configuration.packageObfuscationDictionary);
            checker.updateOutputModificationTime(this.configuration.printSeeds);
            checker.updateOutputModificationTime(this.configuration.printUsage);
            checker.updateOutputModificationTime(this.configuration.printMapping);
            checker.updateOutputModificationTime(this.configuration.printConfiguration);
            checker.updateOutputModificationTime(this.configuration.dump);
        }
        catch (IllegalStateException e) {
            return false;
        }
        System.out.println("The output seems up to date");
        return true;
    }

    private static class ModificationTimeChecker {
        private long inputModificationTime = Long.MIN_VALUE;
        private long outputModificationTime = Long.MAX_VALUE;

        private ModificationTimeChecker() {
        }

        public void updateInputModificationTime(URL url) {
            if (url != null && url.getProtocol().equals("file")) {
                try {
                    this.updateModificationTime(new File(url.toURI()), false);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }

        public void updateInputModificationTime(File file) {
            if (file != null) {
                this.updateModificationTime(file, false);
            }
        }

        public void updateOutputModificationTime(File file) {
            if (file != null && file.getName().length() > 0) {
                this.updateModificationTime(file, true);
            }
        }

        public void updateModificationTime(File file, boolean isOutput) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files.length == 0 && isOutput) {
                    this.updateOutputModificationTime(Long.MIN_VALUE);
                }
                for (int index = 0; index < files.length; ++index) {
                    this.updateModificationTime(files[index], isOutput);
                }
            } else {
                this.updateModificationTime(file.lastModified(), isOutput);
            }
        }

        public void updateModificationTime(long time, boolean isOutput) {
            if (isOutput) {
                this.updateOutputModificationTime(time);
            } else {
                this.updateInputModificationTime(time);
            }
        }

        public void updateInputModificationTime(long time) {
            if (this.inputModificationTime < time) {
                this.inputModificationTime = time;
                this.checkModificationTimes();
            }
        }

        public void updateOutputModificationTime(long time) {
            if (this.outputModificationTime > time) {
                this.outputModificationTime = time;
                this.checkModificationTimes();
            }
        }

        private void checkModificationTimes() {
            if (this.inputModificationTime > this.outputModificationTime) {
                throw new IllegalStateException("The output is outdated");
            }
        }
    }
}

