﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/lexv2-models/LexModelsV2Request.h>
#include <aws/lexv2-models/LexModelsV2_EXPORTS.h>
#include <aws/lexv2-models/model/BotVersionReplicaSortBy.h>

#include <utility>

namespace Aws {
namespace LexModelsV2 {
namespace Model {

/**
 */
class ListBotVersionReplicasRequest : public LexModelsV2Request {
 public:
  AWS_LEXMODELSV2_API ListBotVersionReplicasRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "ListBotVersionReplicas"; }

  AWS_LEXMODELSV2_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The request for the unique ID in the list of replicated bots.</p>
   */
  inline const Aws::String& GetBotId() const { return m_botId; }
  inline bool BotIdHasBeenSet() const { return m_botIdHasBeenSet; }
  template <typename BotIdT = Aws::String>
  void SetBotId(BotIdT&& value) {
    m_botIdHasBeenSet = true;
    m_botId = std::forward<BotIdT>(value);
  }
  template <typename BotIdT = Aws::String>
  ListBotVersionReplicasRequest& WithBotId(BotIdT&& value) {
    SetBotId(std::forward<BotIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The request for the region used in the list of replicated bots.</p>
   */
  inline const Aws::String& GetReplicaRegion() const { return m_replicaRegion; }
  inline bool ReplicaRegionHasBeenSet() const { return m_replicaRegionHasBeenSet; }
  template <typename ReplicaRegionT = Aws::String>
  void SetReplicaRegion(ReplicaRegionT&& value) {
    m_replicaRegionHasBeenSet = true;
    m_replicaRegion = std::forward<ReplicaRegionT>(value);
  }
  template <typename ReplicaRegionT = Aws::String>
  ListBotVersionReplicasRequest& WithReplicaRegion(ReplicaRegionT&& value) {
    SetReplicaRegion(std::forward<ReplicaRegionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The maximum results given in the list of replicated bots.</p>
   */
  inline int GetMaxResults() const { return m_maxResults; }
  inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
  inline void SetMaxResults(int value) {
    m_maxResultsHasBeenSet = true;
    m_maxResults = value;
  }
  inline ListBotVersionReplicasRequest& WithMaxResults(int value) {
    SetMaxResults(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The next token given in the list of replicated bots.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListBotVersionReplicasRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The requested sort category for the list of replicated bots.</p>
   */
  inline const BotVersionReplicaSortBy& GetSortBy() const { return m_sortBy; }
  inline bool SortByHasBeenSet() const { return m_sortByHasBeenSet; }
  template <typename SortByT = BotVersionReplicaSortBy>
  void SetSortBy(SortByT&& value) {
    m_sortByHasBeenSet = true;
    m_sortBy = std::forward<SortByT>(value);
  }
  template <typename SortByT = BotVersionReplicaSortBy>
  ListBotVersionReplicasRequest& WithSortBy(SortByT&& value) {
    SetSortBy(std::forward<SortByT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_botId;

  Aws::String m_replicaRegion;

  int m_maxResults{0};

  Aws::String m_nextToken;

  BotVersionReplicaSortBy m_sortBy;
  bool m_botIdHasBeenSet = false;
  bool m_replicaRegionHasBeenSet = false;
  bool m_maxResultsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_sortByHasBeenSet = false;
};

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
