﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/lookoutequipment/LookoutEquipment_EXPORTS.h>
#include <aws/lookoutequipment/model/InferenceSchedulerStatus.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace LookoutEquipment {
namespace Model {
class StopInferenceSchedulerResult {
 public:
  AWS_LOOKOUTEQUIPMENT_API StopInferenceSchedulerResult() = default;
  AWS_LOOKOUTEQUIPMENT_API StopInferenceSchedulerResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_LOOKOUTEQUIPMENT_API StopInferenceSchedulerResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the machine learning model used by the
   * inference scheduler being stopped. </p>
   */
  inline const Aws::String& GetModelArn() const { return m_modelArn; }
  template <typename ModelArnT = Aws::String>
  void SetModelArn(ModelArnT&& value) {
    m_modelArnHasBeenSet = true;
    m_modelArn = std::forward<ModelArnT>(value);
  }
  template <typename ModelArnT = Aws::String>
  StopInferenceSchedulerResult& WithModelArn(ModelArnT&& value) {
    SetModelArn(std::forward<ModelArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the machine learning model used by the inference scheduler being
   * stopped. </p>
   */
  inline const Aws::String& GetModelName() const { return m_modelName; }
  template <typename ModelNameT = Aws::String>
  void SetModelName(ModelNameT&& value) {
    m_modelNameHasBeenSet = true;
    m_modelName = std::forward<ModelNameT>(value);
  }
  template <typename ModelNameT = Aws::String>
  StopInferenceSchedulerResult& WithModelName(ModelNameT&& value) {
    SetModelName(std::forward<ModelNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the inference scheduler being stopped. </p>
   */
  inline const Aws::String& GetInferenceSchedulerName() const { return m_inferenceSchedulerName; }
  template <typename InferenceSchedulerNameT = Aws::String>
  void SetInferenceSchedulerName(InferenceSchedulerNameT&& value) {
    m_inferenceSchedulerNameHasBeenSet = true;
    m_inferenceSchedulerName = std::forward<InferenceSchedulerNameT>(value);
  }
  template <typename InferenceSchedulerNameT = Aws::String>
  StopInferenceSchedulerResult& WithInferenceSchedulerName(InferenceSchedulerNameT&& value) {
    SetInferenceSchedulerName(std::forward<InferenceSchedulerNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the inference schedule being stopped. </p>
   */
  inline const Aws::String& GetInferenceSchedulerArn() const { return m_inferenceSchedulerArn; }
  template <typename InferenceSchedulerArnT = Aws::String>
  void SetInferenceSchedulerArn(InferenceSchedulerArnT&& value) {
    m_inferenceSchedulerArnHasBeenSet = true;
    m_inferenceSchedulerArn = std::forward<InferenceSchedulerArnT>(value);
  }
  template <typename InferenceSchedulerArnT = Aws::String>
  StopInferenceSchedulerResult& WithInferenceSchedulerArn(InferenceSchedulerArnT&& value) {
    SetInferenceSchedulerArn(std::forward<InferenceSchedulerArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates the status of the inference scheduler. </p>
   */
  inline InferenceSchedulerStatus GetStatus() const { return m_status; }
  inline void SetStatus(InferenceSchedulerStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline StopInferenceSchedulerResult& WithStatus(InferenceSchedulerStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  StopInferenceSchedulerResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_modelArn;

  Aws::String m_modelName;

  Aws::String m_inferenceSchedulerName;

  Aws::String m_inferenceSchedulerArn;

  InferenceSchedulerStatus m_status{InferenceSchedulerStatus::NOT_SET};

  Aws::String m_requestId;
  bool m_modelArnHasBeenSet = false;
  bool m_modelNameHasBeenSet = false;
  bool m_inferenceSchedulerNameHasBeenSet = false;
  bool m_inferenceSchedulerArnHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace LookoutEquipment
}  // namespace Aws
